/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.soundmuffler.gui;

import edgarallen.soundmuffler.SuperSoundMuffler;
import edgarallen.soundmuffler.gui.data.IMufflerAccessor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.CoreModManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiSoundMufflerAddSound
extends GuiContainer {
    private static final ResourceLocation guiTexture = new ResourceLocation("supersoundmuffler", "textures/gui/sound_muffler_add_sound.png");
    private static final int KEYCODE_ENTER = 28;
    private static final int KEYCODE_KP_ENTER = 156;
    private static final int TEXT_COLOR_FOCUSED = 0xE0E0E0;
    private static final int TEXT_COLOR_ACTIVE = 0xAAAAAA;
    private static final int TEXT_COLOR_DISABLED = 0x404040;
    private final GuiScreen prevScreen;
    private final IMufflerAccessor muffler;
    private GuiButtonExt allSoundsButton;
    private GuiButtonExt recentSoundsButton;
    private GuiButtonExt addSoundButton;
    private GuiButtonExt cancelButton;
    private GuiTextField searchField;
    private GuiSoundList soundList;
    private String lastFilterText = "";
    private boolean showAllSounds = true;
    private final List<ResourceLocation> recentSounds;
    private List<ResourceLocation> allSounds;

    GuiSoundMufflerAddSound(GuiScreen prevScreen, IMufflerAccessor muffler, List<ResourceLocation> recentSounds) {
        super(new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return false;
            }
        });
        this.field_146999_f = 256;
        this.field_147000_g = 170;
        this.prevScreen = prevScreen;
        this.muffler = muffler;
        this.recentSounds = recentSounds;
        this.lazyLoadAllSoundsList();
    }

    private void lazyLoadAllSoundsList() {
        this.allSounds = new ArrayList<ResourceLocation>();
        this.allSounds.addAll(this.getSoundList());
        this.allSounds.sort(Comparator.comparing(ResourceLocation::toString));
    }

    private Set<ResourceLocation> getSoundList() {
        boolean isDeobf = false;
        try {
            Field f = CoreModManager.class.getDeclaredField("deobfuscatedEnvironment");
            f.setAccessible(true);
            isDeobf = f.getBoolean(null);
        }
        catch (Throwable t) {
            SuperSoundMuffler.log.error("Are we in a dev environment? No clue... Error'd before I could find out. RIP", t);
        }
        Set sounds = Collections.EMPTY_SET;
        try {
            Field f = SoundHandler.class.getDeclaredField(isDeobf ? "soundRegistry" : "field_147697_e");
            f.setAccessible(true);
            SoundRegistry registry = (SoundRegistry)f.get(Minecraft.func_71410_x().func_147118_V());
            if (registry != null) {
                sounds = registry.func_148742_b();
            }
        }
        catch (Throwable t) {
            SuperSoundMuffler.log.error("Couldn't access sound registry for sounds list", t);
        }
        return sounds;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.allSoundsButton = new GuiButtonExt(0, this.field_147003_i + 159, this.field_147009_r + 5, 44, 14, I18n.func_135052_a((String)"tile.sound_muffler.add_sound.gui.button.all", (Object[])new Object[0]));
        this.field_146292_n.add(this.allSoundsButton);
        this.allSoundsButton.field_146124_l = false;
        this.recentSoundsButton = new GuiButtonExt(1, this.field_147003_i + 205, this.field_147009_r + 5, 44, 14, I18n.func_135052_a((String)"tile.sound_muffler.add_sound.gui.button.recent", (Object[])new Object[0]));
        this.field_146292_n.add(this.recentSoundsButton);
        this.addSoundButton = new GuiButtonExt(2, this.field_147003_i + 159, this.field_147009_r + 151, 44, 14, I18n.func_135052_a((String)"tile.sound_muffler.add_sound.gui.button.add", (Object[])new Object[0]));
        this.field_146292_n.add(this.addSoundButton);
        this.addSoundButton.field_146124_l = false;
        this.cancelButton = new GuiButtonExt(3, this.field_147003_i + 205, this.field_147009_r + 151, 44, 14, I18n.func_135052_a((String)"tile.sound_muffler.add_sound.gui.button.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(this.cancelButton);
        this.soundList = new GuiSoundList(240, 112, this.field_147009_r + 22, this.field_147009_r + 134, this.field_147003_i + 8, 14);
        this.soundList.setSounds(this.allSounds);
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchField = new GuiTextField(2, this.field_146289_q, this.field_147003_i + 11, this.field_147009_r + 139, 232, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(256);
        this.searchField.func_146185_a(false);
        this.searchField.func_146193_g(0xE0E0E0);
        this.searchField.func_146205_d(true);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.recentSoundsButton.field_146127_k) {
                this.recentSoundsButton.field_146124_l = false;
                this.allSoundsButton.field_146124_l = true;
                this.showAllSounds = false;
                this.updateSoundsList(this.recentSounds);
                return;
            }
            if (button.field_146127_k == this.allSoundsButton.field_146127_k) {
                this.allSoundsButton.field_146124_l = false;
                this.recentSoundsButton.field_146124_l = true;
                this.showAllSounds = true;
                this.updateSoundsList(this.allSounds);
                return;
            }
            if (button.field_146127_k == this.addSoundButton.field_146127_k) {
                List<ResourceLocation> selectedSounds = this.soundList.getSelectedSounds();
                for (ResourceLocation sound : selectedSounds) {
                    if (sound == null) continue;
                    this.muffler.muffleSound(sound);
                }
                this.field_146297_k.func_147108_a(this.prevScreen);
                return;
            }
            if (button.field_146127_k == this.cancelButton.field_146127_k) {
                this.field_146297_k.func_147108_a(this.prevScreen);
                return;
            }
        }
        super.func_146284_a(button);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.searchField.func_146178_a();
        if (!this.searchField.func_146179_b().equals(this.lastFilterText)) {
            this.lastFilterText = this.searchField.func_146179_b();
            this.updateSoundsList(this.showAllSounds ? this.allSounds : this.recentSounds);
        }
        this.addSoundButton.field_146124_l = this.soundList.hasSelectedElements();
    }

    private void updateSoundsList(List<ResourceLocation> sounds) {
        if (this.lastFilterText.isEmpty()) {
            this.soundList.setSounds(sounds);
        } else {
            this.soundList.setSounds(sounds.stream().filter(sound -> sound.toString().toLowerCase().contains(this.lastFilterText.toLowerCase())).collect(Collectors.toList()));
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.searchField.func_146192_a(x, y, button);
        if (button == 1 && x >= this.searchField.field_146209_f && x < this.searchField.field_146209_f + this.searchField.field_146218_h && y >= this.searchField.field_146210_g && y < this.searchField.field_146210_g + this.searchField.field_146219_i) {
            this.searchField.func_146180_a("");
        }
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        this.soundList.handleMouseInput(mouseX, mouseY);
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        if (keyCode != 28 && keyCode != 156) {
            if (!this.searchField.func_146201_a(c, keyCode)) {
                super.func_73869_a(c, keyCode);
            }
        } else if (this.searchField.func_146206_l()) {
            this.searchField.func_146195_b(false);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tile.sound_muffler.add_sound.gui.title", (Object[])new Object[0]), 8, 9, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        RenderHelper.func_74518_a();
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        this.func_73729_b(xPos, yPos, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawSearchField();
        this.soundList.drawScreen(mouseX, mouseY, partialTicks);
        RenderHelper.func_74519_b();
    }

    private void drawSearchField() {
        if (this.searchField.func_146179_b().isEmpty() && !this.searchField.func_146206_l()) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tile.sound_muffler.add_sound.gui.search", (Object[])new Object[0]), this.field_147003_i + 11, this.field_147009_r + 139, 0x404040);
        } else {
            this.searchField.func_146193_g(this.searchField.func_146206_l() ? 0xE0E0E0 : 0xAAAAAA);
            this.searchField.func_146194_f();
        }
    }

    private final class GuiSoundList
    extends GuiScrollingList {
        private List<ResourceLocation> sounds;
        private final int slotHeight;
        private List<Integer> selectedIndicies;

        GuiSoundList(int width, int height, int top, int bottom, int left, int slotHeight) {
            super(Minecraft.func_71410_x(), width, height, top, bottom, left, slotHeight, width, height);
            this.selectedIndicies = new ArrayList<Integer>();
            this.slotHeight = slotHeight;
        }

        protected int getSize() {
            return this.sounds.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            if (GuiScreen.func_146271_m()) {
                if (this.isSelected(index)) {
                    this.removeSelection(index);
                } else {
                    this.selectIndex(index);
                }
            } else if (GuiScreen.func_146272_n()) {
                this.clearSelection();
                int start = index > this.selectedIndex ? this.selectedIndex : index;
                int end = index > this.selectedIndex ? index : this.selectedIndex;
                this.selectRange(start, end);
            } else {
                this.clearSelection();
                this.selectIndex(index);
            }
        }

        protected boolean isSelected(int index) {
            for (int i : this.selectedIndicies) {
                if (i != index) continue;
                return true;
            }
            return false;
        }

        void removeSelection(int index) {
            for (int i = 0; i < this.selectedIndicies.size(); ++i) {
                if (this.selectedIndicies.get(i) != index) continue;
                this.selectedIndicies.remove(i);
                return;
            }
        }

        void selectIndex(int index) {
            this.removeSelection(index);
            this.selectedIndicies.add(index);
            this.selectedIndex = index;
        }

        void clearSelection() {
            this.selectedIndicies.clear();
        }

        void selectRange(int start, int end) {
            for (int i = start; i <= end; ++i) {
                this.selectedIndicies.add(i);
            }
            this.selectedIndex = end;
        }

        protected void drawBackground() {
        }

        protected int getContentHeight() {
            return this.getSize() * this.slotHeight + 1;
        }

        protected void drawSlot(int idx, int right, int top, int height, Tessellator tess) {
            ResourceLocation sound = this.sounds.get(idx);
            GuiSoundMufflerAddSound.this.field_146289_q.func_78276_b(GuiSoundMufflerAddSound.this.field_146289_q.func_78269_a(sound.toString(), this.listWidth - 10), this.left + 3, top + 2, 0xCCCCCC);
        }

        void setSounds(List<ResourceLocation> sounds) {
            this.sounds = sounds;
            this.selectedIndex = -1;
            this.selectedIndicies.clear();
        }

        boolean hasSelectedElements() {
            return this.selectedIndicies.size() > 0;
        }

        List<ResourceLocation> getSelectedSounds() {
            ArrayList<ResourceLocation> ret = new ArrayList<ResourceLocation>();
            for (int i : this.selectedIndicies) {
                ret.add(this.sounds.get(i));
            }
            return ret;
        }
    }
}

