/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class TemporaryFiles {
    private static final Set<Path> DELETE_SET = Collections.synchronizedSet(new HashSet());

    private TemporaryFiles() {
    }

    public static Path create(String prefix, String suffix) throws IOException {
        return TemporaryFiles.register(Files.createTempFile(prefix, suffix, new FileAttribute[0]));
    }

    public static Path register(Path path) {
        path.toFile().deleteOnExit();
        DELETE_SET.add(path);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTemporaryFiles() {
        Set<Path> set = DELETE_SET;
        synchronized (set) {
            Iterator<Path> iterator = DELETE_SET.iterator();
            while (iterator.hasNext()) {
                Path path = iterator.next();
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                iterator.remove();
            }
        }
    }
}

