/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import me.lucko.spark.api.statistic.misc.DoubleAverageInfo;

public class RollingAverage
implements DoubleAverageInfo {
    private final Queue<BigDecimal> samples;
    private final int windowSize;
    private BigDecimal total = BigDecimal.ZERO;

    public RollingAverage(int windowSize) {
        this.windowSize = windowSize;
        this.samples = new ArrayDeque<BigDecimal>(this.windowSize + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BigDecimal num) {
        RollingAverage rollingAverage = this;
        synchronized (rollingAverage) {
            this.total = this.total.add(num);
            this.samples.add(num);
            if (this.samples.size() > this.windowSize) {
                this.total = this.total.subtract(this.samples.remove());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double mean() {
        RollingAverage rollingAverage = this;
        synchronized (rollingAverage) {
            if (this.samples.isEmpty()) {
                return 0.0;
            }
            BigDecimal divisor = BigDecimal.valueOf(this.samples.size());
            return this.total.divide(divisor, 30, RoundingMode.HALF_UP).doubleValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double max() {
        RollingAverage rollingAverage = this;
        synchronized (rollingAverage) {
            BigDecimal max = null;
            for (BigDecimal sample : this.samples) {
                if (max != null && sample.compareTo(max) <= 0) continue;
                max = sample;
            }
            return max == null ? 0.0 : max.doubleValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double min() {
        RollingAverage rollingAverage = this;
        synchronized (rollingAverage) {
            BigDecimal min = null;
            for (BigDecimal sample : this.samples) {
                if (min != null && sample.compareTo(min) >= 0) continue;
                min = sample;
            }
            return min == null ? 0.0 : min.doubleValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double percentile(double percentile) {
        Object[] sortedSamples;
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("Invalid percentile " + percentile);
        }
        RollingAverage rollingAverage = this;
        synchronized (rollingAverage) {
            if (this.samples.isEmpty()) {
                return 0.0;
            }
            sortedSamples = this.samples.toArray(new BigDecimal[0]);
        }
        Arrays.sort(sortedSamples);
        int rank = (int)Math.ceil(percentile * (double)(sortedSamples.length - 1));
        return ((BigDecimal)sortedSamples[rank]).doubleValue();
    }
}

