/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class Configuration {
    private static final JsonParser PARSER = new JsonParser();
    private final JsonObject root;

    public Configuration(Path file) {
        JsonObject root = null;
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                root = PARSER.parse((Reader)reader).getAsJsonObject();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.root = root != null ? root : new JsonObject();
    }

    public String getString(String path, String def) {
        JsonElement el = this.root.get(path);
        if (el == null || !el.isJsonPrimitive()) {
            return def;
        }
        return el.getAsJsonPrimitive().getAsString();
    }

    public boolean getBoolean(String path, boolean def) {
        JsonElement el = this.root.get(path);
        if (el == null || !el.isJsonPrimitive()) {
            return def;
        }
        JsonPrimitive val = el.getAsJsonPrimitive();
        return val.isBoolean() ? val.getAsBoolean() : def;
    }
}

