/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.node.StackTraceNode;

public abstract class AbstractNode {
    private static final int MAX_STACK_DEPTH = 300;
    private final Map<StackTraceNode.Description, StackTraceNode> children = new ConcurrentHashMap<StackTraceNode.Description, StackTraceNode>();
    private final LongAdder totalTime = new LongAdder();

    public double getTotalTime() {
        return (double)this.totalTime.longValue() / 1000.0;
    }

    public Collection<StackTraceNode> getChildren() {
        return this.children.values();
    }

    public <T> void log(StackTraceNode.Describer<T> describer, T[] stack, long time) {
        if (stack.length == 0) {
            return;
        }
        this.totalTime.add(time);
        AbstractNode node = this;
        Object previousElement = null;
        for (int offset = 0; offset < Math.min(300, stack.length); ++offset) {
            T element = stack[stack.length - 1 - offset];
            node = node.resolveChild(describer.describe(element, previousElement));
            node.totalTime.add(time);
            previousElement = element;
        }
    }

    private StackTraceNode resolveChild(StackTraceNode.Description description) {
        StackTraceNode result = this.children.get(description);
        if (result != null) {
            return result;
        }
        return this.children.computeIfAbsent(description, StackTraceNode::new);
    }

    protected void merge(AbstractNode other) {
        this.totalTime.add(other.totalTime.longValue());
        for (Map.Entry<StackTraceNode.Description, StackTraceNode> child : other.children.entrySet()) {
            this.resolveChild(child.getKey()).merge(child.getValue());
        }
    }

    protected List<StackTraceNode> exportChildren(MergeMode mergeMode) {
        if (this.children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StackTraceNode> list = new ArrayList<StackTraceNode>(this.children.size());
        block0: for (StackTraceNode child : this.children.values()) {
            for (StackTraceNode other : list) {
                if (!mergeMode.shouldMerge(other, child)) continue;
                other.merge(child);
                continue block0;
            }
            list.add(child);
        }
        list.sort(null);
        return list;
    }
}

