/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import me.lucko.spark.common.activitylog.Activity;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.command.CommandModule;
import me.lucko.spark.common.command.CommandResponseHandler;
import me.lucko.spark.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.event.ClickEvent;
import me.lucko.spark.lib.adventure.text.feature.pagination.Pagination;
import me.lucko.spark.lib.adventure.text.format.NamedTextColor;
import me.lucko.spark.lib.adventure.text.format.TextColor;
import me.lucko.spark.lib.adventure.text.format.TextDecoration;

public class ActivityLogModule
implements CommandModule,
Pagination.Renderer.RowRenderer<Activity> {
    private final Pagination.Builder pagination = Pagination.builder().renderer(new Pagination.Renderer(){

        @Override
        public Component renderEmpty() {
            return CommandResponseHandler.applyPrefix(Component.text("There are no entries present in the log."));
        }

        @Override
        public Component renderUnknownPage(int page, int pages) {
            return CommandResponseHandler.applyPrefix(Component.text("Unknown page selected. " + pages + " total pages."));
        }
    }).resultsPerPage(4);

    @Override
    public Collection<Component> renderRow(Activity activity, int index) {
        ArrayList<Component> reply = new ArrayList<Component>(5);
        reply.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(">", (TextColor)NamedTextColor.DARK_GRAY, TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text("#" + (index + 1), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text(" - ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(activity.getType(), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text(" - ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(ActivityLogModule.formatDateDiff(activity.getTime()), (TextColor)NamedTextColor.GRAY))).build());
        reply.add((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("  ").append((Component)Component.text("Created by: ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text(activity.getUser().getName(), (TextColor)NamedTextColor.WHITE))).build());
        TextComponent.Builder valueComponent = (TextComponent.Builder)Component.text().content(activity.getDataValue()).color(NamedTextColor.WHITE);
        if (activity.getDataType().equals("url")) {
            valueComponent.clickEvent(ClickEvent.openUrl(activity.getDataValue()));
        }
        reply.add((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("  ").append((Component)Component.text(Character.toUpperCase(activity.getDataType().charAt(0)) + activity.getDataType().substring(1) + ": ", (TextColor)NamedTextColor.GRAY))).append(valueComponent)).build());
        reply.add(Component.space());
        return reply;
    }

    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("activity", "activitylog", "log").argumentUsage("page", "page no").executor((platform, sender, resp, arguments) -> {
            List<Activity> log = platform.getActivityLog().getLog();
            log.removeIf(Activity::shouldExpire);
            if (log.isEmpty()) {
                resp.replyPrefixed(Component.text("There are no entries present in the log."));
                return;
            }
            int page = Math.max(1, arguments.intFlag("page"));
            Pagination<Activity> activityPagination = this.pagination.build(Component.text("Recent spark activity", (TextColor)NamedTextColor.GOLD), this, value -> "/" + platform.getPlugin().getCommandName() + " activity --page " + value);
            activityPagination.render(log, page).forEach(resp::reply);
        }).tabCompleter((platform, sender, arguments) -> TabCompleter.completeForOpts(arguments, "--page")).build());
    }

    private static String formatDateDiff(long time) {
        long seconds = (System.currentTimeMillis() - time) / 1000L;
        if (seconds <= 0L) {
            return "now";
        }
        long minute = seconds / 60L;
        seconds %= 60L;
        long hour = minute / 60L;
        minute %= 60L;
        long day = hour / 24L;
        hour %= 24L;
        StringBuilder sb = new StringBuilder();
        if (day != 0L) {
            sb.append(day).append("d ");
        }
        if (hour != 0L) {
            sb.append(hour).append("h ");
        }
        if (minute != 0L) {
            sb.append(minute).append("m ");
        }
        if (seconds != 0L) {
            sb.append(seconds).append("s");
        }
        return sb.toString().trim() + " ago";
    }
}

