/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.monitor.LiquidMonitorBlockTileEntity;
import mcjty.rftools.blocks.monitor.RFMonitorBlockTileEntity;
import mcjty.rftools.blocks.monitor.RFMonitorMode;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketContentsMonitor
implements IMessage {
    private BlockPos pos;
    private BlockPos monitor;
    private int alarmLevel;
    private RFMonitorMode alarmMode;

    public PacketContentsMonitor() {
        this.monitor = null;
        this.alarmLevel = -1;
        this.alarmMode = RFMonitorMode.MODE_OFF;
    }

    public PacketContentsMonitor(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketContentsMonitor(BlockPos pos, BlockPos monitor) {
        this();
        this.pos = pos;
        this.monitor = monitor;
    }

    public PacketContentsMonitor(BlockPos pos, RFMonitorMode alarmMode, int alarmLevel) {
        this();
        this.pos = pos;
        this.alarmLevel = alarmLevel;
        this.alarmMode = alarmMode;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        boolean r = buf.readBoolean();
        if (r) {
            this.monitor = NetworkTools.readPos((ByteBuf)buf);
        }
        this.alarmLevel = buf.readByte();
        this.alarmMode = RFMonitorMode.getModeFromIndex(buf.readByte());
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        if (this.monitor == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.monitor);
        }
        buf.writeByte(this.alarmLevel);
        buf.writeByte(this.alarmMode.getIndex());
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().func_130014_f_().func_175625_s(this.pos);
            if (te instanceof RFMonitorBlockTileEntity) {
                RFMonitorBlockTileEntity monitorBlockTileEntity = (RFMonitorBlockTileEntity)te;
                if (this.monitor != null) {
                    monitorBlockTileEntity.setMonitor(this.monitor);
                }
                if (this.alarmLevel != -1) {
                    monitorBlockTileEntity.setAlarm(this.alarmMode, this.alarmLevel);
                }
            } else if (te instanceof LiquidMonitorBlockTileEntity) {
                LiquidMonitorBlockTileEntity liquidMonitorBlockTileEntity = (LiquidMonitorBlockTileEntity)te;
                if (this.monitor != null) {
                    liquidMonitorBlockTileEntity.setMonitor(this.monitor);
                }
                if (this.alarmLevel != -1) {
                    liquidMonitorBlockTileEntity.setAlarm(this.alarmMode, this.alarmLevel);
                }
            } else {
                Logging.log((String)"TileEntity is not a RFMonitorBlockTileEntity!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

