/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.generator;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.generator.CoalGeneratorConfiguration;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CoalGeneratorTileEntity
extends GenericEnergyStorageTileEntity
implements ITickable,
DefaultSidedInventory,
IMachineInformation {
    public static final String CMD_RSMODE = "coalgen.setRsMode";
    public static final PropertyBool WORKING = PropertyBool.func_177716_a((String)"working");
    public static final int SLOT_COALINPUT = 0;
    public static final int SLOT_CHARGEITEM = 1;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(new ResourceLocation("rftools", "gui/coalgenerator.gui"));
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 2);
    private int burning;

    public CoalGeneratorTileEntity() {
        super((long)CoalGeneratorConfiguration.MAXENERGY.get(), (long)CoalGeneratorConfiguration.SENDPERTICK.get());
    }

    public long getEnergyDiffPerTick() {
        return this.burning > 0 ? this.getRfPerTick() : 0L;
    }

    @Nullable
    public String getEnergyUnitName() {
        return "RF";
    }

    public boolean isMachineActive() {
        return this.isMachineEnabled();
    }

    public boolean isMachineRunning() {
        return this.isMachineEnabled();
    }

    @Nullable
    public String getMachineStatus() {
        return this.burning > 0 ? "generating power" : "idle";
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed) {
            this.markDirtyClient();
        }
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            boolean working;
            this.handleChargingItem();
            this.handleSendingEnergy();
            if (!this.isMachineEnabled()) {
                return;
            }
            boolean bl = working = this.burning > 0;
            if (this.burning > 0) {
                --this.burning;
                long rf = this.getRfPerTick();
                this.modifyEnergyStored(rf);
                if (this.burning == 0) {
                    this.markDirtyClient();
                } else {
                    this.func_70296_d();
                }
                return;
            }
            if (this.inventoryHelper.containsItem(0)) {
                ItemStack extracted = this.inventoryHelper.decrStackSize(0, 1);
                this.burning = CoalGeneratorConfiguration.ticksPerCoal.get();
                if (extracted.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
                    this.burning *= 9;
                }
                this.burning += (int)((float)this.burning * this.getInfusedFactor() / 2.0f);
                if (working) {
                    this.func_70296_d();
                } else {
                    this.markDirtyClient();
                }
            } else if (working) {
                this.markDirtyClient();
            }
        }
    }

    public long getRfPerTick() {
        long rf = CoalGeneratorConfiguration.rfPerTick.get();
        rf += (long)((float)rf * this.getInfusedFactor());
        return rf;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean newWorking;
        boolean working = this.isWorking();
        super.onDataPacket(net, packet);
        if (this.func_145831_w().field_72995_K && (newWorking = this.isWorking()) != working) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public boolean isWorking() {
        return this.burning > 0 && this.isMachineEnabled();
    }

    private void handleChargingItem() {
        ItemStack stack = this.inventoryHelper.getStackInSlot(1);
        if (stack.func_190926_b()) {
            return;
        }
        long storedPower = this.getStoredPower();
        long rfToGive = Math.min((long)CoalGeneratorConfiguration.CHARGEITEMPERTICK.get(), storedPower);
        long received = EnergyTools.receiveEnergy((ItemStack)stack, (long)rfToGive);
        this.storage.extractEnergy(received, false);
    }

    private void handleSendingEnergy() {
        long storedPower = this.getStoredPower();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            long rfToGive;
            long received;
            EnumFacing opposite;
            BlockPos pos = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(pos);
            if (EnergyTools.isEnergyTE((TileEntity)te, (EnumFacing)(opposite = facing.func_176734_d())) && (storedPower -= this.storage.extractEnergy(received = EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (long)(rfToGive = Math.min((long)CoalGeneratorConfiguration.SENDPERTICK.get(), storedPower))), false)) <= 0L) break;
        }
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 1) {
            return EnergyTools.isEnergyItem((ItemStack)stack);
        }
        if (index == 0) {
            return stack.func_77973_b() == Items.field_151044_h || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150402_ci);
        }
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.burning = tagCompound.func_74762_e("burning");
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("burning", this.burning);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            this.setRSMode(RedstoneMode.values()[(Integer)params.get(ImageChoiceLabel.PARAM_CHOICE_IDX)]);
            return true;
        }
        return false;
    }

    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf(this.isWorking()));
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        Boolean working = this.isWorking();
        if (working.booleanValue()) {
            probeInfo.text(TextFormatting.GREEN + "Producing " + this.getRfPerTick() + " RF/t");
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
        if (this.isWorking()) {
            currenttip.add(TextFormatting.GREEN + "Producing " + this.getRfPerTick() + " RF/t");
        }
    }
}

