/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.entropyaccelerator;

import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.impl.EnergyStorage;
import javax.annotation.Nullable;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.blocks.TileSimpleInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntropyAccelerator
extends TileSimpleInventory
implements IEnergyProvider,
IEnergyStorage,
ITickable {
    private int currentBurnTime = 0;
    private EnergyStorage energy;
    public int maxBurnTime = ConfigMan.incinerator_burnTime;
    public boolean isBurning = false;

    public TileEntropyAccelerator() {
        super(1);
        this.energy = new EnergyStorage(ConfigMan.incinerator_buffer, Integer.MAX_VALUE, ConfigMan.incinerator_output);
    }

    public boolean isActive() {
        return (this.hasFuel() || this.isBurning) && this.energy.getEnergyStored() < this.energy.getMaxEnergyStored();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74777_a("currentBurnTime", (short)this.currentBurnTime);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energy.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
        tag.func_74757_a("Burning", this.isBurning);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound energyTag = tag.func_74775_l("Energy");
        this.currentBurnTime = tag.func_74765_d("currentBurnTime");
        this.energy.readFromNBT(energyTag);
        this.isBurning = tag.func_74767_n("Burning");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isActive()) {
                if (this.currentBurnTime == 0) {
                    this.isBurning = true;
                    this.itemHandler.extractItem(0, 1, false);
                }
                this.energy.receiveEnergy(ConfigMan.incinerator_output, false);
                ++this.currentBurnTime;
                if (this.currentBurnTime >= this.maxBurnTime) {
                    this.currentBurnTime = 0;
                    this.isBurning = false;
                }
                this.func_70296_d();
            }
            for (EnumFacing dir : EnumFacing.values()) {
                int used;
                int tosend;
                IEnergyReceiver receiver;
                BlockPos targetBlock = this.func_174877_v().func_177971_a(dir.func_176730_m());
                TileEntity tile = this.field_145850_b.func_175625_s(targetBlock);
                if (tile == null) continue;
                if (tile instanceof IEnergyReceiver) {
                    receiver = (IEnergyReceiver)tile;
                    if (!receiver.canConnectEnergy(dir.func_176734_d())) continue;
                    tosend = this.energy.extractEnergy(ConfigMan.incinerator_output, true);
                    used = receiver.receiveEnergy(dir.func_176734_d(), tosend, false);
                    if (used > 0) {
                        this.func_70296_d();
                    }
                    this.energy.extractEnergy(used, false);
                    continue;
                }
                if (!tile.hasCapability(CapabilityEnergy.ENERGY, dir.func_176734_d()) || !(receiver = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d())).canReceive()) continue;
                tosend = this.energy.extractEnergy(ConfigMan.incinerator_output, true);
                used = receiver.receiveEnergy(tosend, false);
                if (used > 0) {
                    this.func_70296_d();
                }
                this.energy.extractEnergy(used, false);
            }
        }
    }

    public void setProgress(int value) {
        this.currentBurnTime = value;
    }

    public int getProgress() {
        return this.currentBurnTime;
    }

    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r() && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void setEnergyStored(int value) {
        this.func_70296_d();
        this.energy.setEnergyStored(value);
    }

    private boolean hasFuel() {
        return !this.itemHandler.getStackInSlot(0).func_190926_b();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBufferScaled(int scale) {
        return this.getEnergyStored(null) * scale / this.getMaxEnergyStored(null);
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        int toget = this.energy.extractEnergy(maxExtract, simulate);
        if (toget > 0 && !simulate) {
            this.func_70296_d();
        }
        return toget;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    public boolean canExtract() {
        return this.canConnectEnergy(null);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.extractEnergy(null, maxExtract, simulate);
    }

    public boolean canReceive() {
        return false;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.getEnergyStored(null);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(null);
    }
}

