/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.client.gui.element;

import p455w0rdslib.api.gui.IGuiList;
import p455w0rdslib.api.gui.IGuiScrollbar;
import p455w0rdslib.api.gui.IModularGui;
import p455w0rdslib.client.gui.element.GuiPos;
import p455w0rdslib.client.gui.element.GuiScrollbar;

public class GuiVScrollbar
extends GuiScrollbar {
    public GuiVScrollbar(IModularGui gui, GuiPos posIn, int width, int height, int max) {
        this(gui, posIn, width, height, max, 0);
    }

    public GuiVScrollbar(IModularGui gui, GuiPos posIn, int width, int height, int max, int min) {
        super(gui, posIn, width, height, max, min);
    }

    @Override
    public int getSliderYPos() {
        int dist = this.getMaxPos() - this.getMinPos();
        int maxPos = this.getHeight() - this.getSliderHeight();
        return Math.min(dist == 0 ? 0 : maxPos * (this.getScrollPos() - this.getMinPos()) / dist, maxPos);
    }

    @Override
    public void doDrag(int x, int y) {
        int direction;
        y += Math.round((float)this.getSliderHeight() * ((float)y / (float)this.getHeight()) + (float)this.getSliderHeight() * 0.25f);
        int newPos = this.getMinPos() + (this.getMaxPos() - this.getMinPos()) * y / this.getHeight();
        int n = this.getScrollPos() == newPos ? 0 : (direction = this.getScrollPos() > newPos ? 1 : -1);
        if (this.getParentElement() != null && this.getParentElement() instanceof IGuiList) {
            boolean shouldMove;
            boolean bl = shouldMove = newPos != 0 && (this.getMaxPos() - this.getMinPos() + 1) % newPos == 0;
            if (direction > 0 && shouldMove) {
                ((IGuiList)this.getParentElement()).scrollUp();
            } else if (direction < 0 && shouldMove) {
                ((IGuiList)this.getParentElement()).scrollDown();
            }
        }
        this.setScrollPos(newPos);
    }

    @Override
    public IGuiScrollbar setBounds(int min, int max) {
        int dist = max - min;
        this.setSliderHeight(dist <= 0 ? this.getHeight() : Math.max(this.getHeight() / dist, 9));
        this.setSliderWidth(this.getWidth());
        return super.setBounds(min, max);
    }
}

