/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.world;

import epicsquid.mysticalworld.MysticalWorld;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.world.tree.WorldGenBurntTree;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGeneratorTrees
implements IWorldGenerator {
    public static List<BiomeDictionary.Type> invalidTypes = new ArrayList<BiomeDictionary.Type>();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_175624_G() == WorldType.field_77138_c) {
            return;
        }
        IntOpenHashSet blacklist = new IntOpenHashSet(ConfigManager.ConfigMysticalWorldBurntTrees.blacklist);
        IntOpenHashSet whitelist = new IntOpenHashSet(ConfigManager.ConfigMysticalWorldBurntTrees.whitelist);
        int dim = world.field_73011_w.getDimension();
        if (blacklist.contains(dim)) {
            return;
        }
        if (!whitelist.contains(dim)) {
            return;
        }
        int xPos = chunkX * 16 + 8;
        int zPos = chunkZ * 16 + 8;
        BlockPos chunkPos = new BlockPos(xPos, 0, zPos);
        Biome biome = world.func_175726_f(chunkPos).func_177411_a(chunkPos, world.func_72959_q());
        if (ConfigManager.burntTrees.chance == -1 || random.nextInt(ConfigManager.safeInt(ConfigManager.burntTrees.chance)) != 0) {
            return;
        }
        if (invalidTypes.isEmpty()) {
            for (String type2 : ConfigManager.burntTrees.excludedBiomes) {
                invalidTypes.add(BiomeDictionary.Type.getType((String)type2, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
            }
        }
        if (invalidTypes.stream().anyMatch(type -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type))) {
            return;
        }
        for (int i = 0; i < ConfigManager.burntTrees.attempts; ++i) {
            int z;
            int y;
            int x = chunkPos.func_177958_n() + (5 - random.nextInt(11));
            BlockPos pos = new BlockPos(x, y = world.func_189649_b(x, z = chunkPos.func_177952_p() + (5 - random.nextInt(11))), z);
            if (!Blocks.field_150345_g.func_176196_c(world, pos)) continue;
            WorldGenBurntTree burnTree = new WorldGenBurntTree(false);
            try {
                burnTree.func_180709_b(world, random, pos);
            }
            catch (NullPointerException e) {
                MysticalWorld.logger.debug("Failed to create a charred tree at '" + pos.toString() + "' due to a null-pointer:", (Throwable)e);
            }
            break;
        }
    }
}

