/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.materials;

import epicsquid.mysticallib.event.RegisterContentEvent;
import epicsquid.mysticallib.material.MaterialTypes;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.init.ModItems;
import epicsquid.mysticalworld.materials.Material;
import epicsquid.mysticalworld.materials.MaterialAmethyst;
import epicsquid.mysticalworld.materials.MaterialCopper;
import epicsquid.mysticalworld.materials.MaterialQuartz;
import epicsquid.mysticalworld.materials.MaterialSilver;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;

public class Materials {
    public static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static Material copper;
    public static Material silver;
    public static Material amethyst;
    public static Material quartz;
    public static ItemArmor.ArmorMaterial copperArmor;
    public static ItemArmor.ArmorMaterial silverArmor;
    public static ItemArmor.ArmorMaterial miscArmor;

    public static List<Material> getMaterials() {
        return Arrays.asList(copper, silver, amethyst, quartz);
    }

    public static void createMaterials() {
        Item.ToolMaterial copper = EnumHelper.addToolMaterial((String)"mysticalworld:copper", (int)2, (int)200, (float)4.0f, (float)2.0f, (int)7);
        Item.ToolMaterial silver = EnumHelper.addToolMaterial((String)"mysticalworld:silver", (int)2, (int)175, (float)6.0f, (float)2.5f, (int)18);
        Item.ToolMaterial amethyst = EnumHelper.addToolMaterial((String)"mysticalworld:amethyst", (int)3, (int)1561, (float)8.0f, (float)3.0f, (int)12);
        Item.ToolMaterial quartz = EnumHelper.addToolMaterial((String)"mysticalworld:quartz", (int)0, (int)99, (float)1.0f, (float)1.0f, (int)1);
        MaterialTypes.addMaterial((String)"mysticalworld:copper", (Item.ToolMaterial)copper, (ItemArmor.ArmorMaterial)copperArmor, (float)2.5f, (float)-1.5f);
        MaterialTypes.addMaterial((String)"mysticalworld:silver", (Item.ToolMaterial)silver, (ItemArmor.ArmorMaterial)silverArmor, (float)2.5f, (float)-1.0f);
        MaterialTypes.addMaterial((String)"mysticalworld:amethyst", (Item.ToolMaterial)amethyst, null, (float)3.0f, (float)-1.0f);
        MaterialTypes.addMaterial((String)"mysticalworld:quartz", (Item.ToolMaterial)quartz, null, (float)0.0f, (float)-1.5f);
        Materials.copper = new MaterialCopper("Copper", 3.5f, 0.65f, 1, -1, -1, MaterialTypes.material((String)"mysticalworld:copper"), true);
        Materials.silver = new MaterialSilver("Silver", 5.0f, 0.35f, 2, -1, -1, MaterialTypes.material((String)"mysticalworld:silver"), true);
        Materials.amethyst = new MaterialAmethyst("Amethyst", 3.0f, 0.7f, 2, 3, 7, MaterialTypes.material((String)"mysticalworld:amethyst"), true);
        Materials.quartz = new MaterialQuartz("Quartz", 3.0f, 3.0f, 1, 2, 5, MaterialTypes.material((String)"mysticalworld:quartz"), false);
    }

    public static void initMaterials(@Nonnull RegisterContentEvent event) {
        Materials.createMaterials();
        Materials.getMaterials().forEach(o -> o.initMaterial(event));
        copper.getMaterial().setRepairItem(new ItemStack(copper.getItem()));
        silver.getMaterial().setRepairItem(new ItemStack(silver.getItem()));
        amethyst.getMaterial().setRepairItem(new ItemStack(amethyst.getItem()));
    }

    public static void registerOreDictionary() {
        Materials.getMaterials().forEach(Material::initOreDictionary);
        if (ConfigManager.iron.enableDusts) {
            OreDictionary.registerOre((String)"dustIron", (Item)ModItems.iron_dust);
        }
        if (ConfigManager.iron.enableTinyDusts) {
            OreDictionary.registerOre((String)"tinyDustIron", (Item)ModItems.iron_dust_tiny);
        }
        if (ConfigManager.gold.enableDusts) {
            OreDictionary.registerOre((String)"dustGold", (Item)ModItems.gold_dust);
        }
        if (ConfigManager.gold.enableTinyDusts) {
            OreDictionary.registerOre((String)"tinyDustGold", (Item)ModItems.gold_dust_tiny);
        }
    }

    static {
        copperArmor = EnumHelper.addArmorMaterial((String)"mysticalworld:copper", (String)"mysticalworld:copper", (int)15, (int[])new int[]{2, 5, 6, 2}, (int)9, (SoundEvent)SoundEvents.field_187725_r, (float)0.0f);
        silverArmor = EnumHelper.addArmorMaterial((String)"mysticalworld:silver", (String)"mysticalworld:gold", (int)25, (int[])new int[]{2, 5, 6, 2}, (int)15, (SoundEvent)SoundEvents.field_187722_q, (float)0.0f);
        miscArmor = EnumHelper.addArmorMaterial((String)"mysticalworld:misc", (String)"mysticalworld:misc", (int)15, (int[])new int[]{2, 1, 1, 1}, (int)7, (SoundEvent)SoundEvents.field_191258_p, (float)0.2f);
    }
}

