/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model.block;

import epicsquid.mysticallib.model.CustomModelBase;
import epicsquid.mysticallib.model.DefaultTransformations;
import epicsquid.mysticallib.model.ModelUtil;
import epicsquid.mysticallib.model.parts.Cube;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelBlock
implements IBakedModel {
    public Function<ResourceLocation, TextureAtlasSprite> getter;
    public VertexFormat format;
    public TextureAtlasSprite particle;
    public TextureAtlasSprite texnorth;
    public TextureAtlasSprite texsouth;
    public TextureAtlasSprite texup;
    public TextureAtlasSprite texdown;
    public TextureAtlasSprite texeast;
    public TextureAtlasSprite texwest;
    private Cube cube;

    public BakedModelBlock(@Nullable IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull CustomModelBase model) {
        this(format, bakedTextureGetter, model);
    }

    protected BakedModelBlock(@Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull CustomModelBase model) {
        this.getter = bakedTextureGetter;
        this.format = format;
        this.particle = this.getter.apply(model.textures.get("particle"));
        this.texnorth = this.getter.apply(model.textures.get("north"));
        this.texsouth = this.getter.apply(model.textures.get("south"));
        this.texup = this.getter.apply(model.textures.get("up"));
        this.texdown = this.getter.apply(model.textures.get("down"));
        this.texeast = this.getter.apply(model.textures.get("east"));
        this.texwest = this.getter.apply(model.textures.get("west"));
        this.cube = ModelUtil.makeCube(format, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, ModelUtil.FULL_FACES, new TextureAtlasSprite[]{this.texwest, this.texeast, this.texdown, this.texup, this.texnorth, this.texsouth}, 0);
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> finalQuads = new ArrayList<BakedQuad>();
        if (state != null) {
            TextureAtlasSprite[] sprites = new TextureAtlasSprite[]{this.func_177554_e()};
            for (int i = 0; i < sprites.length; ++i) {
                this.addGeometry(finalQuads, side, state, new TextureAtlasSprite[]{sprites[i], sprites[i], sprites[i], sprites[i], sprites[i], sprites[i]}, 1);
            }
        } else {
            this.addItemModel(finalQuads, side);
        }
        return finalQuads;
    }

    public void addGeometry(@Nonnull List<BakedQuad> quads, @Nonnull EnumFacing side, IBlockState state, TextureAtlasSprite[] texes, int tintIndex) {
        ModelUtil.makeCube(this.format, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, ModelUtil.FULL_FACES, texes, tintIndex).addToList(quads, side);
    }

    public void addItemModel(@Nonnull List<BakedQuad> quads, @Nonnull EnumFacing side) {
        this.cube.addToList(quads, side);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(Arrays.asList(new ItemOverride[0]));
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType type) {
        if (DefaultTransformations.blockTransforms.containsKey(type)) {
            Matrix4f matrix = DefaultTransformations.blockTransforms.get(type).getMatrix();
            return Pair.of((Object)this, (Object)matrix);
        }
        return ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)type);
    }
}

