/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.lightoverlay;

import at.feldim2425.moreoverlays.api.lightoverlay.ILightRenderer;
import at.feldim2425.moreoverlays.api.lightoverlay.ILightScanner;
import at.feldim2425.moreoverlays.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class LightOverlayRenderer
implements ILightRenderer {
    private static final ResourceLocation BLANK_TEX = new ResourceLocation("moreoverlays", "textures/blank.png");
    private static RenderManager render = Minecraft.func_71410_x().func_175598_ae();

    @Override
    public void renderOverlays(ILightScanner scanner) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(BLANK_TEX);
        GlStateManager.func_179094_E();
        GL11.glLineWidth((float)Config.render_spawnLineWidth);
        GlStateManager.func_179137_b((double)(-LightOverlayRenderer.render.field_78730_l), (double)(-LightOverlayRenderer.render.field_78731_m), (double)(-LightOverlayRenderer.render.field_78728_n));
        float ar = (float)(Config.render_spawnAColor >> 16 & 0xFF) / 255.0f;
        float ag = (float)(Config.render_spawnAColor >> 8 & 0xFF) / 255.0f;
        float ab = (float)(Config.render_spawnAColor & 0xFF) / 255.0f;
        float nr = (float)(Config.render_spawnNColor >> 16 & 0xFF) / 255.0f;
        float ng = (float)(Config.render_spawnNColor >> 8 & 0xFF) / 255.0f;
        float nb = (float)(Config.render_spawnNColor & 0xFF) / 255.0f;
        for (Pair<BlockPos, Byte> entry : scanner.getLightModes()) {
            Byte mode = (Byte)entry.getValue();
            if (mode == null || mode == 0) continue;
            if (mode == 1) {
                LightOverlayRenderer.renderCross((BlockPos)entry.getKey(), nr, ng, nb);
                continue;
            }
            if (mode != 2) continue;
            LightOverlayRenderer.renderCross((BlockPos)entry.getKey(), ar, ag, ab);
        }
        GlStateManager.func_179121_F();
    }

    private static void renderCross(BlockPos pos, float r, float g, float b) {
        double y = (double)pos.func_177956_o() + 0.005;
        double x0 = pos.func_177958_n();
        double x1 = x0 + 1.0;
        double z0 = pos.func_177952_p();
        double z1 = z0 + 1.0;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder renderer = tess.func_178180_c();
        renderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b(x0, y, z0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x1, y, z1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x1, y, z0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x0, y, z1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tess.func_78381_a();
    }
}

