/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.modularmagic.common.tile;

import com.google.common.collect.Lists;
import fr.frinn.modularmagic.common.tile.machinecomponent.MachineComponentStarlightProviderOutput;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleIndependentSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionSourceNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.SourceClassRegistry;
import hellfirepvp.astralsorcery.common.tile.base.TileSourceBase;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class TileStarlightOutput
extends TileSourceBase
implements MachineComponentTile {
    private float starlightProduced = 0.0f;
    public TileMachineController controller;
    public IWeakConstellation constellation = (IWeakConstellation)ConstellationRegistry.getWeakConstellations().get(0);

    public float getStarlightProduced() {
        return this.starlightProduced;
    }

    public void setStarlightProduced(float starlightProduced) {
        this.starlightProduced = starlightProduced >= 0.0f ? starlightProduced : 0.0f;
    }

    @Nullable
    public MachineComponent provideComponent() {
        return new MachineComponentStarlightProviderOutput(this, MachineComponent.IOType.OUTPUT);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.starlightProduced > 0.0f && this.field_145850_b.func_82737_E() % 20L == 0L && (this.controller == null || this.controller.getFoundMachine() == null)) {
            this.starlightProduced = 0.0f;
        }
        super.func_73660_a();
    }

    @Nullable
    public String getUnLocalizedDisplayName() {
        return "tile.blockstarlightprovideroutput.name";
    }

    @Nonnull
    public IIndependentStarlightSource provideNewSourceNode() {
        return new IndependantStarlightProviderSource(this.constellation, this);
    }

    @Nonnull
    public ITransmissionSource provideSourceNode(BlockPos at) {
        return new SimpleTransmissionSourceNode(at);
    }

    public boolean onSelect(EntityPlayer player) {
        if (player.func_70093_af()) {
            for (BlockPos linkTo : Lists.newArrayList((Iterable)this.getLinkedPositions())) {
                this.tryUnlink(player, linkTo);
            }
            player.func_145747_a(new TextComponentTranslation("misc.link.unlink.all", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            return false;
        }
        return true;
    }

    public static class Provider
    implements SourceClassRegistry.SourceProvider {
        public IIndependentStarlightSource provideEmptySource() {
            return new IndependantStarlightProviderSource(null, null);
        }

        public String getIdentifier() {
            return "modularmagic:IndependantStarlightProviderSource";
        }
    }

    public static class IndependantStarlightProviderSource
    extends SimpleIndependentSource {
        private TileStarlightOutput provider;

        public IndependantStarlightProviderSource(IWeakConstellation constellation, TileStarlightOutput provider) {
            super(constellation);
            this.provider = provider;
        }

        public float produceStarlightTick(World world, BlockPos pos) {
            if (this.provider != null) {
                return this.provider.getStarlightProduced();
            }
            if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileStarlightOutput) {
                this.provider = (TileStarlightOutput)world.func_175625_s(pos);
                return this.provider.getStarlightProduced();
            }
            return 0.0f;
        }

        public void informTileStateChange(IStarlightSource sourceTile) {
        }

        public void threadedUpdateProximity(BlockPos thisPos, Map<BlockPos, IIndependentStarlightSource> otherSources) {
        }

        public SourceClassRegistry.SourceProvider getProvider() {
            return new Provider();
        }
    }
}

