/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.modularmagic.common.crafting.requirement;

import com.google.common.collect.Lists;
import fr.frinn.modularmagic.common.integration.jei.component.JEIComponentAspect;
import fr.frinn.modularmagic.common.tile.TileAspectProvider;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import javax.annotation.Nonnull;
import thaumcraft.api.aspects.Aspect;

public class RequirementAspect
extends ComponentRequirement {
    public int amount;
    public Aspect aspect;

    public RequirementAspect(MachineComponent.IOType actionType, int amount, Aspect aspect) {
        super(ComponentType.Registry.getComponent((String)"aspect"), actionType);
        this.amount = amount;
        this.aspect = aspect;
    }

    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        if (!this.canStartCrafting(component, context, Lists.newArrayList()).isSuccess()) {
            return false;
        }
        if (this.getActionType() == MachineComponent.IOType.INPUT) {
            TileAspectProvider provider = (TileAspectProvider)((Object)component.getContainerProvider());
            return provider.takeFromContainer(this.aspect, this.amount);
        }
        return true;
    }

    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        if (this.getActionType() == MachineComponent.IOType.OUTPUT) {
            TileAspectProvider provider = (TileAspectProvider)((Object)component.getContainerProvider());
            provider.addToContainer(this.aspect, this.amount);
        }
        return true;
    }

    @Nonnull
    public CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List restrictions) {
        TileAspectProvider provider = (TileAspectProvider)((Object)component.getContainerProvider());
        switch (this.getActionType()) {
            case INPUT: {
                if (provider.doesContainerContainAmount(this.aspect, this.amount)) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure((String)"error.modularmagic.requirement.aspect.less");
            }
            case OUTPUT: {
                if (provider.doesContainerAccept(this.aspect)) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure((String)"error.modularmagic.requirement.aspect.out");
            }
        }
        return CraftCheck.skipComponent();
    }

    public ComponentRequirement deepCopy() {
        return this;
    }

    public ComponentRequirement deepCopyModified(List list) {
        return this;
    }

    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
    }

    public void endRequirementCheck() {
    }

    public ComponentRequirement.JEIComponent provideJEIComponent() {
        return new JEIComponentAspect(this);
    }
}

