/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles.base;

import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.prop.FluidHatchSize;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import hellfirepvp.modularmachinery.common.util.HybridGasTank;
import hellfirepvp.modularmachinery.common.util.HybridTank;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(modid="mekanism", iface="mekanism.api.gas.IGasHandler"), @Optional.Interface(modid="mekanism", iface="mekanism.api.gas.ITubeConnection")})
public abstract class TileFluidTank
extends TileColorableMachineComponent
implements MachineComponentTile,
IGasHandler,
ITubeConnection {
    private HybridTank tank;
    private MachineComponent.IOType ioType;
    private FluidHatchSize hatchSize;

    public TileFluidTank() {
    }

    public TileFluidTank(FluidHatchSize size, MachineComponent.IOType type) {
        this.tank = size.buildTank(this, type == MachineComponent.IOType.INPUT, type == MachineComponent.IOType.OUTPUT);
        this.hatchSize = size;
        this.ioType = type;
    }

    public HybridTank getTank() {
        return this.tank;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (Mods.MEKANISM.isPresent() && this.checkMekanismGasCapabilitiesPresence(capability, facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.tank);
        }
        if (Mods.MEKANISM.isPresent() && this.checkMekanismGasCapabilities(capability, facing)) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Optional.Method(modid="mekanism")
    private boolean checkMekanismGasCapabilitiesPresence(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.checkMekanismGasCapabilities(capability, facing);
    }

    @Optional.Method(modid="mekanism")
    private boolean checkMekanismGasCapabilities(Capability<?> capability, @Nullable EnumFacing facing) {
        String gasType = IGasHandler.class.getName().intern();
        String tubeConnectionName = ITubeConnection.class.getName().intern();
        return capability != null && (capability.getName().equals(gasType) || capability.getName().equals(tubeConnectionName));
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.ioType = compound.func_74767_n("input") ? MachineComponent.IOType.INPUT : MachineComponent.IOType.OUTPUT;
        this.hatchSize = FluidHatchSize.values()[MathHelper.func_76125_a((int)compound.func_74762_e("size"), (int)0, (int)(FluidHatchSize.values().length - 1))];
        HybridTank newTank = this.hatchSize.buildTank(this, this.ioType == MachineComponent.IOType.INPUT, this.ioType == MachineComponent.IOType.OUTPUT);
        NBTTagCompound tankTag = compound.func_74775_l("tank");
        newTank.readFromNBT(tankTag);
        this.tank = newTank;
        if (Mods.MEKANISM.isPresent()) {
            this.readMekGasData(tankTag);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("input", this.ioType == MachineComponent.IOType.INPUT);
        compound.func_74768_a("size", this.hatchSize.ordinal());
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        if (Mods.MEKANISM.isPresent()) {
            this.writeMekGasData(tankTag);
        }
        compound.func_74782_a("tank", (NBTBase)tankTag);
    }

    @Override
    @Nullable
    public MachineComponent provideComponent() {
        return new MachineComponent.FluidHatch(this.ioType){

            @Override
            public HybridTank getContainerProvider() {
                return TileFluidTank.this.tank;
            }
        };
    }

    @Optional.Method(modid="mekanism")
    public boolean canTubeConnect(EnumFacing side) {
        return true;
    }

    @Optional.Method(modid="mekanism")
    private void writeMekGasData(NBTTagCompound compound) {
        if (this.tank instanceof HybridGasTank) {
            ((HybridGasTank)this.tank).writeGasToNBT(compound);
        }
    }

    @Optional.Method(modid="mekanism")
    private void readMekGasData(NBTTagCompound compound) {
        if (this.tank instanceof HybridGasTank) {
            ((HybridGasTank)this.tank).readGasFromNBT(compound);
        }
    }

    @Optional.Method(modid="mekanism")
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.tank instanceof HybridGasTank) {
            return ((HybridGasTank)this.tank).receiveGas(side, stack, doTransfer);
        }
        return 0;
    }

    @Optional.Method(modid="mekanism")
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.tank instanceof HybridGasTank) {
            return ((HybridGasTank)this.tank).drawGas(side, amount, doTransfer);
        }
        return null;
    }

    @Optional.Method(modid="mekanism")
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.tank instanceof HybridGasTank && ((HybridGasTank)this.tank).canReceiveGas(side, type);
    }

    @Optional.Method(modid="mekanism")
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.tank instanceof HybridGasTank && ((HybridGasTank)this.tank).canDrawGas(side, type);
    }
}

