/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.command;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class RecipeRunnableCommand {
    private String command;
    private int interval;

    public RecipeRunnableCommand(String command) {
        this(command, -1);
    }

    public RecipeRunnableCommand(String command, int interval) {
        this.command = command;
        this.interval = MathHelper.func_76125_a((int)interval, (int)-1, (int)Integer.MAX_VALUE);
    }

    public void run(ICommandSender sender, int tick) {
        MinecraftServer server;
        World world = sender.func_130014_f_();
        if (!(world.field_72995_K || this.hasInterval() && tick % this.getInterval() != 0 || (server = sender.func_184102_h()) == null)) {
            server.func_71187_D().func_71556_a(sender, this.command);
        }
    }

    public String getCommand() {
        return this.command;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean hasInterval() {
        return this.interval != -1;
    }

    public static class Deserializer
    implements JsonDeserializer<RecipeRunnableCommand> {
        public RecipeRunnableCommand deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return new RecipeRunnableCommand(json.getAsString());
            }
            if (json.isJsonObject()) {
                JsonObject objCommand = json.getAsJsonObject();
                if (!objCommand.has("command")) {
                    throw new JsonParseException("Tried to deserialize recipe command, found no 'command' string in command object!");
                }
                JsonElement elementCommandString = objCommand.get("command");
                if (!elementCommandString.isJsonPrimitive()) {
                    throw new JsonParseException("Command specified in 'command' of recipe command object is not a string!");
                }
                int interval = -1;
                String command = elementCommandString.getAsString();
                if (objCommand.has("interval")) {
                    JsonElement elementInterval = objCommand.get("interval");
                    if (!elementInterval.isJsonPrimitive() || !elementInterval.getAsJsonPrimitive().isNumber()) {
                        throw new JsonParseException("Interval specified in 'interval' of recipe command object is not an int!");
                    }
                    interval = elementInterval.getAsInt();
                }
                return new RecipeRunnableCommand(command, interval);
            }
            throw new JsonParseException("Tried to deserialize recipe command, found neither command nor object describing command and optional interval!");
        }
    }
}

