/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.adapter;

import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.AdapterMinecraftFurnace;
import hellfirepvp.modularmachinery.common.crafting.adapter.DynamicMachineRecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public class RecipeAdapterRegistry {
    private static IForgeRegistry<RecipeAdapter> ADAPTER_REGISTRY = null;

    @Nullable
    public static Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachine, ResourceLocation adapterKey, List<RecipeModifier> modifiers, List<ComponentRequirement<?>> additionalRequirements) {
        RecipeAdapter adapter = (RecipeAdapter)ADAPTER_REGISTRY.getValue(adapterKey);
        if (adapter == null) {
            return null;
        }
        return adapter.createRecipesFor(owningMachine, modifiers, additionalRequirements);
    }

    public static void registerAdapter(RecipeAdapter adapter) {
        ADAPTER_REGISTRY.register((IForgeRegistryEntry)adapter);
    }

    public static void initDefaultAdapters() {
        ADAPTER_REGISTRY = new RegistryBuilder().setName(new ResourceLocation("modularmachinery", "recipeadapters")).setType(RecipeAdapter.class).disableSaving().setMaxID(Short.MAX_VALUE).create();
        RecipeAdapterRegistry.registerAdapter(new AdapterMinecraftFurnace());
    }

    public static void registerMachineAdapters() {
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            RecipeAdapterRegistry.registerAdapter(new DynamicMachineRecipeAdapter(machine.getRegistryName(), machine));
        }
    }
}

