/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thaumcraft.handlers;

import com.blamejared.compat.thaumcraft.handlers.aspects.CTAspect;
import com.blamejared.compat.thaumcraft.handlers.aspects.CTAspectStack;
import com.blamejared.compat.thaumcraft.handlers.brackets.BracketHandlerAspect;
import com.blamejared.mtlib.helpers.LogHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.zenscript.GlobalRegistry;
import crafttweaker.zenscript.IBracketHandler;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.internal.CommonInternals;
import thaumcraft.api.internal.WeightedRandomLoot;

public class ThaumCraft {
    public static void preInit() {
        GlobalRegistry.registerBracketHandler((IBracketHandler)new BracketHandlerAspect());
    }

    public static void registerCommands() {
        CTChatCommand.registerCommand((CraftTweakerCommand)new CraftTweakerCommand("thaumcraftDump"){

            protected void init() {
                this.setDescription(new ITextComponent[]{SpecialMessagesChat.getClickableCommandText((String)"\u00a72/ct thaumcraftDump", (String)"/ct thaumcraftDump", (boolean)true), SpecialMessagesChat.getNormalMessage((String)" \u00a73Dumps all the Thaumcraft information to the crafttweaker log")});
            }

            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand((String)"Thaumcraft dump:");
                CraftTweakerAPI.logCommand((String)"-Smelting Bonus:");
                CommonInternals.smeltingBonus.forEach(b -> CraftTweakerAPI.logCommand((String)String.format("--in: %s, out: %s, change: %s", LogHelper.getStackDescription((Object)b.in), LogHelper.getStackDescription((Object)b.out), Float.valueOf(b.chance))));
                CraftTweakerAPI.logCommand((String)"-Warp");
                CommonInternals.warpMap.forEach((key, val) -> CraftTweakerAPI.logCommand((String)String.format("--Item: %s has warp: %s", key, val)));
                CraftTweakerAPI.logCommand((String)"-Aspects");
                Aspect.aspects.forEach((key, val) -> CraftTweakerAPI.logCommand((String)("--Aspect " + val.getName())));
                CraftTweakerAPI.logCommand((String)"-Recipes(Grouped)");
                CommonInternals.craftingRecipeCatalog.forEach((key, val) -> {
                    if (val instanceof CrucibleRecipe) {
                        ItemStack recipeOutput = ((CrucibleRecipe)val).getRecipeOutput();
                        CraftTweakerAPI.logCommand((String)String.format("--Crucible: name: %s, group: %s, research: %s, output %s", key, val.getGroup(), val.getResearch(), LogHelper.getStackDescription((Object)recipeOutput)));
                    } else if (val instanceof InfusionRecipe) {
                        Object recipeOutput = ((InfusionRecipe)val).getRecipeOutput();
                        CraftTweakerAPI.logCommand((String)String.format("--Infusion: name: %s, group: %s, research: %s, output %s", key, val.getGroup(), val.getResearch(), LogHelper.getStackDescription((Object)recipeOutput)));
                    } else {
                        CraftTweakerAPI.logCommand((String)String.format("--Unknown: name: %s, group: %s, research: %s", key, val.getGroup(), val.getResearch()));
                    }
                });
                CraftTweakerAPI.logCommand((String)"-ArcaneWorkbench");
                for (IRecipe recipe : ForgeRegistries.RECIPES) {
                    if (!(recipe instanceof IArcaneRecipe)) continue;
                    CraftTweakerAPI.logCommand((String)String.format("--Output: %s, name %s", LogHelper.getStackDescription((Object)recipe.func_77571_b()), recipe.getRegistryName()));
                }
                CraftTweakerAPI.logCommand((String)"-Lootbags");
                CraftTweakerAPI.logCommand((String)"--Common");
                WeightedRandomLoot.lootBagCommon.forEach(re -> CraftTweakerAPI.logCommand((String)(LogHelper.getStackDescription((Object)re.item) + "")));
                CraftTweakerAPI.logCommand((String)"--Uncommon");
                WeightedRandomLoot.lootBagUncommon.forEach(re -> CraftTweakerAPI.logCommand((String)(LogHelper.getStackDescription((Object)re.item) + "")));
                CraftTweakerAPI.logCommand((String)"--Rare");
                WeightedRandomLoot.lootBagRare.forEach(re -> CraftTweakerAPI.logCommand((String)(LogHelper.getStackDescription((Object)re.item) + "")));
                sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog((String)"Thaumcraft dump generated", (ICommandSender)sender));
            }
        });
    }

    public static Aspect getAspect(CTAspect aspect) {
        return aspect.getInternal();
    }

    public static Aspect getAspect(CTAspectStack aspect) {
        return aspect.getInternal().getInternal();
    }

    public static AspectList getAspects(CTAspectStack[] aspects) {
        AspectList list = new AspectList();
        for (CTAspectStack aspect : aspects) {
            list.add(ThaumCraft.getAspect(aspect), aspect.getAmount());
        }
        return list;
    }
}

