/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.moartinkers.registry;

import com.bartz24.moartinkers.MoarMaterialIntegration;
import com.bartz24.moartinkers.config.ConfigOptions;
import com.bartz24.moartinkers.registry.ModFluids;
import com.bartz24.moartinkers.registry.ModMaterials;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.StringUtils;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;

class MaterialRegistration {
    private static boolean force = ModMaterials.force;
    protected String identifier;
    protected String ore = null;
    protected String oreSuffix = null;
    protected String mod = null;
    protected Integer color = 0;
    protected Integer temp = 0;
    protected Tuple<ITrait, String>[] traits = new Tuple[0];
    protected HeadMaterialStats head;
    protected HandleMaterialStats handle;
    protected ExtraMaterialStats extra;
    protected BowMaterialStats bow;
    protected BowStringMaterialStats bowstring;
    protected ResourceLocation castItem;
    protected int castItemMeta = 0;
    protected String castItemOre;

    MaterialRegistration() {
    }

    private boolean isRegistrable() {
        return ConfigOptions.materialIsAllowed(this.identifier) && TinkerRegistry.getMaterial((String)this.identifier).equals(Material.UNKNOWN);
    }

    protected ItemStack getCastItem() {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)this.castItem);
        if (item != null) {
            return new ItemStack(item, 1, this.castItemMeta);
        }
        return ItemStack.field_190927_a;
    }

    void register(boolean latePhase) {
        if (latePhase && this.getCastItem() != null) {
            Material material = TinkerRegistry.getMaterial((String)this.identifier);
            material.addItem(this.getCastItem(), 1, 144);
            material.setRepresentativeItem(this.getCastItem());
        } else if (!latePhase && this.isRegistrable() && (this.mod == null || Loader.isModLoaded((String)this.mod))) {
            Material material = this.ingotMaterial(StringUtils.capitalize((String)this.identifier), this.ore, this.color, this.temp, latePhase);
            for (Tuple<ITrait, String> trait : this.traits) {
                if (trait.func_76340_b() == null) {
                    material.addTrait((ITrait)trait.func_76341_a());
                    continue;
                }
                material.addTrait((ITrait)trait.func_76341_a(), (String)trait.func_76340_b());
            }
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.head, (IMaterialStats[])new IMaterialStats[]{this.handle, this.extra, this.bow});
            if (this.bowstring != null) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.bowstring);
            }
        }
    }

    private Material ingotMaterial(String name, String oreName, int color, int temp, boolean latePhase) {
        Material material = new Material(name, color);
        if (this.castItem != null || this.castItemOre != null) {
            MoarMaterialIntegration m = new MoarMaterialIntegration(oreName, material, null, null);
            if (this.castItem == null) {
                material.addItem(this.castItemOre, 1, 144);
                m.setRepresentativeItem(this.castItemOre);
            }
            m.preInit(force);
            TinkerRegistry.integrate((MaterialIntegration)m);
            material.setCraftable(true);
            force = false;
        } else {
            MoarMaterialIntegration m;
            ModFluids.registerFluid(name.toLowerCase(), color, temp);
            if (oreName == null) {
                String nameModified = this.oreSuffix == null ? name : this.oreSuffix;
                m = new MoarMaterialIntegration(material, FluidRegistry.getFluid((String)name.toLowerCase()), nameModified);
                m.setRepresentativeItem("ingot" + nameModified).toolforge();
                material.addItemIngot("ingot" + nameModified);
            } else {
                m = new MoarMaterialIntegration(oreName, material, FluidRegistry.getFluid((String)name), null);
                m.setRepresentativeItem(oreName).toolforge();
                material.addItemIngot(oreName);
            }
            m.preInit(force);
            TinkerRegistry.integrate((MaterialIntegration)m);
            material.setCastable(true);
            force = false;
        }
        return material;
    }

    static class MaterialRegistrationBuilder
    extends MaterialRegistration {
        MaterialRegistrationBuilder() {
        }

        public MaterialRegistrationBuilder setOre(String ore) {
            this.ore = ore;
            return this;
        }

        public MaterialRegistrationBuilder setOreSuffix(String suffix) {
            this.oreSuffix = suffix;
            return this;
        }

        public MaterialRegistrationBuilder setMod(String mod) {
            this.mod = mod;
            return this;
        }

        MaterialRegistrationBuilder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        MaterialRegistrationBuilder setColor(Integer color) {
            this.color = color;
            return this;
        }

        MaterialRegistrationBuilder setTemp(Integer temp) {
            this.temp = temp;
            return this;
        }

        public MaterialRegistrationBuilder setTraits(Tuple<ITrait, String>[] traits) {
            this.traits = traits;
            return this;
        }

        MaterialRegistrationBuilder setHead(int durability, float miningSpeed, float attack, int harvestLevel) {
            this.head = new HeadMaterialStats(durability, miningSpeed, attack, harvestLevel);
            return this;
        }

        MaterialRegistrationBuilder setHandle(float modifier, int durability) {
            this.handle = new HandleMaterialStats(modifier, durability);
            return this;
        }

        MaterialRegistrationBuilder setExtra(int durability) {
            this.extra = new ExtraMaterialStats(durability);
            return this;
        }

        MaterialRegistrationBuilder setBow(float drawSpeed, float range, float bonusDamage) {
            this.bow = new BowMaterialStats(drawSpeed, range, bonusDamage);
            return this;
        }

        MaterialRegistrationBuilder setBowString(float modifier) {
            this.bowstring = new BowStringMaterialStats(modifier);
            return this;
        }

        MaterialRegistrationBuilder setItemCast(ItemStack stack) {
            this.castItem = stack.func_77973_b().getRegistryName();
            this.castItemMeta = stack.func_77960_j();
            return this;
        }

        MaterialRegistrationBuilder setItemCast(ResourceLocation itemID, int meta) {
            this.castItem = itemID;
            this.castItemMeta = meta;
            return this;
        }

        MaterialRegistrationBuilder setItemCast(String oreDict) {
            this.castItemOre = oreDict;
            return this;
        }

        MaterialRegistration build() {
            return this;
        }
    }
}

