/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.util;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientItem;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class InputsUtils {
    private InputsUtils() {
    }

    public static ItemStack[] getStackList(IIngredient ingredient) {
        if (ingredient == null) {
            return new ItemStack[0];
        }
        if (ingredient instanceof IItemStack) {
            return new ItemStack[]{InputHelper.toStack((IItemStack)((IItemStack)ingredient))};
        }
        if (ingredient instanceof IOreDictEntry) {
            return (ItemStack[])OreDictionary.getOres((String)((IOreDictEntry)ingredient).getName()).toArray((Object[])new ItemStack[0]);
        }
        if (ingredient instanceof IngredientStack || ingredient instanceof IngredientItem || ingredient instanceof IngredientOr) {
            ItemStack[] stacks = InputHelper.toStacks((IItemStack[])ingredient.getItemArray());
            if (stacks == null) {
                return new ItemStack[0];
            }
            return stacks;
        }
        return new ItemStack[0];
    }

    public static Object getObject(IIngredient ingredient) {
        if (ingredient == null) {
            return ItemStack.field_190927_a;
        }
        if (ingredient instanceof IItemStack) {
            return InputHelper.toStack((IItemStack)((IItemStack)ingredient));
        }
        if (ingredient instanceof IngredientStack && ingredient.getInternal() instanceof IItemStack) {
            ItemStack stack = InputHelper.toStack((IItemStack)((IItemStack)ingredient.getInternal()));
            stack.func_190920_e(ingredient.getAmount());
            return stack;
        }
        if (ingredient instanceof IOreDictEntry) {
            return ((IOreDictEntry)ingredient).getName();
        }
        if (ingredient instanceof IngredientStack || ingredient instanceof IngredientItem || ingredient instanceof IngredientOr) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (IItemStack stack : ingredient.getItems()) {
                list.add(InputHelper.toStack((IItemStack)stack));
            }
            return list;
        }
        return ItemStack.field_190927_a;
    }

    public static Object[] getObjects(IIngredient[] ingredients) {
        Object[] objects = new Object[ingredients.length];
        for (int i = 0; i < ingredients.length; ++i) {
            objects[i] = InputsUtils.getObject(ingredients[i]);
        }
        return objects;
    }

    public static Object[] getShapedObjects(IIngredient[][] ingredients) {
        char[][] chars = new char[][]{{'a', 'b', 'c'}, {'d', 'e', 'f'}, {'g', 'h', 'i'}};
        HashMap<Character, Object> inputs = new HashMap<Character, Object>();
        if (ingredients.length < 1 || ingredients.length > 3) {
            CraftTweakerAPI.logError((String)("Could not generate shaped objects as of invalid input length: " + ingredients.length));
            return new Object[0];
        }
        int length = -1;
        for (int i = 0; i < ingredients.length; ++i) {
            if (length < 0) {
                if (ingredients[i].length < 1 || ingredients[i].length > 3) {
                    CraftTweakerAPI.logError((String)("Could not generate shaped objects as of invalid input length: " + ingredients[i].length));
                    return new Object[0];
                }
                length = ingredients[i].length;
            } else if (ingredients[i].length != length) {
                CraftTweakerAPI.logError((String)("Could not generate shaped objects as of different input lengths: " + length + ", " + ingredients[i].length));
                return new Object[0];
            }
            for (int j = 0; j < ingredients[i].length; ++j) {
                inputs.put(Character.valueOf(chars[i][j]), InputsUtils.getObject(ingredients[i][j]));
            }
        }
        String[] strs = new String[ingredients.length];
        block6: for (int i = 0; i < ingredients.length; ++i) {
            switch (length) {
                case 3: {
                    strs[i] = "" + chars[i][0] + chars[i][1] + chars[i][2];
                    continue block6;
                }
                case 2: {
                    strs[i] = "" + chars[i][0] + chars[i][1];
                    continue block6;
                }
                default: {
                    strs[i] = "" + chars[i][0];
                }
            }
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(strs));
        for (Character chr : inputs.keySet()) {
            list.add((String)((Object)chr));
            list.add((String)inputs.get(chr));
        }
        return list.toArray(new Object[0]);
    }

    public static boolean matchesForRemoval(Object obj, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (obj instanceof ItemStack) {
            if (((ItemStack)obj).func_190926_b() && stack.func_190926_b()) {
                return true;
            }
            return ((ItemStack)obj).func_77973_b() == stack.func_77973_b() && ((ItemStack)obj).func_77960_j() == stack.func_77960_j() && ItemStack.func_77970_a((ItemStack)((ItemStack)obj), (ItemStack)stack);
        }
        if (obj instanceof Item) {
            return obj == stack.func_77973_b();
        }
        if (obj instanceof Block) {
            return Item.func_150898_a((Block)((Block)obj)) == stack.func_77973_b();
        }
        if (obj instanceof String) {
            for (ItemStack entry : OreDictionary.getOres((String)((String)obj))) {
                if (!InputsUtils.matchesForRemoval((Object)entry, stack)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof List) {
            for (Object entry : (List)obj) {
                if (!InputsUtils.matchesForRemoval(entry, stack)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean matchesForRemoval(Object obj, Iterable<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (!InputsUtils.matchesForRemoval(obj, stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesForRemoval(Object obj, ItemStack[] stacks) {
        for (ItemStack stack : stacks) {
            if (!InputsUtils.matchesForRemoval(obj, stack)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean matchesForRemoval(Object obj, Iterable<T> stacks, Function<T, ItemStack> action) {
        for (T stack : stacks) {
            if (!InputsUtils.matchesForRemoval(obj, action.apply(stack))) continue;
            return true;
        }
        return false;
    }

    public static Ingredient getIngredient(Object ingredient) {
        if (ingredient == null) {
            return Ingredient.field_193370_a;
        }
        if (ingredient instanceof ItemStack) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)ingredient});
        }
        if (ingredient instanceof String) {
            return new OreIngredient((String)ingredient);
        }
        if (ingredient instanceof Item) {
            return Ingredient.func_193367_a((Item)((Item)ingredient));
        }
        if (ingredient instanceof Block) {
            return Ingredient.func_193367_a((Item)Item.func_150898_a((Block)((Block)ingredient)));
        }
        if (ingredient instanceof List) {
            ArrayList<Ingredient> converted = new ArrayList<Ingredient>();
            for (Object o : (List)ingredient) {
                converted.add(InputsUtils.getIngredient(o));
            }
            return Ingredient.merge(converted);
        }
        return Ingredient.field_193370_a;
    }

    public static Ingredient[] getIngredients(Object[] ingredients) {
        Ingredient[] objects = new Ingredient[ingredients.length];
        for (int i = 0; i < ingredients.length; ++i) {
            objects[i] = InputsUtils.getIngredient(ingredients[i]);
        }
        return objects;
    }
}

