/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.tiles;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.tiles.TileEntityEnergy;
import sblectric.lightningcraft.util.EnergyStorage;

public class TileEntityEnergyProvider
extends TileEntityEnergy {
    public static final int maxStorage = 100000;
    public static final int rfPerTick = 1024;

    public TileEntityEnergyProvider() {
        this.storage = new EnergyStorage(100000, 0, 1024);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.hasLPCell() && !this.field_145850_b.func_175640_z(this.field_174879_c) && this.storage.getEnergyStored() <= this.storage.getMaxEnergyStored() - LCConfig.RFtoLEConversion && this.canDrawCellPower(1.0)) {
            this.drawCellPower(1.0);
            this.storage.modifyEnergyStored(LCConfig.RFtoLEConversion);
            this.func_70296_d();
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability != null) {
            if (capability == producerCap || capability == storageCap) {
                return true;
            }
            if (capability == consumerCap) {
                return false;
            }
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergyStored(int energy) {
        this.storage.setEnergyStored(energy);
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int extractEnergy(EnumFacing from, int toExtract, boolean simulate) {
        if (!simulate) {
            this.func_70296_d();
        }
        return this.storage.extractEnergy(toExtract, simulate);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.storage.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.storage.writeToNBT(tagCompound);
        return tagCompound;
    }
}

