/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.gui.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import sblectric.lightningcraft.api.recipes.LightningInfusionRecipe;
import sblectric.lightningcraft.api.util.JointList;
import sblectric.lightningcraft.api.util.StackHelper;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.integration.energy.EnergyApiHelper;
import sblectric.lightningcraft.recipes.LightningInfusionRecipes;
import sblectric.lightningcraft.util.LCMisc;

@SideOnly(value=Side.CLIENT)
public class GuiLightningGuide
extends GuiScreen {
    private final int bookImageHeight = 192;
    private final int bookImageWidth = 192;
    private int currPage = 0;
    private int indexPage;
    private int recipePage;
    private int bookTotalPages;
    private static ResourceLocation bookCoverTexture = new ResourceLocation("lightningcraft", "textures/gui/lightning_book_cover.png");
    private static ResourceLocation bookMainTexture = new ResourceLocation("lightningcraft", "textures/gui/lightning_book.png");
    private static ResourceLocation bookRecipeTexture = new ResourceLocation("lightningcraft", "textures/gui/lightning_book_recipes.png");
    private JointList<String> pages = new JointList();
    private JointList<RecipePage> recipePages = new JointList();
    private GuiButton buttonDone;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonLastPage;
    private NextPageButton buttonPreviousPage;
    private NextPageButton buttonFirstPage;
    private GuiButton level1Ref;
    private int pageLevel1 = -1;
    private GuiButton level2Ref;
    private int pageLevel2 = -1;
    private GuiButton level3Ref;
    private int pageLevel3 = -1;
    private GuiButton indexRef;
    private int level;
    private int mouseX;
    private int mouseY;

    public GuiLightningGuide() {
        this(0);
    }

    public GuiLightningGuide(int level) {
        String edition = "";
        String S = "\u00a7";
        switch (level) {
            case 0: {
                break;
            }
            case 1: {
                edition = S + "4" + S + "lSKYFATHER EDITION";
                break;
            }
            case 2: {
                edition = S + "3" + S + "lUNDERWORLD EDITION";
            }
        }
        this.pages.add("\n\n\n\u00a79by SBlectric and Rumaruka\u00a70\n\n\u00a7oA Guide to the\nWorld of Lightning!\u00a7r\n\n");
        this.pages.add("It is said only the very brave or the very stupid mess with one of the most dangerous forces of nature.\n\nFor one to harness such raw power, one would need very specialized tools and machines.");
        this.pages.add("Lucky for you, you've discovered how to build these machines.");
        this.pages.add(S + "lAir Terminals" + S + "r - Also known as lightning rods. They act as preferential paths for lightning to take when it strikes the ground. Used to charge lightning cells and use LE.");
        this.pages.add(S + "lLightning Cells" + S + "r - These store energy from lightning strikes, also known as Lightning Energy (LE). To store the energy of a strike, an air terminal needs to be directly above the lightning cell.");
        this.pages.add(S + "lLightning Furnace" + S + "r - This is a furnace that uses LE instead of solid fuel to smelt items. A lightning furnace smelts items much quicker than a normal furnace, using one LE per 2 items burned.");
        this.pages.add(S + "lLightning Crusher" + S + "r - This is a machine that pulverizes items. With it, you can crush gravel into sand, ores to powder, and much more! Great for ore processing and a handy tool in general.");
        this.pages.add(S + "lLightning Infusion Table" + S + "r - The mighty Lightning Infusion Table takes the idea of using LE to create items to the next level. An item in the center slot gets infused with items in the outer slots along with some LE.");
        this.pages.add(S + "lLightning Block Breaker" + S + "r - This machine simply uses LE to break the block directly in front of it. The breaker is placed in the same manner as pistons.");
        this.pages.add(S + "lLightning Miner" + S + "r - This useful machine will mine blocks in its area. It has 6 modes of operation: 1x1 tunnel, 3x3 tunnel, ores only, logs only, slot matching, and all blocks. The default range is a 16x16x16 cube in front of it, but it can be upgraded to 24x24x24.");
        this.pages.add(S + "lElectrostatic Generator" + S + "r - This gives you a method of generating lightning, and by extension, LE by using blocks to generate a charge. When the charge is full (100C), lightning will strike. It does need a small amount of LE to run, though.");
        if (EnergyApiHelper.rfOrTeslaLoaded) {
            this.pages.add(S + "lLE to RF Export Bus" + S + "r - This machine takes LE and converts it to RF or Tesla so other mod's machines can make use of it. It transfers at a max rate of " + 1024 + " RF/tick, where 1 LE yields " + LCConfig.RFtoLEConversion + " RF.");
            this.pages.add(S + "lRF Lightning Generator" + S + "r - This machine takes RF or Tesla and uses it to generate lightning strikes. It transfers at a max rate of " + 512 + " RF/tick, where " + LCConfig.RFtoLEConversion * 10 + " RF yields 1 LE.");
        }
        this.pages.add(S + "lWireless Power" + S + "r - Like Tesla, you've dreamt of wireless power. Today, you've discovered how to implement it. By creating a single transmitter from your core work area, you can add unlimited receivers nearby. To attune these receivers to the");
        this.pages.add("transmitter, you must craft a Tx/Rx tag, right click on the transmitter, then shift right-click on the receiver. These tags are reusable, and can be crafted back into an empty tag if you wish to mark a different transmitter location.");
        this.pages.add(S + "lEnchantment Reallocator" + S + "r - This can pull enchantments from an item and stick them on another. " + (level < 2 ? "You hypothesize about making such a machine, but you lack the mystical items to do so. Perhaps the answer lies in another realm..." : "By using various mystical items, you can finally make such a device."));
        this.pages.add("Now that you know the machinery, you should know some of the items and blocks you can create.");
        this.pages.add(S + "lThunderstone" + S + "r - A mysterious dense stone birthed from the depths of the earth. It seems to have semi-liquid properties and resist wear and tear. Four can be made with 4 cobblestone, 4 quartz, and a block of obsidian.");
        this.pages.add(S + "lElectricium" + S + "r - Iron and gold are nice, but you've discovered a way to create a metal better than each of them. Electricium has impressive electrical properties, too. Can be made by infusing iron with gold, diamond and LE or by striking them with lightning.");
        this.pages.add("Other Useful Items:\n\nThere are many useful things you can make with infusion, like diamonds from coal or sponges from wool and slimeballs. All infusion recipes can be found in the JEI and index.");
        this.pages.add("You've also discovered how to make new tools and armor.");
        this.pages.add(S + "lElectricium Tools" + S + "r - These tools are stronger, mine faster, and are more enchantable than vanilla tools, but are quite a bit more expensive to make. Made with electricium rods and ingots.");
        this.pages.add(S + "lElectricium Weapons" + S + "r - These weapons are quite powerful indeed. The sword and hammer have 9 and 10 attack damage respectively, and have latent electrical properties that can be brought out by the Hand of Thor enchantment.");
        this.pages.add(S + "lElectricium Armor" + S + "r - Offers slightly more protection than diamond armor and is more durable. Has latent electrical properties that can be brought out by the Electrostatic Aura enchantment.");
        this.pages.add(S + "lStonebound Swords" + S + "r - Stone doesn't channel LE very well, but by forcing LE through it, you can bind materials to it. You've discovered that infusing stone swords with several materials could have some interesting effects...");
        this.pages.add(S + "lMobile LE" + S + "r - Through your tinkering with electricium, you've discovered that, when combined with redstone, forms a primitive voltaic pile. By stabilizing this pile with iron rods and a comparator, you have managed to make a functional battery capable of storing a");
        this.pages.add("small amound of LE. You've learned that this battery can be charged from a lightning cell via a charging plate. Thus, when charged, this battery enables you to have a source of mobile LE when in your inventory. It may just come in handy!");
        this.pages.add(S + "lKinetics" + S + "r - You've discovered an interesting new field of research. It seems that by crafting a golden tool or piece of armor with redstone and an electricium plate somewhat similarly to making a battery, the electrical properties of the gold can be");
        this.pages.add("brought out. By providing these kinetic devices with a mobile source of raw power - lightning, perhaps? - you have found that the item's abilities are amplified many times over: a kinetic sword being over twice as powerful as a golden one, for example. Tools mining");
        this.pages.add("many times faster. Armor giving you invincibility. It seems that no feat is out of your reach now. You have even designed other trinkets that can use mobile LE to achieve neat functionalities.");
        if (level <= 0) {
            this.pages.add("Your mind turns to electricium. \"Sure, it's great!\" you say, but at the same time, you wonder if there is a material that offers more...");
            this.pages.add("What if... what if you were to infuse electricium... with thunderstone... and um... eyes of ender? Surely doing that wouldn't be taboo...!");
        } else {
            this.pageLevel1 = this.pages.size();
            this.pages.add("Your intuition was right. The Skyfather ingot is powerful indeed. You can make divine tools and armor out of this new material. Tools made this way have special properties, while both tools and armor automatically repair themselves.");
            this.pages.add("You can also make Lightning Upgrades by crafting a shard with four redstone, which will improve various machinery upon right-clicking.\nThe Skyfather Shard is useful, but the gods are taking notice of your mortal insolence. Demon Soldiers will now attack on sight.");
            if (level == 1) {
                this.pages.add("If you were to kill these demons, legend has it you can use their blood to forge a portal to the Underworld...");
            }
            this.pages.add("Perhaps even Skyfather stuff can be upgraded...");
        }
        if (level > 1) {
            this.pageLevel2 = this.pages.size();
            this.pages.add("You've made your portal to the Underworld. What you see is a vast, dark, and damp cavern filled with spiders, demons, and more. It seems that it is so dark that night vision completely fails.");
            this.pages.add("There are a few naturally generated structures that exist in this evil dimension.");
            this.pages.add(S + "lWater Temples" + S + "r - These seemingly serene temples spawn on the bottom ocean of the Underworld.");
            this.pages.add(S + "lUnderworld Towers" + S + "r - These monolithic structures, found at nearly any height, are home to the Skeletal Guards. The top rooms have untold treasures. The guards drop their bones, which can be used to create high tier items.");
            this.pages.add(S + "lStalactite Ramparts" + S + "r - These garrisons spawn on the top of the Underworld, with cannons aimed at anyone foolish enough to attempt to breach their walls. However, these structures also contain divine treasures, including the legendary Ichor.");
            this.pages.add(S + "lMobs" + S + "r - Aside from the demons and previously mentioned mobs, Deadly Undercreeps and Underghasts also roam the dark expanses of the Underworld. They will drop Underpowder when killed, which can then be used to make extremely powerful TNT.");
            this.pages.add("Demons have been attacking you on sight for some time now. Well, you've made a potion that can do away with that. By infusing a mundane potion with 2 demon blood and a 2 golden carrots, you've crafted a brew that keeps these demons at bay.");
            this.pages.add("If they're already chasing you down, it won't stop them, however, and it won't stop them from attacking you when you strike them. But it certainly is better than being attacked for like, no reason.");
            this.pages.add("This potion can be brewed into splash and lingering varieties, as well as be used to make tipped arrows. Demons probably won't like being under the demon warding effect...");
        }
        this.pageLevel3 = this.pages.size();
        this.addIndex();
        this.bookTotalPages = this.pages.size();
        this.level = level;
    }

    protected void addIndex() {
        String S = "\u00a7";
        boolean i = false;
        this.indexPage = this.pages.size();
        this.pages.add(S + "lIndex" + S + "r\nHere you can see all of the infusion recipes that you can make.");
        this.recipePage = this.pages.size();
        JointList results = new JointList();
        JointList costs = new JointList();
        for (LightningInfusionRecipe recipe : LightningInfusionRecipes.instance().getRecipeList()) {
            ItemStack result = recipe.getOutput();
            List<String> items = recipe.getItems();
            JointList<String> ingredients = new JointList<String>().join((Iterable<String>)items);
            ingredients.addFirst(recipe.getInfuseItem());
            int cost = recipe.getCost();
            this.pages.add(result.func_82833_r());
            this.recipePages.add(new RecipePage(this, result, ingredients, cost));
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonDone = new GuiButton(4, this.field_146294_l / 2 - 49, 196 + (this.level + 1) * 24, 98, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.level1Ref = new GuiButton(5, this.field_146294_l / 2 - 80, 196, 160, 20, "Skyfather Reference");
        this.level2Ref = new GuiButton(6, this.field_146294_l / 2 - 80, 220, 160, 20, "Underworld Reference");
        this.level3Ref = new GuiButton(7, this.field_146294_l / 2 - 80, 244, 160, 20, "Transcendental Reference");
        this.indexRef = new GuiButton(8, this.field_146294_l / 2 - 49, 196 + this.level * 24, 98, 20, "Index");
        this.field_146292_n.add(this.buttonDone);
        if (this.level > 0) {
            this.field_146292_n.add(this.level1Ref);
        }
        if (this.level > 1) {
            this.field_146292_n.add(this.level2Ref);
        }
        if (this.level > 2) {
            this.field_146292_n.add(this.level3Ref);
        }
        this.field_146292_n.add(this.indexRef);
        int offsetFromScreenLeft = (this.field_146294_l - 192) / 2;
        int inOff = 20;
        this.buttonNextPage = new NextPageButton(0, offsetFromScreenLeft + 120 - inOff, 156, true, false);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(1, offsetFromScreenLeft + 38 + inOff, 156, false, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.buttonLastPage = new NextPageButton(2, offsetFromScreenLeft + 145 - inOff, 156, true, true);
        this.field_146292_n.add(this.buttonLastPage);
        this.buttonFirstPage = new NextPageButton(3, offsetFromScreenLeft + 13 + inOff, 156, false, true);
        this.field_146292_n.add(this.buttonFirstPage);
    }

    public void func_73876_c() {
        this.buttonDone.field_146125_m = true;
        this.buttonNextPage.field_146125_m = this.currPage < this.bookTotalPages - 1;
        this.buttonPreviousPage.field_146125_m = this.currPage > 0;
    }

    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currPage == 0) {
            mc.func_110434_K().func_110577_a(bookCoverTexture);
        } else if (this.currPage < this.recipePage) {
            mc.func_110434_K().func_110577_a(bookMainTexture);
        } else {
            mc.func_110434_K().func_110577_a(bookRecipeTexture);
        }
        int offsetFromScreenLeft = (this.field_146294_l - 192) / 2;
        this.func_73729_b(offsetFromScreenLeft, 2, 0, 0, 192, 192);
        String stringPageIndicator = I18n.func_135052_a((String)"guide.pageIndicator", (Object[])new Object[]{this.currPage + 1, this.bookTotalPages});
        int widthOfString = this.field_146289_q.func_78256_a(stringPageIndicator);
        this.field_146289_q.func_78276_b(stringPageIndicator, offsetFromScreenLeft - widthOfString + 192 - 44, 18, 0);
        this.field_146289_q.func_78279_b((String)this.pages.get(this.currPage), offsetFromScreenLeft + 36, 34, 116, 0);
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
        if (this.currPage >= this.recipePage) {
            ((RecipePage)this.recipePages.get(this.currPage - this.recipePage)).drawPage(offsetFromScreenLeft, 2);
        }
    }

    protected void func_146273_a(int parMouseX, int parMouseY, int parLastButtonClicked, long parTimeSinceMouseClick) {
    }

    protected void func_146284_a(GuiButton parButton) {
        if (parButton == this.buttonDone) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
        } else if (parButton == this.buttonNextPage) {
            if (this.currPage < this.bookTotalPages - 1) {
                ++this.currPage;
            }
        } else if (parButton == this.buttonPreviousPage) {
            if (this.currPage > 0) {
                --this.currPage;
            }
        } else if (parButton == this.buttonFirstPage) {
            this.currPage = 0;
        } else if (parButton == this.buttonLastPage) {
            this.currPage = this.bookTotalPages - 1;
        } else if (parButton == this.level1Ref) {
            this.currPage = this.pageLevel1;
        } else if (parButton == this.level2Ref) {
            this.currPage = this.pageLevel2;
        } else if (parButton == this.level3Ref) {
            this.currPage = this.pageLevel3;
        } else if (parButton == this.indexRef) {
            this.currPage = this.indexPage;
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void drawItemStack(ItemStack stack, int x, int y) {
        if (stack != null && stack.func_77973_b() != null) {
            GL11.glDisable((int)2896);
            if (stack.func_77973_b() instanceof ItemBlock) {
                GL11.glEnable((int)32826);
                RenderHelper.func_74520_c();
            }
            this.field_146296_j.func_180450_b(stack, x, y);
            GL11.glDisable((int)32826);
            String stackSize = stack.func_190916_E() > 1 ? "" + stack.func_190916_E() : "";
            this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, stackSize);
            RenderHelper.func_74518_a();
        }
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        if (stack != null && stack.func_77973_b() != null) {
            super.func_146285_a(stack, x, y);
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean isNextButton;
        private final boolean isTurbo;

        public NextPageButton(int parButtonId, int parPosX, int parPosY, boolean parIsNextButton, boolean parIsTurbo) {
            super(parButtonId, parPosX, parPosY, 23, 13, "");
            this.isNextButton = parIsNextButton;
            this.isTurbo = parIsTurbo;
        }

        public void func_191745_a(Minecraft mc, int parX, int parY, float partialTicks) {
            if (this.field_146125_m) {
                boolean isButtonPressed = parX >= this.field_146128_h && parY >= this.field_146129_i && parX < this.field_146128_h + this.field_146120_f && parY < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(bookMainTexture);
                int textureX = this.isTurbo ? 46 : 0;
                int textureY = 192;
                if (isButtonPressed) {
                    textureX += 23;
                }
                if (!this.isNextButton) {
                    textureY += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, textureX, textureY, 23, 13);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class RecipePage {
        private static final Random rand = new Random();
        private static final int maxMetaTicks = 1;
        private static final int maxRecTicks = 50;
        private double metaTicks = 2.0;
        private double recTicks = 51.0;
        private long lasttime;
        private GuiLightningGuide book;
        private ItemStack result;
        private List<String> ingredients;
        private int cost;
        private boolean ignoreDamage;
        private int[] itemRotate;
        private ItemStack[] displayStack;
        private int dispDamage = 0;
        private AxisAlignedBB resultBox;
        private JointList<AxisAlignedBB> ingredientBoxes;

        public RecipePage(GuiLightningGuide book, ItemStack result, List<String> ingredients, int cost) {
            this.book = book;
            this.result = result.func_77946_l();
            this.ingredients = ingredients;
            this.cost = cost;
            this.ignoreDamage = false;
            this.lasttime = Minecraft.func_71386_F();
        }

        public void drawPage(int bookX, int bookY) {
            this.book.field_146289_q.func_78279_b(this.cost + " LE needed for this infusion", bookX + 36, 120, 116, 0);
            int xoff = 3;
            int yoff = -16;
            bookX += xoff;
            bookY += yoff;
            if (this.ignoreDamage && this.metaTicks >= 1.0) {
                ++this.dispDamage;
                if (this.dispDamage > this.result.func_77958_k()) {
                    this.dispDamage = Math.min(1, this.result.func_77958_k());
                }
                this.metaTicks = 0.0;
            }
            this.metaTicks += (double)(Minecraft.func_71386_F() - this.lasttime) / 50.0;
            this.resultBox = new AxisAlignedBB((double)(bookX + 120), (double)(bookY + 89), 0.0, (double)(bookX + 120 + 16), (double)(bookY + 89 + 16), 0.0);
            if (this.result.func_77958_k() > 0) {
                this.result.func_77964_b(this.dispDamage);
            }
            this.book.drawItemStack(this.result, (int)this.resultBox.field_72340_a, (int)this.resultBox.field_72338_b);
            this.ingredientBoxes = new JointList();
            this.ingredientBoxes.add(new AxisAlignedBB((double)(bookX + 59), (double)(bookY + 89), 0.0, (double)(bookX + 59 + 16), (double)(bookY + 89 + 16), 0.0));
            this.ingredientBoxes.add(new AxisAlignedBB((double)(bookX + 59), (double)(bookY + 69), 0.0, (double)(bookX + 59 + 16), (double)(bookY + 69 + 16), 0.0));
            this.ingredientBoxes.add(new AxisAlignedBB((double)(bookX + 79), (double)(bookY + 89), 0.0, (double)(bookX + 79 + 16), (double)(bookY + 89 + 16), 0.0));
            this.ingredientBoxes.add(new AxisAlignedBB((double)(bookX + 59), (double)(bookY + 109), 0.0, (double)(bookX + 59 + 16), (double)(bookY + 109 + 16), 0.0));
            this.ingredientBoxes.add(new AxisAlignedBB((double)(bookX + 39), (double)(bookY + 89), 0.0, (double)(bookX + 39 + 16), (double)(bookY + 89 + 16), 0.0));
            boolean change = this.recTicks >= 50.0;
            Integer[] shuffle = new Integer[]{1, 2, 3, 4};
            if (change) {
                Collections.shuffle(Arrays.asList(shuffle));
                this.itemRotate = new int[this.ingredientBoxes.size()];
            }
            this.displayStack = new ItemStack[this.ingredientBoxes.size()];
            for (int i = 0; i < this.ingredientBoxes.size(); ++i) {
                ItemStack itemStack;
                if (change) {
                    this.itemRotate[i] = i > 0 ? shuffle[i - 1] : 0;
                    this.recTicks = 0.0;
                }
                if ((itemStack = StackHelper.animateItemStackFromString(this.ingredients.get(this.itemRotate[i]), change)).func_190926_b()) continue;
                this.displayStack[i] = itemStack;
                if (this.displayStack[i].func_77958_k() > 0) {
                    this.displayStack[i].func_77964_b(Math.min(this.displayStack[i].func_77958_k(), this.dispDamage));
                }
                this.book.drawItemStack(this.displayStack[i], (int)((AxisAlignedBB)this.ingredientBoxes.get((int)i)).field_72340_a, (int)((AxisAlignedBB)this.ingredientBoxes.get((int)i)).field_72338_b);
            }
            this.recTicks += (double)(Minecraft.func_71386_F() - this.lasttime) / 50.0;
            this.lasttime = Minecraft.func_71386_F();
            this.drawTooltips();
        }

        public void drawTooltips() {
            if (LCMisc.mouseColl(this.book.mouseX, this.book.mouseY, this.resultBox)) {
                this.book.func_146285_a(this.result, this.book.mouseX, this.book.mouseY);
            }
            for (int i = 0; i < this.ingredientBoxes.size(); ++i) {
                if (!LCMisc.mouseColl(this.book.mouseX, this.book.mouseY, (AxisAlignedBB)this.ingredientBoxes.get(i))) continue;
                this.book.func_146285_a(this.displayStack[i], this.book.mouseX, this.book.mouseY);
            }
        }
    }
}

