/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.dimensions;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import sblectric.lightningcraft.init.LCBlocks;

public class TeleporterLC
extends Teleporter {
    private final int dimFrom;
    private final WorldServer worldServerInstance;
    private final Random random;
    private final Long2ObjectMap<PortalPosition> destinationCoordinateCache = new Long2ObjectOpenHashMap(4096);
    private final List<Long> destinationCoordinateKeys = Lists.newArrayList();

    public TeleporterLC(int dimFrom, WorldServer worldIn) {
        super(worldIn);
        this.dimFrom = dimFrom;
        this.worldServerInstance = worldIn;
        this.random = new Random(worldIn.func_72905_C());
    }

    public void func_180266_a(Entity entityIn, float rotationYaw) {
        if (!this.func_180620_b(entityIn, rotationYaw)) {
            this.func_85188_a(entityIn);
            this.func_180620_b(entityIn, rotationYaw);
        }
    }

    public boolean func_180620_b(Entity entityIn, float rotationYaw) {
        int i = 128;
        double d0 = -1.0;
        int j = MathHelper.func_76128_c((double)entityIn.field_70165_t);
        int k = MathHelper.func_76128_c((double)entityIn.field_70161_v);
        boolean flag = true;
        Object blockpos = BlockPos.field_177992_a;
        long l = ChunkPos.func_77272_a((int)j, (int)k);
        if (this.destinationCoordinateCache.containsKey(l)) {
            PortalPosition ppos = (PortalPosition)((Object)this.destinationCoordinateCache.get(l));
            d0 = 0.0;
            blockpos = ppos;
            ppos.field_85087_d = this.worldServerInstance.func_82737_E();
            flag = false;
        } else {
            BlockPos bp3 = new BlockPos(entityIn);
            for (int i1 = -128; i1 <= 128; ++i1) {
                for (int j1 = -128; j1 <= 128; ++j1) {
                    BlockPos bp1 = bp3.func_177982_a(i1, this.worldServerInstance.func_72940_L() - 1 - bp3.func_177956_o(), j1);
                    while (bp1.func_177956_o() >= 0) {
                        BlockPos bp2 = bp1.func_177977_b();
                        if (this.worldServerInstance.func_180495_p(bp1).func_177230_c() == LCBlocks.underPortal) {
                            while (this.worldServerInstance.func_180495_p(bp2 = bp1.func_177977_b()).func_177230_c() == LCBlocks.underPortal) {
                                bp1 = bp2;
                            }
                            double d1 = bp1.func_177951_i((Vec3i)bp3);
                            if (d0 < 0.0 || d1 < d0) {
                                d0 = d1;
                                blockpos = bp1;
                            }
                        }
                        bp1 = bp2;
                    }
                }
            }
        }
        if (d0 >= 0.0) {
            if (flag) {
                this.destinationCoordinateCache.put(l, (Object)new PortalPosition((BlockPos)blockpos, this.worldServerInstance.func_82737_E()));
                this.destinationCoordinateKeys.add(l);
            }
            double d5 = (double)blockpos.func_177958_n() + 0.5;
            double d6 = (double)blockpos.func_177956_o() + 0.5;
            double d7 = (double)blockpos.func_177952_p() + 0.5;
            if (entityIn instanceof EntityPlayerMP) {
                EntityPlayerMP ply = (EntityPlayerMP)entityIn;
                ply.field_71135_a.func_147364_a(d5, d6, d7, ply.field_70177_z, ply.field_70125_A);
            } else {
                entityIn.func_70012_b(d5, d6, d7, entityIn.field_70177_z, entityIn.field_70125_A);
            }
            entityIn.field_70179_y = 0.0;
            entityIn.field_70181_x = 0.0;
            entityIn.field_70159_w = 0.0;
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity ent) {
        int i = 16;
        double d0 = -1.0;
        int j = MathHelper.func_76128_c((double)ent.field_70165_t);
        int k = MathHelper.func_76128_c((double)ent.field_70163_u);
        int l = MathHelper.func_76128_c((double)ent.field_70161_v);
        int i1 = j;
        int j1 = k;
        int k1 = l;
        int l1 = 0;
        int i2 = this.random.nextInt(4);
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        for (int j2 = j - i; j2 <= j + i; ++j2) {
            double d1 = (double)j2 + 0.5 - ent.field_70165_t;
            for (int l2 = l - i; l2 <= l + i; ++l2) {
                double d2 = (double)l2 + 0.5 - ent.field_70161_v;
                block2: for (int j3 = this.worldServerInstance.func_72940_L() - 1; j3 >= 0; --j3) {
                    if (!this.worldServerInstance.func_175623_d((BlockPos)mpos.func_181079_c(j2, j3, l2))) continue;
                    while (j3 > 0 && this.worldServerInstance.func_175623_d((BlockPos)mpos.func_181079_c(j2, j3 - 1, l2))) {
                        --j3;
                    }
                    for (int k3 = i2; k3 < i2 + 4; ++k3) {
                        int l3 = k3 % 2;
                        int i4 = 1 - l3;
                        if (k3 % 4 >= 2) {
                            l3 = -l3;
                            i4 = -i4;
                        }
                        for (int j4 = 0; j4 < 3; ++j4) {
                            for (int k4 = 0; k4 < 4; ++k4) {
                                for (int l4 = -1; l4 < 4; ++l4) {
                                    int i5 = j2 + (k4 - 1) * l3 + j4 * i4;
                                    int j5 = j3 + l4;
                                    int k5 = l2 + (k4 - 1) * i4 - j4 * l3;
                                    mpos.func_181079_c(i5, j5, k5);
                                    IBlockState state = this.worldServerInstance.func_180495_p((BlockPos)mpos);
                                    if (l4 < 0 && !state.func_177230_c().func_149688_o(state).func_76220_a() || l4 >= 0 && !this.worldServerInstance.func_175623_d((BlockPos)mpos)) continue block2;
                                }
                            }
                        }
                        double d5 = (double)j3 + 0.5 - ent.field_70163_u;
                        double d7 = d1 * d1 + d5 * d5 + d2 * d2;
                        if (!(d0 < 0.0) && !(d7 < d0)) continue;
                        d0 = d7;
                        i1 = j2;
                        j1 = j3;
                        k1 = l2;
                        l1 = k3 % 4;
                    }
                }
            }
        }
        if (d0 < 0.0) {
            for (int l5 = j - i; l5 <= j + i; ++l5) {
                double d3 = (double)l5 + 0.5 - ent.field_70165_t;
                for (int j6 = l - i; j6 <= l + i; ++j6) {
                    double d4 = (double)j6 + 0.5 - ent.field_70161_v;
                    block10: for (int i7 = this.worldServerInstance.func_72940_L() - 1; i7 >= 0; --i7) {
                        if (!this.worldServerInstance.func_175623_d((BlockPos)mpos.func_181079_c(l5, i7, j6))) continue;
                        while (i7 > 0 && this.worldServerInstance.func_175623_d((BlockPos)mpos.func_181079_c(l5, i7 - 1, j6))) {
                            --i7;
                        }
                        for (int k7 = i2; k7 < i2 + 2; ++k7) {
                            int j8 = k7 % 2;
                            int j9 = 1 - j8;
                            for (int j10 = 0; j10 < 4; ++j10) {
                                for (int j11 = -1; j11 < 4; ++j11) {
                                    int j12 = l5 + (j10 - 1) * j8;
                                    int i13 = i7 + j11;
                                    int j13 = j6 + (j10 - 1) * j9;
                                    mpos.func_181079_c(j12, i13, j13);
                                    IBlockState state = this.worldServerInstance.func_180495_p((BlockPos)mpos);
                                    if (j11 < 0 && !state.func_177230_c().func_149688_o(state).func_76220_a() || j11 >= 0 && !this.worldServerInstance.func_175623_d((BlockPos)mpos)) continue block10;
                                }
                            }
                            double d6 = (double)i7 + 0.5 - ent.field_70163_u;
                            double d8 = d3 * d3 + d6 * d6 + d4 * d4;
                            if (!(d0 < 0.0) && !(d8 < d0)) continue;
                            d0 = d8;
                            i1 = l5;
                            j1 = i7;
                            k1 = j6;
                            l1 = k7 % 2;
                        }
                    }
                }
            }
        }
        int i6 = i1;
        int k2 = j1;
        int k6 = k1;
        int l6 = l1 % 2;
        int i3 = 1 - l6;
        if (l1 % 4 >= 2) {
            l6 = -l6;
            i3 = -i3;
        }
        if (d0 < 0.0) {
            k2 = j1 = MathHelper.func_76125_a((int)j1, (int)70, (int)(this.worldServerInstance.func_72940_L() - 10));
            for (int j7 = -1; j7 <= 1; ++j7) {
                for (int l7 = 1; l7 < 3; ++l7) {
                    for (int k8 = -1; k8 < 3; ++k8) {
                        int k9 = i6 + (l7 - 1) * l6 + j7 * i3;
                        int k10 = k2 + k8;
                        int k11 = k6 + (l7 - 1) * i3 - j7 * l6;
                        boolean flag = k8 < 0;
                        this.worldServerInstance.func_175656_a(new BlockPos(k9, k10, k11), flag ? LCBlocks.stoneBlock.func_176203_a(3) : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        IBlockState iblockstate = LCBlocks.underPortal.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)(l6 != 0 ? EnumFacing.Axis.X : EnumFacing.Axis.Z));
        for (int i8 = 0; i8 < 4; ++i8) {
            for (int l8 = 0; l8 < 4; ++l8) {
                for (int l9 = -1; l9 < 4; ++l9) {
                    int l10 = i6 + (l8 - 1) * l6;
                    int l11 = k2 + l9;
                    int k12 = k6 + (l8 - 1) * i3;
                    boolean flag1 = l8 == 0 || l8 == 3 || l9 == -1 || l9 == 3;
                    this.worldServerInstance.func_180501_a(new BlockPos(l10, l11, k12), flag1 ? LCBlocks.stoneBlock.func_176203_a(3) : iblockstate, 2);
                }
            }
            for (int i9 = 0; i9 < 4; ++i9) {
                for (int i10 = -1; i10 < 4; ++i10) {
                    int i11 = i6 + (i9 - 1) * l6;
                    int i12 = k2 + i10;
                    int l12 = k6 + (i9 - 1) * i3;
                    BlockPos blockpos = new BlockPos(i11, i12, l12);
                    this.worldServerInstance.func_175685_c(blockpos, this.worldServerInstance.func_180495_p(blockpos).func_177230_c(), false);
                }
            }
        }
        return true;
    }

    public void func_85189_a(long worldTime) {
        if (worldTime % 100L == 0L) {
            Iterator<Long> iterator = this.destinationCoordinateKeys.iterator();
            long i = worldTime - 300L;
            while (iterator.hasNext()) {
                Long olong = iterator.next();
                PortalPosition teleporter$portalposition = (PortalPosition)((Object)this.destinationCoordinateCache.get(olong.longValue()));
                if (teleporter$portalposition != null && teleporter$portalposition.field_85087_d >= i) continue;
                iterator.remove();
                this.destinationCoordinateCache.remove(olong.longValue());
            }
        }
    }

    public class PortalPosition
    extends Teleporter.PortalPosition {
        public PortalPosition(BlockPos pos, long lastUpdate) {
            super((Teleporter)TeleporterLC.this, pos, lastUpdate);
        }
    }
}

