/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.config;

import java.io.File;
import net.minecraft.init.Blocks;
import sblectric.lightningcraft.config.ConfigurationCustom;
import sblectric.lightningcraft.integration.energy.EnergyApiHelper;
import sblectric.lightningcraft.ref.Log;

public class LCConfig {
    public static boolean portalEnabled;
    public static int portalCooldown;
    public static boolean demonSoldiersAlwaysNeutral;
    public static boolean demonSoldiersInNether;
    public static boolean demonSoldiersFullPower;
    public static boolean useVanillaGhastSounds;
    public static boolean upgradeEnabled;
    public static String[] minerFillerBlocks;
    public static int minerMaxRetries;
    public static boolean autoSmelt;
    public static boolean autoRepair;
    public static boolean mysticGear;
    public static int underworldDimensionID;
    public static boolean JEIIntegration;
    public static boolean RFIntegration;
    public static int RFtoLEConversion;
    public static boolean tinkersIntegration;
    public static boolean disableOtherRods;
    public static boolean chiselIntegration;
    public static boolean chiselCorruptStone;

    private static void setDefaultValues() {
        portalEnabled = true;
        portalCooldown = 200;
        demonSoldiersAlwaysNeutral = false;
        demonSoldiersFullPower = false;
        demonSoldiersInNether = true;
        useVanillaGhastSounds = false;
        upgradeEnabled = true;
        minerFillerBlocks = new String[]{Blocks.field_150347_e.getRegistryName().toString(), Blocks.field_150346_d.getRegistryName().toString(), Blocks.field_150354_m.getRegistryName().toString()};
        minerMaxRetries = 256;
        autoSmelt = true;
        autoRepair = true;
        mysticGear = true;
        underworldDimensionID = -9;
        JEIIntegration = true;
        RFIntegration = true;
        RFtoLEConversion = 50;
        tinkersIntegration = true;
        disableOtherRods = true;
        chiselIntegration = true;
        chiselCorruptStone = true;
    }

    public static void loadConfig(File f) {
        ConfigurationCustom config = new ConfigurationCustom(f);
        LCConfig.setDefaultValues();
        config.load();
        String category = "General";
        portalEnabled = config.getBoolean("Portal Enabled", category, portalEnabled, "Set to false to disable default portal creation.");
        portalCooldown = config.getInt("Portal Cooldown Time", category, portalCooldown, "The cooldown time for the underworld portal. Increase if repeated teleporting occurs.");
        demonSoldiersAlwaysNeutral = config.getBoolean("Wuss Mode", category, demonSoldiersAlwaysNeutral, "Set to true if Demon Soldiers should only attack the player if they are attacked first");
        demonSoldiersInNether = config.getBoolean("Demon Soldiers Spawn in Nether", category, demonSoldiersInNether, "Set to false if Demon Soldiers should not spawn in the Nether");
        demonSoldiersFullPower = config.getBoolean("Classic Demon Soldiers", category, demonSoldiersFullPower, "Set to true if Demon Soldiers should NOT be weaker outside of the Underworld");
        useVanillaGhastSounds = config.getBoolean("Use Vanilla Ghast Sounds", category, useVanillaGhastSounds, "Whether or not to use the vanilla ghast sounds for the Underghast instead of the provided ones");
        category = "Machines";
        upgradeEnabled = config.getBoolean("Enable Lightning Upgrading", category, upgradeEnabled, "If false, right clicking machines with the Lightning Upgrade will do nothing");
        minerFillerBlocks = config.getStringList("Miner Filler Blocks", category, minerFillerBlocks, "This is the list of blocks the miner considers filler. It will optionally use these to fill its mined area, and won't mine these blocks.");
        minerMaxRetries = config.getInt("Max Miner Block Search Retries", category, minerMaxRetries, "The max amount of mining retries. Decrease if StackOverflowExceptions occur.");
        category = "Tools and Armor";
        autoSmelt = config.getBoolean("Enable Skyfather Autosmelting", category, autoSmelt, "Whether or not Skyfather and Mystic tools will auto-smelt mined blocks.");
        autoRepair = config.getBoolean("Enable Mystic Auto-repair", category, autoRepair, "Whether or not Mystic tools will auto-repair.");
        mysticGear = config.getBoolean("Enable Mystic Gear", category, autoRepair, "If false, Mystic gear will not be able to be created.");
        category = "Worldgen";
        underworldDimensionID = config.getInt("Underworld Dimension ID", category, underworldDimensionID, "The ID for the Underworld dimension");
        category = "Mod Integration";
        JEIIntegration = config.getBoolean("JEI integration", category, JEIIntegration, "Enable JEI integration?");
        RFIntegration = config.getBoolean("RF integration", category, RFIntegration, "Enable LE <-> RF / TESLA conversion machines?");
        if (!RFIntegration) {
            EnergyApiHelper.rfOrTeslaLoaded = false;
        }
        RFtoLEConversion = config.getInt("RF to LE conversion", category, RFtoLEConversion, "This amount of RF / TESLA is equal to 1 LE (for 1 LE -> x RF conversion). The reverse will be 10 times costlier.");
        tinkersIntegration = config.getBoolean("Tinker's Construct integration", category, tinkersIntegration, "Enable smeltery support for electricium, skyfather, and mystic metals");
        disableOtherRods = config.getBoolean("Remove Other Mods' Rods", category, disableOtherRods, "Will remove the crafting recipes of all other mods' rods that LightningCraft has its own versions of.");
        chiselIntegration = config.getBoolean("Chisel integration", category, chiselIntegration, "Enable support for chiseling several LightningCraft block types");
        chiselCorruptStone = config.getBoolean("Enable corrupt stone chiseling", category, chiselCorruptStone, "Should one be able to chisel stone and stone bricks to corrupt stone? Will only apply if chisel integration is enabled.");
        if (config.hasChanged()) {
            config.save();
        }
        Log.logger.info("Config loaded.");
    }
}

