/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.anvil;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.vanilla.anvil.AnvilRecipeDataCache;
import mezz.jei.plugins.vanilla.anvil.AnvilRecipeDisplayData;
import mezz.jei.plugins.vanilla.anvil.AnvilRecipeMaker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class AnvilRecipeWrapper
implements IRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final List<List<ItemStack>> output;

    public AnvilRecipeWrapper(List<ItemStack> leftInput, List<ItemStack> rightInputs, List<ItemStack> outputs) {
        this.inputs = ImmutableList.of(leftInput, rightInputs);
        this.output = Collections.singletonList(outputs);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        AnvilRecipeDisplayData data = AnvilRecipeDataCache.getDisplayData(this);
        Map<Integer, ? extends IGuiIngredient<ItemStack>> currentIngredients = data.getCurrentIngredients();
        if (currentIngredients == null) {
            return;
        }
        ItemStack newLeftStack = currentIngredients.get(0).getDisplayedIngredient();
        ItemStack newRightStack = currentIngredients.get(1).getDisplayedIngredient();
        if (newLeftStack == null || newRightStack == null) {
            return;
        }
        ItemStack lastLeftStack = data.getLastLeftStack();
        ItemStack lastRightStack = data.getLastRightStack();
        int lastCost = data.getLastCost();
        if (lastLeftStack == null || lastRightStack == null || !ItemStack.func_77989_b((ItemStack)lastLeftStack, (ItemStack)newLeftStack) || !ItemStack.func_77989_b((ItemStack)lastRightStack, (ItemStack)newRightStack)) {
            lastCost = AnvilRecipeMaker.findLevelsCost(newLeftStack, newRightStack);
            data.setLast(newLeftStack, newRightStack, lastCost);
        }
        if (lastCost != 0) {
            String costText = lastCost < 0 ? "err" : Integer.toString(lastCost);
            String text = I18n.func_135052_a((String)"container.repair.cost", (Object[])new Object[]{costText});
            int mainColor = -8323296;
            EntityPlayerSP player = minecraft.field_71439_g;
            if (!(player == null || lastCost < 40 && lastCost <= player.field_71068_ca || player.field_71075_bZ.field_75098_d)) {
                mainColor = -40864;
            }
            this.drawRepairCost(minecraft, text, mainColor, recipeWidth);
        }
    }

    private void drawRepairCost(Minecraft minecraft, String text, int mainColor, int recipeWidth) {
        int shadowColor = 0xFF000000 | (mainColor & 0xFCFCFC) >> 2;
        int width = minecraft.field_71466_p.func_78256_a(text);
        int x = recipeWidth - 2 - width;
        int y = 27;
        if (minecraft.field_71466_p.func_82883_a()) {
            Gui.func_73734_a((int)(x - 2), (int)(y - 2), (int)(x + width + 2), (int)(y + 10), (int)-16777216);
            Gui.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + width + 1), (int)(y + 9), (int)-12895429);
        } else {
            minecraft.field_71466_p.func_78276_b(text, x + 1, y, shadowColor);
            minecraft.field_71466_p.func_78276_b(text, x, y + 1, shadowColor);
            minecraft.field_71466_p.func_78276_b(text, x + 1, y + 1, shadowColor);
        }
        minecraft.field_71466_p.func_78276_b(text, x, y, mainColor);
    }

    @Override
    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.output);
    }
}

