/*
 * Decompiled with CFR 0.152.
 */
package xt9.inworldcrafting.common.event;

import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xt9.inworldcrafting.common.recipe.ExplodeBlockRecipe;
import xt9.inworldcrafting.common.recipe.ExplodeItemRecipe;
import xt9.inworldcrafting.common.util.ParticleMessageHelper;

@Mod.EventBusSubscriber
public class ExplosionCraft {
    @SubscribeEvent
    public static void somethingWentBoom(ExplosionEvent.Detonate event) {
        if (!event.getWorld().field_72995_K) {
            List affectedEntities = event.getAffectedEntities();
            List affectedBlocks = event.getAffectedBlocks();
            ExplodeItemRecipe.recipes.forEach(r -> affectedEntities.forEach(entity -> {
                if (entity instanceof EntityItem) {
                    ItemStack spawnedStack = ((EntityItem)entity).func_92059_d();
                    if (r.getInputs().matches(CraftTweakerMC.getIItemStack((ItemStack)spawnedStack))) {
                        ExplosionCraft.handleExplodeItemCraft(event, r, (EntityItem)entity);
                    }
                }
            }));
            ExplodeBlockRecipe.recipes.forEach(r -> affectedBlocks.forEach(blockPos -> {
                IBlockState currentState = event.getWorld().func_180495_p(blockPos);
                if (currentState.func_177230_c() == Blocks.field_150350_a) {
                    return;
                }
                if (Objects.equals(currentState.func_177230_c().getRegistryName(), r.getInputBlock().getRegistryName()) && currentState.func_177230_c().func_176201_c(currentState) == r.getInputStack().func_77952_i()) {
                    ExplosionCraft.handleExplodeBlockCraft(event, r, blockPos);
                }
            }));
        }
    }

    private static void handleExplodeBlockCraft(ExplosionEvent.Detonate event, ExplodeBlockRecipe recipe, BlockPos blockPos) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        event.getWorld().func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
        if (recipe.getItemSpawnChance() >= rand.nextInt(1, 100)) {
            EntityItem item = new EntityItem(event.getWorld(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), recipe.getOutputStack().func_77946_l());
            item.field_70159_w = 0.0;
            item.field_70181_x = 0.0;
            item.field_70179_y = 0.0;
            item.func_174867_a(10);
            ParticleMessageHelper.visualizeCrafting(event.getWorld(), "black", item.field_70165_t, item.field_70163_u, item.field_70161_v, 80);
            event.getWorld().func_72838_d((Entity)item);
        }
    }

    private static void handleExplodeItemCraft(ExplosionEvent.Detonate event, ExplodeItemRecipe recipe, EntityItem entity) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        if (entity.func_92059_d().func_190916_E() == 0) {
            return;
        }
        int recipeNum = (int)Math.floor(entity.func_92059_d().func_190916_E() / recipe.getInputAmount());
        for (int i = 0; i < recipeNum; ++i) {
            EntityItem item = new EntityItem(event.getWorld(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, recipe.getOutputStack().func_77946_l());
            item.field_70159_w = 0.0;
            item.field_70181_x = 0.0;
            item.field_70179_y = 0.0;
            item.func_174867_a(10);
            if (recipe.getSurviveChance() < rand.nextInt(1, 100)) continue;
            ParticleMessageHelper.visualizeCrafting(event.getWorld(), "black", item.field_70165_t, item.field_70163_u, item.field_70161_v, 80);
            event.getWorld().func_72838_d((Entity)item);
            entity.func_92059_d().func_190918_g(recipe.getInputAmount());
        }
    }
}

