/*
 * Decompiled with CFR 0.152.
 */
package xt9.inworldcrafting.common.crafting;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import xt9.inworldcrafting.common.recipe.BurnItemRecipe;
import xt9.inworldcrafting.common.recipe.FluidToFluidRecipe;
import xt9.inworldcrafting.common.recipe.FluidToItemRecipe;
import xt9.inworldcrafting.common.util.ParticleMessageHelper;
import xt9.inworldcrafting.common.util.WorldHelper;

public class CraftingItem {
    private List<Integer> fluidToFluidRecipeIndexes = new ArrayList<Integer>();
    private List<Integer> fluidToItemRecipeIndexes = new ArrayList<Integer>();
    private World world;
    private EntityItem item;
    private List<EntityItem> nearbyItems = new ArrayList<EntityItem>();
    private int burnItemRecipeIndex = -1;
    private int burnProgress = 0;

    public CraftingItem(NBTTagCompound tag) {
        this.deserialize(tag);
    }

    public void deserialize(NBTTagCompound tag) {
        this.fluidToFluidRecipeIndexes = tag.func_74764_b("fluidToFluidRecipeIndexes") ? this.getListFromArray(tag.func_74759_k("fluidToFluidRecipeIndexes")) : new ArrayList<Integer>();
        this.fluidToItemRecipeIndexes = tag.func_74764_b("fluidToItemRecipeIndexes") ? this.getListFromArray(tag.func_74759_k("fluidToItemRecipeIndexes")) : new ArrayList<Integer>();
        this.burnItemRecipeIndex = tag.func_74764_b("burnItemRecipeIndex") ? tag.func_74762_e("burnItemRecipeIndex") : -1;
        this.burnProgress = tag.func_74762_e("burnProgress");
    }

    public NBTTagCompound serialize() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("fluidToFluidRecipeIndexes", this.getArrayFromList(this.fluidToFluidRecipeIndexes));
        tag.func_74783_a("fluidToItemRecipeIndexes", this.getArrayFromList(this.fluidToItemRecipeIndexes));
        tag.func_74768_a("burnItemRecipeIndex", this.burnItemRecipeIndex);
        tag.func_74768_a("burnProgress", this.burnProgress);
        return tag;
    }

    public void addFluidToFluidRecipeIndex(int index) {
        this.fluidToFluidRecipeIndexes.add(index);
    }

    public void addFluidToItemRecipeIndex(int index) {
        this.fluidToItemRecipeIndexes.add(index);
    }

    public void setBurnItemRecipe(int index) {
        this.burnItemRecipeIndex = index;
    }

    public boolean containsRecipes() {
        return this.fluidToItemRecipeIndexes.size() > 0 || this.fluidToFluidRecipeIndexes.size() > 0 || this.burnItemRecipeIndex != -1;
    }

    public void update(EntityItem item, World world) {
        this.world = world;
        this.item = item;
        if (this.containsRecipes()) {
            IBlockState state = world.func_180495_p(item.func_180425_c());
            this.nearbyItems.clear();
            this.nearbyItems.addAll(WorldHelper.getAllItemEntitiesAtPosition(world, item.func_180425_c()));
            this.nearbyItems.removeIf(entityItem -> world.func_180495_p(entityItem.func_180425_c()) != state);
            if (!this.fluidToFluidRecipeIndexes.isEmpty()) {
                this.fluidToFluidRecipeIndexes.forEach(i -> {
                    if (i < FluidToFluidRecipe.recipes.size()) {
                        FluidToFluidRecipe r = FluidToFluidRecipe.recipes.get((int)i);
                        Fluid inputFluid = FluidRegistry.getFluid((String)r.getInputFluid());
                        this.updateFluidToFluid(state, inputFluid.getBlock(), r);
                    }
                });
            }
            if (!this.fluidToItemRecipeIndexes.isEmpty()) {
                this.fluidToItemRecipeIndexes.forEach(i -> {
                    if (i < FluidToItemRecipe.recipes.size()) {
                        FluidToItemRecipe r = FluidToItemRecipe.recipes.get((int)i);
                        Fluid inputFluid = FluidRegistry.getFluid((String)r.getInputFluid());
                        this.updateFluidToItem(state, inputFluid.getBlock(), r);
                    }
                });
            }
            if (this.burnItemRecipeIndex != -1 && this.burnItemRecipeIndex < BurnItemRecipe.recipes.size()) {
                BurnItemRecipe r = BurnItemRecipe.recipes.get(this.burnItemRecipeIndex);
                if (!item.func_70027_ad()) {
                    this.burnProgress = 0;
                }
                if (item.func_70027_ad()) {
                    ++this.burnProgress;
                    if (this.burnProgress == r.getTicks()) {
                        this.updateBurnItem(r);
                    }
                }
            }
        }
    }

    private void updateFluidToFluid(IBlockState state, Block block, FluidToFluidRecipe recipe) {
        if (state.func_177230_c() == block && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            Fluid outFluid;
            NonNullList required = NonNullList.func_191196_a();
            required.addAll(Arrays.asList(recipe.getInputs()));
            HashMap<EntityItem, Integer> used = new HashMap<EntityItem, Integer>();
            block0: for (EntityItem entityItem : this.nearbyItems) {
                if (entityItem.func_92059_d().func_190916_E() == 0) {
                    entityItem.func_70106_y();
                    return;
                }
                Iterator req = required.iterator();
                while (req.hasNext()) {
                    IIngredient ingredient = (IIngredient)req.next();
                    if (!ingredient.amount(1).matches(CraftTweakerMC.getIItemStack((ItemStack)entityItem.func_92059_d()).amount(1))) continue;
                    if (entityItem.func_92059_d().func_190916_E() < ingredient.getAmount()) {
                        used.put(entityItem, entityItem.func_92059_d().func_190916_E());
                        required.add((Object)ingredient.amount(ingredient.getAmount() - entityItem.func_92059_d().func_190916_E()));
                    } else {
                        used.put(entityItem, ingredient.getAmount());
                    }
                    req.remove();
                    continue block0;
                }
            }
            if (required.isEmpty() && (outFluid = FluidRegistry.getFluid((String)recipe.getOutputFluid())).getBlock() != null) {
                this.world.func_180501_a(this.item.func_180425_c(), outFluid.getBlock().func_176223_P(), 3);
                if (recipe.willConsume()) {
                    this.shrinkAndUpdateItems(used);
                    ParticleMessageHelper.visualizeCrafting(this.world, "white", this.item.field_70165_t, this.item.field_70163_u, this.item.field_70161_v, 8);
                }
            }
        }
    }

    private void updateFluidToItem(IBlockState state, Block block, FluidToItemRecipe recipe) {
        if (state.func_177230_c() == block) {
            if (this.item.func_92059_d().func_190916_E() == 0) {
                this.item.func_70106_y();
                return;
            }
            EntityItem output = new EntityItem(this.world, this.item.field_70165_t, this.item.field_70163_u, this.item.field_70161_v, recipe.getOutputStack().func_77946_l());
            output.field_70159_w = 0.0;
            output.field_70181_x = 0.0;
            output.field_70179_y = 0.0;
            output.func_174867_a(10);
            NonNullList required = NonNullList.func_191196_a();
            required.addAll(Arrays.asList(recipe.getInputs()));
            HashMap<EntityItem, Integer> used = new HashMap<EntityItem, Integer>();
            block0: for (EntityItem entityItem : this.nearbyItems) {
                if (entityItem.func_92059_d().func_190916_E() == 0) {
                    entityItem.func_70106_y();
                    return;
                }
                Iterator req = required.iterator();
                while (req.hasNext()) {
                    IIngredient ingredient = (IIngredient)req.next();
                    if (!ingredient.amount(1).matches(CraftTweakerMC.getIItemStack((ItemStack)entityItem.func_92059_d()).amount(1))) continue;
                    if (entityItem.func_92059_d().func_190916_E() < ingredient.getAmount()) {
                        used.put(entityItem, entityItem.func_92059_d().func_190916_E());
                        required.add((Object)ingredient.amount(ingredient.getAmount() - entityItem.func_92059_d().func_190916_E()));
                    } else {
                        used.put(entityItem, ingredient.getAmount());
                    }
                    req.remove();
                    continue block0;
                }
            }
            if (required.isEmpty()) {
                if (recipe.willConsume()) {
                    if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                        this.world.func_180501_a(this.item.func_180425_c(), Blocks.field_150350_a.func_176223_P(), 3);
                        this.world.func_72838_d((Entity)output);
                        this.shrinkAndUpdateItems(used);
                        ParticleMessageHelper.visualizeCrafting(this.world, "white", this.item.field_70165_t, this.item.field_70163_u, this.item.field_70161_v, 8);
                    }
                } else {
                    this.world.func_72838_d((Entity)output);
                    this.shrinkAndUpdateItems(used);
                    ParticleMessageHelper.visualizeCrafting(this.world, "white", this.item.field_70165_t, this.item.field_70163_u, this.item.field_70161_v, 8);
                }
            }
        }
    }

    private void updateBurnItem(BurnItemRecipe recipe) {
        if (this.item.func_92059_d().func_190916_E() == 0) {
            this.item.func_70106_y();
            return;
        }
        int recipeNum = (int)Math.floor(this.item.func_92059_d().func_190916_E() / recipe.getInputAmount());
        int items = recipeNum * recipe.getOutputStack().func_190916_E();
        int stacks = 0;
        int remainder = 0;
        while (items != 0) {
            if (items >= 64) {
                ++stacks;
                items -= 64;
                continue;
            }
            remainder = items;
            items = 0;
        }
        for (int i = 0; i < stacks; ++i) {
            EntityItem newItem = new EntityItem(this.world, this.item.field_70165_t, this.item.field_70163_u, this.item.field_70161_v, recipe.getOutputStack().func_77946_l());
            newItem.func_92059_d().func_190920_e(64);
            newItem.field_70159_w = 0.0;
            newItem.field_70181_x = 0.0;
            newItem.field_70179_y = 0.0;
            newItem.func_174867_a(10);
            newItem.func_184224_h(true);
            this.world.func_72838_d((Entity)newItem);
        }
        EntityItem newItem = new EntityItem(this.world, this.item.field_70165_t, this.item.field_70163_u, this.item.field_70161_v, recipe.getOutputStack().func_77946_l());
        newItem.func_92059_d().func_190920_e(remainder);
        newItem.field_70159_w = 0.0;
        newItem.field_70181_x = 0.0;
        newItem.field_70179_y = 0.0;
        newItem.func_174867_a(10);
        newItem.func_184224_h(true);
        this.world.func_72838_d((Entity)newItem);
        this.shrinkAndUpdateItem(recipeNum * recipe.getInputAmount());
        ParticleMessageHelper.visualizeCrafting(this.world, "black", this.item.field_70165_t, this.item.field_70163_u, this.item.field_70161_v, 80);
        this.burnProgress = 0;
    }

    private void shrinkAndUpdateItem(int inputAmount) {
        ItemStack updatedItem = this.item.func_92059_d().func_77946_l();
        updatedItem.func_190918_g(inputAmount);
        this.item.func_92058_a(updatedItem);
    }

    private void shrinkAndUpdateItems(Map<EntityItem, Integer> items) {
        for (Map.Entry<EntityItem, Integer> entry : items.entrySet()) {
            ItemStack updatedItem = entry.getKey().func_92059_d().func_77946_l();
            updatedItem.func_190918_g(entry.getValue().intValue());
            entry.getKey().func_92058_a(updatedItem);
        }
    }

    private List<Integer> getListFromArray(int[] arr) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int index : arr) {
            list.add(index);
        }
        return list;
    }

    private int[] getArrayFromList(List<Integer> list) {
        int[] indexes = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            indexes[i] = list.get(i);
        }
        return indexes;
    }

    public static String getNbtKey() {
        return "inworldcrafting:crafting_item";
    }
}

