/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.network.serialization;

import com.infinityraider.infinitylib.InfinityLib;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ByteBufUtil {
    public static ByteBuf writeBoolean(ByteBuf buf, boolean data) {
        buf.writeBoolean(data);
        return buf;
    }

    public static boolean readBoolean(ByteBuf buf) {
        return buf.readBoolean();
    }

    public static ByteBuf writeByte(ByteBuf buf, byte data) {
        buf.writeByte((int)data);
        return buf;
    }

    public static byte readByte(ByteBuf buf) {
        return buf.readByte();
    }

    public static ByteBuf writeShort(ByteBuf buf, short data) {
        buf.writeShort((int)data);
        return buf;
    }

    public static short readShort(ByteBuf buf) {
        return buf.readShort();
    }

    public static ByteBuf writeInt(ByteBuf buf, int data) {
        buf.writeInt(data);
        return buf;
    }

    public static int readInt(ByteBuf buf) {
        return buf.readInt();
    }

    public static ByteBuf writeLong(ByteBuf buf, long data) {
        buf.writeLong(data);
        return buf;
    }

    public static long readLong(ByteBuf buf) {
        return buf.readLong();
    }

    public static ByteBuf writeFloat(ByteBuf buf, float data) {
        buf.writeFloat(data);
        return buf;
    }

    public static float readFloat(ByteBuf buf) {
        return buf.readFloat();
    }

    public static ByteBuf writeDouble(ByteBuf buf, double data) {
        buf.writeDouble(data);
        return buf;
    }

    public static double readDouble(ByteBuf buf) {
        return buf.readDouble();
    }

    public static ByteBuf writeChar(ByteBuf buf, char data) {
        buf.writeChar((int)data);
        return buf;
    }

    public static char readChar(ByteBuf buf) {
        return buf.readChar();
    }

    public static ByteBuf writeString(ByteBuf buf, String string) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
        return buf;
    }

    public static String readString(ByteBuf buf) {
        return ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static ByteBuf writeEntity(ByteBuf buf, Entity e) {
        if (e == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(e.func_145782_y());
            buf.writeInt(e.func_130014_f_().field_73011_w.getDimension());
        }
        return buf;
    }

    public static Entity readEntity(ByteBuf buf) {
        int id = buf.readInt();
        if (id < 0) {
            return null;
        }
        int dimension = buf.readInt();
        return InfinityLib.proxy.getEntityById(dimension, id);
    }

    public static ByteBuf writeTileEntity(ByteBuf buf, TileEntity tile) {
        ByteBufUtil.writeInt(buf, tile.func_145831_w().field_73011_w.getDimension());
        return ByteBufUtil.writeBlockPos(buf, tile.func_174877_v());
    }

    public static TileEntity readTileEntity(ByteBuf buf) {
        int dimension = ByteBufUtil.readInt(buf);
        BlockPos pos = ByteBufUtil.readBlockPos(buf);
        World world = InfinityLib.proxy.getWorldByDimensionId(dimension);
        return world == null ? null : world.func_175625_s(pos);
    }

    public static ByteBuf writeBlockPos(ByteBuf buf, BlockPos pos) {
        buf.writeInt(pos.func_177958_n());
        buf.writeInt(pos.func_177956_o());
        buf.writeInt(pos.func_177952_p());
        return buf;
    }

    public static BlockPos readBlockPos(ByteBuf buf) {
        return new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static ByteBuf writeBlock(ByteBuf buf, Block block) {
        String blockName = block == null ? "null" : ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
        buf.writeInt(blockName.length());
        buf.writeBytes(blockName.getBytes());
        return buf;
    }

    public static Block readBlock(ByteBuf buf) {
        int itemNameLength = buf.readInt();
        String itemName = new String(buf.readBytes(itemNameLength).array());
        return (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(itemName));
    }

    public static ByteBuf writeItem(ByteBuf buf, Item item) {
        String itemName = item == null ? "null" : ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString();
        buf.writeInt(itemName.length());
        buf.writeBytes(itemName.getBytes());
        return buf;
    }

    public static Item readItem(ByteBuf buf) {
        int itemNameLength = buf.readInt();
        String itemName = new String(buf.readBytes(itemNameLength).array());
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName));
    }

    public static ByteBuf writeItemStack(ByteBuf buf, ItemStack stack) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
        return buf;
    }

    public static ItemStack readItemStack(ByteBuf buf) {
        return ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public static ByteBuf writeNBT(ByteBuf buf, NBTTagCompound tag) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
        return buf;
    }

    public static NBTTagCompound readNBT(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static ByteBuf writeVec3d(ByteBuf buf, Vec3d data) {
        buf.writeDouble(data.field_72450_a);
        buf.writeDouble(data.field_72448_b);
        buf.writeDouble(data.field_72449_c);
        return buf;
    }

    public static Vec3d readVec3d(ByteBuf buf) {
        return new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static ByteBuf writeTextComponent(ByteBuf buf, ITextComponent component) {
        return ByteBufUtil.writeString(buf, ITextComponent.Serializer.func_150696_a((ITextComponent)component));
    }

    public static ITextComponent readTextComponent(ByteBuf buf) {
        return ITextComponent.Serializer.func_150699_a((String)ByteBufUtil.readString(buf));
    }
}

