/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.block;

import com.infinityraider.infinitylib.block.IInfinityBlock;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class BlockBase
extends Block
implements IInfinityBlock {
    private final String internalName;

    public BlockBase(String name, Material blockMaterial) {
        super(blockMaterial);
        this.internalName = name;
        this.setDefaultState();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    protected final BlockStateContainer func_180661_e() {
        InfinityProperty[] propertyArray = this.getPropertyArray();
        IProperty[] properties = new IProperty[propertyArray.length];
        for (int i = 0; i < properties.length; ++i) {
            properties[i] = propertyArray[i].getProperty();
        }
        IUnlistedProperty[] uprops = this.getUnlistedPropertyArray();
        if (uprops.length < 1) {
            return new BlockStateContainer((Block)this, properties);
        }
        return new ExtendedBlockState((Block)this, properties, uprops);
    }

    private void setDefaultState() {
        IBlockState state = this.field_176227_L.func_177621_b();
        for (InfinityProperty property : this.getPropertyArray()) {
            state = property.applyToBlockState(state);
        }
        this.func_180632_j(state);
    }

    protected abstract InfinityProperty[] getPropertyArray();

    protected IUnlistedProperty[] getUnlistedPropertyArray() {
        return new IUnlistedProperty[0];
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

