/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.transfernodes.FacingHelper;
import com.rwtema.extrautils2.transfernodes.GrocketPipeFilter;
import com.rwtema.extrautils2.transfernodes.IBuffer;
import com.rwtema.extrautils2.transfernodes.IPipe;
import com.rwtema.extrautils2.transfernodes.TransferHelper;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.INBTSerializable;

public class Ping
implements INBTSerializable<NBTTagIntArray> {
    private IBlockAccess world;
    private IBuffer buffer;
    private BlockPos pos = null;
    private EnumFacing direction;
    private BlockPos home;
    private EnumFacing homeDirection;

    public boolean needsInit() {
        return this.world == null || this.home == null || this.homeDirection == null || this.buffer == null;
    }

    public void init(IBlockAccess world, BlockPos home, EnumFacing homeDirection, IBuffer buffer) {
        this.world = world;
        this.home = home;
        this.homeDirection = homeDirection;
        this.buffer = buffer;
    }

    public BlockPos getPos() {
        if (this.pos == null) {
            this.resetPosition();
        }
        return this.pos;
    }

    public EnumFacing getDirection() {
        if (this.direction == null) {
            this.resetPosition();
        }
        return this.direction;
    }

    public void resetPosition() {
        this.pos = this.getDefaultPos();
        this.direction = this.getDefaultSide();
    }

    protected EnumFacing getDefaultSide() {
        return this.homeDirection;
    }

    protected BlockPos getDefaultPos() {
        return this.home;
    }

    public void advanceSearch(IPipe pipe) {
        if (pipe == null) {
            this.resetPosition();
            return;
        }
        boolean mayHavePriorities = pipe.mayHavePriorities();
        GrocketPipeFilter.Priority found = null;
        BlockPos newPos = null;
        EnumFacing newDirection = null;
        for (EnumFacing facing : FacingHelper.getRandomFaceOrder()) {
            BlockPos offset;
            if (facing == this.direction.func_176734_d() || !pipe.canOutput(this.world, this.pos, facing, this.buffer) || !TransferHelper.isInputtingPipe(this.world, offset = this.pos.func_177972_a(facing), facing.func_176734_d())) continue;
            if (mayHavePriorities) {
                GrocketPipeFilter.Priority priority = pipe.getPriority(this.world, this.pos, facing);
                if (found != null && priority.ordinal() >= found.ordinal()) continue;
                found = priority;
            }
            if (!mayHavePriorities || found == GrocketPipeFilter.Priority.HIGH) {
                this.pos = offset;
                this.direction = facing;
                return;
            }
            newPos = offset;
            newDirection = facing;
        }
        if (found != null) {
            this.pos = newPos;
            this.direction = newDirection;
            return;
        }
        this.resetPosition();
    }

    public NBTTagIntArray serializeNBT() {
        if (this.pos == null || this.direction == null) {
            return new NBTTagIntArray(new int[]{0, 0, 0, 0});
        }
        return new NBTTagIntArray(new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), this.direction.ordinal()});
    }

    public void deserializeNBT(NBTTagIntArray nbt) {
        int[] ints = nbt.func_150302_c();
        if (ints.length != 4) {
            return;
        }
        int i = ints[3];
        if (i < 0 || i >= 6) {
            return;
        }
        this.direction = EnumFacing.values()[i];
        this.pos = new BlockPos(ints[0], ints[1], ints[2]);
    }
}

