/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power;

import com.rwtema.extrautils2.backend.ClientRunnable;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketBase;
import com.rwtema.extrautils2.power.ClientPower;
import com.rwtema.extrautils2.power.Freq;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.PowerManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@NetworkHandler.XUPacket
public class PacketPowerInfo
extends XUPacketBase {
    BlockPos pos;
    float energy = -1.0f;
    float efficiency = -1.0f;
    private EntityPlayer player;

    public PacketPowerInfo() {
    }

    public PacketPowerInfo(BlockPos pos) {
        this.pos = pos;
    }

    public PacketPowerInfo(float energy, float efficiency, BlockPos pos) {
        this.energy = energy;
        this.efficiency = efficiency;
        this.pos = pos;
    }

    @Override
    public void writeData() throws Exception {
        this.writeBlockPos(this.pos);
        this.writeFloat(this.energy);
        this.writeFloat(this.efficiency);
    }

    @Override
    public void readData(EntityPlayer player) {
        this.player = player;
        this.pos = this.readBlockPos();
        this.energy = this.readFloat();
        this.efficiency = this.readFloat();
    }

    @Override
    public Runnable doStuffServer() {
        return new Runnable(){

            @Override
            public void run() {
                float v2;
                float v;
                IPower power;
                int frequency;
                if (!(PacketPowerInfo.this.player instanceof EntityPlayerMP)) {
                    return;
                }
                TileEntity tile = ((PacketPowerInfo)PacketPowerInfo.this).player.field_70170_p.func_175625_s(PacketPowerInfo.this.pos);
                if (!(tile instanceof IPower)) {
                    return;
                }
                int freq = Freq.getBasePlayerFreq((EntityPlayerMP)PacketPowerInfo.this.player);
                if (PowerManager.areFreqOnSameGrid(freq, frequency = (power = (IPower)tile).frequency())) {
                    v = PowerManager.getCurrentPower(power);
                    v2 = PowerManager.getEfficiency(power);
                } else {
                    v = Float.NaN;
                    v2 = 1.0f;
                }
                if (v == PacketPowerInfo.this.energy && v2 == PacketPowerInfo.this.efficiency) {
                    return;
                }
                NetworkHandler.sendPacketToPlayer(new PacketPowerInfo(v, v2, PacketPowerInfo.this.pos), PacketPowerInfo.this.player);
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Runnable doStuffClient() {
        return new ClientRunnable(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void run() {
                if (ClientPower.currentPosition == PacketPowerInfo.this.pos || ClientPower.currentPosition != null && ClientPower.currentPosition.equals((Object)PacketPowerInfo.this.pos)) {
                    ClientPower.currentPositionEnergy = PacketPowerInfo.this.energy;
                    ClientPower.currentPositionEfficiency = PacketPowerInfo.this.efficiency;
                }
            }
        };
    }

    @Override
    public boolean isValidSenderSide(Side properSenderSide) {
        return true;
    }
}

