/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketClientToServer;
import gnu.trove.map.hash.TIntObjectHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class GuiHandler
implements IGuiHandler {
    private static final TIntObjectHashMap<IDynamicHandler> customDynamicGuiMap = new TIntObjectHashMap();

    public static int register(String name, IDynamicHandler handler) {
        int id = name.hashCode() | Integer.MIN_VALUE;
        if (customDynamicGuiMap.containsKey(id)) {
            throw new RuntimeException("Duplicate id: " + id + " - " + customDynamicGuiMap.get(id) + " - (adding " + handler + ")");
        }
        customDynamicGuiMap.put(id, (Object)handler);
        return id;
    }

    public Object getServerGuiElement(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        if (customDynamicGuiMap.containsKey(ID2)) {
            return ((IDynamicHandler)customDynamicGuiMap.get(ID2)).getDynamicContainer(ID2, player, world, x, y, z);
        }
        if (ID2 == -1) {
            ItemStack heldItem = player.func_184614_ca();
            if (StackHelper.isNull(heldItem)) {
                return null;
            }
            Item item = heldItem.func_77973_b();
            if (item instanceof IGuiHandler) {
                return ((IGuiHandler)item).getServerGuiElement(ID2, player, world, x, y, z);
            }
            if (item instanceof IDynamicHandler) {
                return ((IDynamicHandler)item).getDynamicContainer(ID2, player, world, x, y, z);
            }
        } else {
            BlockPos pos = new BlockPos(x, y, z);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof IGuiHandler) {
                return ((IGuiHandler)tileEntity).getServerGuiElement(ID2, player, world, x, y, z);
            }
            if (tileEntity instanceof IDynamicHandler) {
                return ((IDynamicHandler)tileEntity).getDynamicContainer(ID2, player, world, x, y, z);
            }
            IBlockState state = world.func_180495_p(pos);
            if (state instanceof IGuiHandler) {
                return ((IGuiHandler)state).getServerGuiElement(ID2, player, world, x, y, z);
            }
            if (state instanceof IDynamicHandler) {
                return ((IDynamicHandler)state).getDynamicContainer(ID2, player, world, x, y, z);
            }
            Block block = state.func_177230_c();
            if (block instanceof IGuiHandler) {
                return ((IGuiHandler)block).getServerGuiElement(ID2, player, world, x, y, z);
            }
            if (block instanceof IDynamicHandler) {
                return ((IDynamicHandler)block).getDynamicContainer(ID2, player, world, x, y, z);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        if (customDynamicGuiMap.containsKey(ID2)) {
            return new DynamicGui(((IDynamicHandler)customDynamicGuiMap.get(ID2)).getDynamicContainer(ID2, player, world, x, y, z));
        }
        if (ID2 == -1) {
            ItemStack heldItem = player.func_184614_ca();
            if (StackHelper.isNull(heldItem)) {
                return null;
            }
            Item item = heldItem.func_77973_b();
            if (item instanceof IGuiHandler) {
                return ((IGuiHandler)item).getClientGuiElement(ID2, player, world, x, y, z);
            }
            if (item instanceof IDynamicHandler) {
                return new DynamicGui(((IDynamicHandler)item).getDynamicContainer(ID2, player, world, x, y, z));
            }
        } else {
            BlockPos pos = new BlockPos(x, y, z);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof IGuiHandler) {
                return ((IGuiHandler)tileEntity).getClientGuiElement(ID2, player, world, x, y, z);
            }
            if (tileEntity instanceof IDynamicHandler) {
                return new DynamicGui(((IDynamicHandler)tileEntity).getDynamicContainer(ID2, player, world, x, y, z));
            }
            IBlockState state = world.func_180495_p(pos);
            if (state instanceof IGuiHandler) {
                return ((IGuiHandler)state).getClientGuiElement(ID2, player, world, x, y, z);
            }
            if (state instanceof IDynamicHandler) {
                return new DynamicGui(((IDynamicHandler)state).getDynamicContainer(ID2, player, world, x, y, z));
            }
            Block block = state.func_177230_c();
            if (block instanceof IGuiHandler) {
                return ((IGuiHandler)block).getClientGuiElement(ID2, player, world, x, y, z);
            }
            if (block instanceof IDynamicHandler) {
                return new DynamicGui(((IDynamicHandler)block).getDynamicContainer(ID2, player, world, x, y, z));
            }
        }
        return null;
    }

    @NetworkHandler.XUPacket
    public static class PacketOpenGui
    extends XUPacketClientToServer {
        int id;
        private EntityPlayer player;

        public PacketOpenGui() {
        }

        public PacketOpenGui(int id) {
            this.id = id;
        }

        @Override
        public void writeData() throws Exception {
            this.writeInt(this.id);
        }

        @Override
        public void readData(EntityPlayer player) {
            this.id = this.readInt();
            this.player = player;
        }

        @Override
        public Runnable doStuffServer() {
            return new Runnable(){

                @Override
                public void run() {
                    player.openGui((Object)ExtraUtils2.instance, id, ((PacketOpenGui)this).player.field_70170_p, 0, 0, 0);
                }
            };
        }
    }
}

