/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.extracpus;

import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.components.IBlockRegistrationComponent;
import appeng.bootstrap.components.IInitComponent;
import appeng.bootstrap.components.IItemRegistrationComponent;
import appeng.bootstrap.components.IModelRegistrationComponent;
import appeng.bootstrap.components.IPreInitComponent;
import appeng.core.features.AEFeature;
import dev.rlnt.extracpus.aehacks.ModelLoaderWrapper;
import dev.rlnt.extracpus.block.CraftingStorageTile;
import dev.rlnt.extracpus.setup.ModBlocks;
import dev.rlnt.extracpus.setup.ModTab;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="extracpus", useMetadata=true)
@Mod.EventBusSubscriber
public class ExtraCPUs {
    public static final CreativeTabs MOD_TAB = new ModTab();
    public static final FeatureFactory FF = new FeatureFactory().features(new AEFeature[]{AEFeature.CRAFTING_CPU});
    public static final boolean EXISTING_DEPENDENCY = Loader.isModLoaded((String)"extracells") || Loader.isModLoaded((String)"aeadditions");

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        Logger logger = event.getModLog();
        if (!EXISTING_DEPENDENCY) {
            logger.warn("There is no dependency mod loaded for ExtraCPUs! It will not add any features.");
            return;
        }
        GameRegistry.registerTileEntity(CraftingStorageTile.class, (ResourceLocation)new ResourceLocation("extracpus", "TileCraftingStorage"));
        ModBlocks.init();
        FF.getBootstrapComponents(IPreInitComponent.class).forEachRemaining(component -> component.preInitialize(event.getSide()));
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        if (!EXISTING_DEPENDENCY) {
            return;
        }
        FF.getBootstrapComponents(IInitComponent.class).forEachRemaining(component -> component.initialize(event.getSide()));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        if (!EXISTING_DEPENDENCY) {
            return;
        }
        IForgeRegistry registry = event.getRegistry();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        FF.getBootstrapComponents(IBlockRegistrationComponent.class).forEachRemaining(block -> block.blockRegistration(side, registry));
    }

    @SubscribeEvent
    public static void registerBlockItems(RegistryEvent.Register<Item> event) {
        if (!EXISTING_DEPENDENCY) {
            return;
        }
        IForgeRegistry registry = event.getRegistry();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        FF.getBootstrapComponents(IItemRegistrationComponent.class).forEachRemaining(blockItem -> blockItem.itemRegistration(side, registry));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        if (!EXISTING_DEPENDENCY) {
            return;
        }
        ModelLoaderWrapper registry = new ModelLoaderWrapper();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        FF.getBootstrapComponents(IModelRegistrationComponent.class).forEachRemaining(model -> model.modelRegistration(side, registry));
    }
}

