/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.EnderUtilities;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldProviderSurface;

public class WorldUtils {
    private static final IntOpenHashSet CUSTOM_END_DIMENSIONS = new IntOpenHashSet();

    public static void setCustomEndDimensions(String[] list) {
        CUSTOM_END_DIMENSIONS.clear();
        for (String str : list) {
            try {
                int dim = Integer.parseInt(str);
                CUSTOM_END_DIMENSIONS.add(dim);
            }
            catch (NumberFormatException e) {
                EnderUtilities.logger.warn("Invalid string '{}' for custom End dimension IDs", (Object)str, (Object)e);
            }
        }
    }

    public static boolean isEndDimension(World world) {
        return world.field_73011_w instanceof WorldProviderEnd || world.field_73011_w.func_186058_p().func_186068_a() == 1 || CUSTOM_END_DIMENSIONS.contains(world.field_73011_w.getDimension());
    }

    public static boolean isNetherDimension(World world) {
        return world.field_73011_w.func_177495_o() || world.field_73011_w instanceof WorldProviderHell || world.field_73011_w.func_186058_p().func_186068_a() == -1;
    }

    public static boolean isOverworldDimension(World world) {
        return world.field_73011_w instanceof WorldProviderSurface || world.field_73011_w.func_186058_p().func_186068_a() == 0;
    }
}

