/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import com.mojang.authlib.GameProfile;
import fi.dy.masa.enderutilities.gui.client.GuiDrawbridge;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerDrawbridge;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperSelective;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.TileUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;

public class TileEntityDrawbridge
extends TileEntityEnderUtilitiesInventory {
    public static final int MAX_LENGTH_NORMAL = 64;
    public static final int MAX_LENGTH_ADVANCED = 32;
    private ItemStackHandlerDrawbridge itemHandlerDrawbridge;
    private boolean advanced;
    private boolean redstoneState;
    private State state = State.IDLE;
    private RedstoneMode redstoneMode = RedstoneMode.EXTEND;
    private int position;
    private int delay = 4;
    private int maxLength = 1;
    private int numPlaced;
    private int failedPlacements;
    private int numTaken;
    private BlockInfo[] blockInfoTaken = new BlockInfo[64];
    private IBlockState[] blockStatesPlaced = new IBlockState[64];
    private FakePlayer fakePlayer;

    public TileEntityDrawbridge() {
        super("draw_bridge");
        this.initStorage();
    }

    private void initStorage() {
        this.itemHandlerDrawbridge = new ItemStackHandlerDrawbridge(0, 32, 1, true, "Items", this);
        this.itemHandlerBase = this.itemHandlerDrawbridge;
        this.itemHandlerExternal = new ItemHandlerWrapperDrawbridge(this.itemHandlerDrawbridge);
    }

    public ItemStackHandlerDrawbridge getInventoryDrawbridge() {
        return this.itemHandlerDrawbridge;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setIsAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public int getSlotCount() {
        return this.isAdvanced() ? this.maxLength : 1;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int length) {
        this.maxLength = MathHelper.func_76125_a((int)length, (int)1, (int)(this.isAdvanced() ? 32 : 64));
        if (!this.isAdvanced()) {
            this.setStackLimit(length);
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelayFromByte(byte delay) {
        this.setDelay(delay & 0xFF);
    }

    public void setDelay(int delay) {
        this.delay = MathHelper.func_76125_a((int)delay, (int)1, (int)255);
    }

    public void setRedstoneMode(int id) {
        id = MathHelper.func_76125_a((int)id, (int)0, (int)(RedstoneMode.values().length - 1));
        this.redstoneMode = RedstoneMode.fromId(id);
    }

    public int getRedstoneModeIntValue() {
        return this.redstoneMode.getId();
    }

    public void setStackLimit(int limit) {
        this.getBaseItemHandler().setStackLimit(MathHelper.func_76125_a((int)limit, (int)1, (int)64));
    }

    @Override
    public void setPlacementProperties(World world, BlockPos pos, ItemStack stack, NBTTagCompound tag) {
        if (tag.func_150297_b("drawbridge.delay", 1)) {
            this.setDelayFromByte(tag.func_74771_c("drawbridge.delay"));
        }
        if (tag.func_150297_b("drawbridge.length", 1)) {
            this.setMaxLength(tag.func_74771_c("drawbridge.length"));
        }
        if (tag.func_150297_b("drawbridge.redstone_mode", 1)) {
            this.setRedstoneMode(tag.func_74771_c("drawbridge.redstone_mode"));
        }
        this.func_70296_d();
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        this.setIsAdvanced(nbt.func_74767_n("Advanced"));
        this.redstoneState = nbt.func_74767_n("Powered");
        this.position = nbt.func_74771_c("Position");
        this.setDelayFromByte(nbt.func_74771_c("Delay"));
        this.setMaxLength(nbt.func_74771_c("Length"));
        this.state = State.fromId(nbt.func_74771_c("State"));
        this.setRedstoneMode(nbt.func_74771_c("RedstoneMode"));
        this.numPlaced = nbt.func_74771_c("NumPlaced");
        this.failedPlacements = nbt.func_74771_c("Failed");
        this.numTaken = nbt.func_74771_c("NumTaken");
        this.readBlockInfoFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74757_a("Advanced", this.isAdvanced());
        nbt.func_74757_a("Powered", this.redstoneState);
        nbt.func_74774_a("Position", (byte)this.position);
        nbt.func_74774_a("Delay", (byte)this.delay);
        nbt.func_74774_a("Length", (byte)this.maxLength);
        nbt.func_74774_a("State", (byte)this.state.getId());
        nbt.func_74774_a("RedstoneMode", (byte)this.redstoneMode.getId());
        nbt.func_74774_a("NumPlaced", (byte)this.numPlaced);
        nbt.func_74774_a("Failed", (byte)this.failedPlacements);
        nbt.func_74774_a("NumTaken", (byte)this.numTaken);
        this.writeBlockInfoToNBT(nbt);
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74774_a("len", (byte)this.maxLength);
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.setMaxLength(tag.func_74771_c("len"));
    }

    private void writeBlockInfoToNBT(NBTTagCompound nbt) {
        int i;
        NBTTagList listTaken = new NBTTagList();
        NBTTagList listPlaced = new NBTTagList();
        int length = Math.min(this.maxLength, this.blockInfoTaken.length);
        for (i = 0; i < length; ++i) {
            BlockInfo info = this.blockInfoTaken[i];
            if (info == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            NBTUtils.writeBlockStateToTag(info.getState(), tag);
            if (info.getTileEntityNBT() != null) {
                tag.func_74782_a("nbt", (NBTBase)info.getTileEntityNBT());
            }
            tag.func_74774_a("pos", (byte)i);
            listTaken.func_74742_a((NBTBase)tag);
        }
        length = Math.min(this.maxLength, this.blockStatesPlaced.length);
        for (i = 0; i < length; ++i) {
            if (this.blockStatesPlaced[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            NBTUtils.writeBlockStateToTag(this.blockStatesPlaced[i], tag);
            tag.func_74774_a("pos", (byte)i);
            listPlaced.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Blocks", (NBTBase)listTaken);
        nbt.func_74782_a("Placed", (NBTBase)listPlaced);
    }

    private void readBlockInfoFromNBT(NBTTagCompound nbt) {
        byte pos;
        IBlockState state;
        NBTTagCompound tag;
        int i;
        int length;
        int count;
        NBTTagList list;
        if (nbt.func_150297_b("Blocks", 9)) {
            list = nbt.func_150295_c("Blocks", 10);
            count = list.func_74745_c();
            length = Math.min(this.maxLength, this.blockInfoTaken.length);
            for (i = 0; i < count; ++i) {
                tag = list.func_150305_b(i);
                state = NBTUtils.readBlockStateFromTag(tag);
                pos = tag.func_74771_c("pos");
                if (pos < 0 || pos >= length || state == null) continue;
                NBTTagCompound teTag = null;
                if (tag.func_150297_b("nbt", 10)) {
                    teTag = tag.func_74775_l("nbt");
                }
                this.blockInfoTaken[pos] = new BlockInfo(state, teTag);
            }
        }
        if (nbt.func_150297_b("Placed", 9)) {
            list = nbt.func_150295_c("Placed", 10);
            count = list.func_74745_c();
            length = Math.min(this.maxLength, this.blockStatesPlaced.length);
            for (i = 0; i < count; ++i) {
                tag = list.func_150305_b(i);
                state = NBTUtils.readBlockStateFromTag(tag);
                pos = tag.func_74771_c("pos");
                if (pos < 0 || pos >= length || state == null) continue;
                this.blockStatesPlaced[pos] = state;
            }
        }
    }

    @Nullable
    private IBlockState getPlacementStateForPosition(int position, World world, BlockPos pos, FakePlayer player, ItemStack stack) {
        ItemBlock itemBlock;
        Block block;
        if (this.blockInfoTaken[position] != null) {
            return this.blockInfoTaken[position].getState();
        }
        if ((this.isAdvanced() || this.numTaken == 0) && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock && (block = (itemBlock = (ItemBlock)stack.func_77973_b()).func_179223_d()) != null && block != Blocks.field_150350_a) {
            int meta = itemBlock.func_77647_b(stack.func_77960_j());
            player.field_70177_z = this.getFacing().func_185119_l();
            return block.getStateForPlacement(world, pos, EnumFacing.UP, 0.5f, 1.0f, 0.5f, meta, (EntityLivingBase)player, EnumHand.MAIN_HAND);
        }
        return null;
    }

    @Nullable
    private NBTTagCompound getPlacementTileNBT(int position, ItemStack stack) {
        if (this.blockInfoTaken[position] != null) {
            return this.blockInfoTaken[position].getTileEntityNBT();
        }
        if (!stack.func_190926_b() && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("BlockEntityTag", 10)) {
            return stack.func_77978_p().func_74775_l("BlockEntityTag");
        }
        return null;
    }

    private boolean extendOneBlock(int position, FakePlayer player, boolean playPistonSoundInsteadOfPlaceSound) {
        ItemStack stack;
        BlockPos pos;
        int invPosition = this.isAdvanced() ? position : 0;
        World world = this.func_145831_w();
        IBlockState placementState = this.getPlacementStateForPosition(position, world, pos = this.func_174877_v().func_177967_a(this.getFacing(), position + 1), player, stack = this.itemHandlerDrawbridge.getStackInSlot(invPosition));
        if (placementState != null && !stack.func_190926_b() && world.func_175668_a(pos, !world.field_72995_K) && world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && world.func_190527_a(placementState.func_177230_c(), pos, true, EnumFacing.UP, null) && (playPistonSoundInsteadOfPlaceSound && world.func_175656_a(pos, placementState) || !playPistonSoundInsteadOfPlaceSound && BlockUtils.setBlockStateWithPlaceSound(world, pos, placementState, 3))) {
            stack = this.itemHandlerDrawbridge.extractItem(invPosition, 1, false);
            this.blockStatesPlaced[position] = placementState;
            ++this.numPlaced;
            NBTTagCompound nbt = this.getPlacementTileNBT(position, stack);
            if (nbt != null && placementState.func_177230_c().hasTileEntity(placementState)) {
                TileUtils.createAndAddTileEntity(world, pos, nbt);
            }
            if (playPistonSoundInsteadOfPlaceSound) {
                world.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, 0.8f);
            }
            return true;
        }
        if (!stack.func_190926_b()) {
            ++this.failedPlacements;
        }
        return false;
    }

    private boolean retractOneBlock(int position, FakePlayer player, boolean takeNonPlaced, boolean playPistonSound) {
        ItemStack stack;
        BlockPos pos;
        World world = this.func_145831_w();
        if (!world.func_175668_a(pos = this.func_174877_v().func_177967_a(this.getFacing(), position + 1), !world.field_72995_K)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if ((takeNonPlaced || state == this.blockStatesPlaced[position]) && !state.func_177230_c().isAir(state, (IBlockAccess)world, pos) && state.func_185887_b(world, pos) >= 0.0f && !(stack = BlockUtils.getPickBlockItemStack(world, pos, (EntityPlayer)player, EnumFacing.UP)).func_190926_b()) {
            TileEntity te;
            int invPosition;
            NBTTagCompound nbt = null;
            int n = invPosition = this.isAdvanced() ? position : 0;
            if (state.func_177230_c().hasTileEntity(state) && (te = world.func_175625_s(pos)) != null) {
                TileUtils.storeTileEntityInStack(stack, te, false);
                nbt = te.func_189515_b(new NBTTagCompound());
                NBTUtils.removePositionFromTileEntityNBT(nbt);
            }
            if (this.itemHandlerDrawbridge.insertItem(invPosition, stack, false).func_190926_b()) {
                this.blockInfoTaken[position] = new BlockInfo(state, nbt);
                ++this.numTaken;
                if (playPistonSound) {
                    world.func_184133_a(null, pos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, 0.7f);
                } else {
                    BlockUtils.playBlockBreakSound(world, pos);
                }
                BlockUtils.setBlockToAirWithoutSpillingContents(world, pos);
                this.blockStatesPlaced[position] = null;
                return true;
            }
        }
        return false;
    }

    private boolean takeAllBlocksFromWorld() {
        if (this.state == State.IDLE) {
            for (int offset = 0; offset < this.maxLength; ++offset) {
                this.retractOneBlock(offset, this.getPlayer(), true, false);
            }
            return true;
        }
        return false;
    }

    private void clearBlockInfoFor(int invPosition) {
        if (this.isAdvanced()) {
            this.blockInfoTaken[invPosition] = null;
        } else {
            for (int i = 0; i < this.blockInfoTaken.length; ++i) {
                this.blockInfoTaken[i] = null;
            }
            this.numTaken = 0;
        }
    }

    @Nonnull
    private FakePlayer getPlayer() {
        if (this.fakePlayer == null) {
            int dim = this.func_145831_w().field_73011_w.getDimension();
            this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.func_145831_w()), (GameProfile)new GameProfile(new UUID(dim, dim), "enderutilities:drawbridge"));
        }
        return this.fakePlayer;
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block blockIn) {
        boolean powered = false;
        for (EnumFacing facing : EnumFacing.values()) {
            if (facing == this.getFacing() || !worldIn.func_175709_b(pos.func_177972_a(facing), facing)) continue;
            powered = true;
            break;
        }
        if (powered != this.redstoneState) {
            switch (this.redstoneMode) {
                case EXTEND: {
                    this.state = powered ? State.EXTEND : State.RETRACT;
                    break;
                }
                case RETRACT: {
                    this.state = powered ? State.RETRACT : State.EXTEND;
                    break;
                }
                case TOGGLE: {
                    if (!powered) break;
                    this.state = this.state == State.EXTEND ? State.RETRACT : (this.state == State.RETRACT ? State.EXTEND : (this.position == this.maxLength - 1 && (this.maxLength > 1 || this.maxLength == 1 && (this.numPlaced > 0 || this.failedPlacements > 0)) ? State.RETRACT : State.EXTEND));
                }
            }
            this.redstoneState = powered;
            this.scheduleBlockUpdate(this.delay, true);
        }
    }

    @Override
    public void onScheduledBlockUpdate(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.state == State.EXTEND) {
            while (this.position < this.maxLength) {
                boolean result = this.extendOneBlock(this.position, this.getPlayer(), true);
                ++this.position;
                if (!result) continue;
                break;
            }
            if (this.position >= this.maxLength) {
                this.position = this.maxLength - 1;
                this.numTaken = 0;
                this.state = State.IDLE;
            } else {
                this.scheduleBlockUpdate(this.delay, false);
            }
        } else if (this.state == State.RETRACT) {
            boolean takeNonPlaced;
            boolean bl = takeNonPlaced = this.numPlaced == 0 && this.failedPlacements == 0;
            while (this.position >= 0) {
                boolean result = this.retractOneBlock(this.position, this.getPlayer(), takeNonPlaced, true);
                --this.position;
                if (!result) continue;
                break;
            }
            if (this.position < 0) {
                this.position = 0;
                this.numPlaced = 0;
                this.failedPlacements = 0;
                this.state = State.IDLE;
            } else {
                this.scheduleBlockUpdate(this.delay, false);
            }
        }
    }

    private void changeInventorySize(int changeAmount) {
        int newSize = MathHelper.func_76125_a((int)(this.getSlotCount() + changeAmount), (int)1, (int)32);
        if (changeAmount < 0) {
            int changeFinal = 0;
            for (int slot = this.getSlotCount() - 1; slot >= newSize && slot >= 1 && this.itemHandlerDrawbridge.getStackInSlot(slot).func_190926_b(); --slot) {
                --changeFinal;
            }
            newSize = MathHelper.func_76125_a((int)(this.getSlotCount() + changeFinal), (int)1, (int)32);
        }
        if (newSize >= 1 && newSize <= 32) {
            this.setMaxLength(newSize);
        }
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        switch (action) {
            case 0: {
                this.takeAllBlocksFromWorld();
                break;
            }
            case 1: {
                this.setDelay(this.delay + element);
                break;
            }
            case 2: {
                if (this.state != State.IDLE) break;
                int oldMaxLength = this.maxLength;
                if (this.isAdvanced()) {
                    this.changeInventorySize(element);
                } else {
                    this.setMaxLength(this.maxLength + element);
                }
                if (this.position < oldMaxLength) break;
                this.position = this.maxLength - 1;
                break;
            }
            case 3: {
                if (this.state != State.IDLE) break;
                this.setRedstoneMode(this.redstoneMode.getId() + (element > 0 ? 1 : -1));
            }
        }
        this.func_70296_d();
    }

    @Override
    protected boolean hasCamouflageAbility() {
        return true;
    }

    @Override
    public ContainerDrawbridge getContainer(EntityPlayer player) {
        return new ContainerDrawbridge(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiDrawbridge(this.getContainer(player), this);
    }

    private static enum RedstoneMode {
        EXTEND(0),
        RETRACT(1),
        TOGGLE(2);

        private final int id;

        private RedstoneMode(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static RedstoneMode fromId(int id) {
            return RedstoneMode.values()[id % RedstoneMode.values().length];
        }
    }

    private static enum State {
        IDLE(0),
        EXTEND(1),
        RETRACT(2);

        private final int id;

        private State(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static State fromId(int id) {
            return State.values()[id % State.values().length];
        }
    }

    private static class BlockInfo {
        private final IBlockState blockState;
        private final NBTTagCompound tileEntityData;

        BlockInfo(IBlockState state, NBTTagCompound tileEntityNBT) {
            this.blockState = state;
            this.tileEntityData = tileEntityNBT;
        }

        public IBlockState getState() {
            return this.blockState;
        }

        @Nullable
        public NBTTagCompound getTileEntityNBT() {
            return this.tileEntityData;
        }
    }

    private class ItemHandlerWrapperDrawbridge
    extends ItemHandlerWrapperSelective {
        public ItemHandlerWrapperDrawbridge(IItemHandler baseHandler) {
            super(baseHandler);
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock;
        }
    }

    private class ItemStackHandlerDrawbridge
    extends ItemStackHandlerTileEntity {
        public ItemStackHandlerDrawbridge(int inventoryId, int invSize, int stackLimit, boolean allowCustomStackSizes, String tagName, TileEntityEnderUtilitiesInventory te) {
            super(inventoryId, invSize, stackLimit, allowCustomStackSizes, tagName, te);
        }

        @Override
        public int getSlots() {
            return TileEntityDrawbridge.this.getSlotCount();
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = super.extractItem(slot, amount, simulate);
            if (!simulate && this.getStackInSlot(slot).func_190926_b()) {
                TileEntityDrawbridge.this.clearBlockInfoFor(slot);
            }
            return stack;
        }
    }
}

