/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.gui.client.GuiASU;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerLockable;
import fi.dy.masa.enderutilities.inventory.container.ContainerASU;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperSelective;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TileEntityASU
extends TileEntityEnderUtilitiesInventory {
    public static final int MAX_INV_SIZE = 27;
    public static final int MAX_STACK_SIZE = 1024;
    private ItemStackHandlerLockable itemHandlerLockable;
    private int inventorySize = 1;

    public TileEntityASU() {
        super("asu");
        this.initStorage();
    }

    private void initStorage() {
        this.itemHandlerLockable = new ItemStackHandlerASU(0, 27, 1, true, "Items", this);
        this.itemHandlerBase = this.itemHandlerLockable;
        this.itemHandlerExternal = new ItemHandlerWrapperSelective(this.itemHandlerLockable);
    }

    public ItemStackHandlerLockable getInventoryASU() {
        return this.itemHandlerLockable;
    }

    public int getInvSize() {
        return this.inventorySize;
    }

    public void setInvSize(int size) {
        this.inventorySize = MathHelper.func_76125_a((int)size, (int)1, (int)27);
        this.func_70296_d();
    }

    public void setStackLimit(int limit) {
        this.getBaseItemHandler().setStackLimit(MathHelper.func_76125_a((int)limit, (int)0, (int)1024));
        this.func_70296_d();
    }

    @Override
    public void setPlacementProperties(World world, BlockPos pos, ItemStack stack, NBTTagCompound tag) {
        if (tag.func_150297_b("asu.stack_limit", 3)) {
            this.setStackLimit(tag.func_74762_e("asu.stack_limit"));
        }
        if (tag.func_150297_b("asu.slots", 1)) {
            this.setInvSize(tag.func_74771_c("asu.slots"));
        }
        this.func_70296_d();
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.setInvSize(nbt.func_74771_c("Tier"));
        this.setStackLimit(nbt.func_74762_e("StackLimit"));
        super.readFromNBTCustom(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("Tier", (byte)this.inventorySize);
        nbt.func_74768_a("StackLimit", this.getBaseItemHandler().getInventoryStackLimit());
        super.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74774_a("tier", (byte)this.inventorySize);
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        this.setInvSize(tag.func_74771_c("tier"));
        super.handleUpdateTag(tag);
    }

    private void changeInventorySize(int changeAmount) {
        int newSize = MathHelper.func_76125_a((int)(this.getInvSize() + changeAmount), (int)1, (int)27);
        if (changeAmount < 0) {
            int changeFinal = 0;
            for (int slot = this.getInvSize() - 1; slot >= newSize && slot >= 1 && this.itemHandlerLockable.getStackInSlot(slot).func_190926_b(); --slot) {
                --changeFinal;
            }
            newSize = MathHelper.func_76125_a((int)(this.getInvSize() + changeFinal), (int)1, (int)27);
        }
        if (newSize >= 1 && newSize <= 27) {
            this.setInvSize(newSize);
            this.notifyBlockUpdate(this.func_174877_v());
        }
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 0) {
            this.changeInventorySize(element);
        } else if (action == 1) {
            this.setStackLimit(this.getBaseItemHandler().getInventoryStackLimit() + element);
        }
    }

    @Override
    public ContainerASU getContainer(EntityPlayer player) {
        return new ContainerASU(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiASU(this.getContainer(player), this);
    }

    private class ItemStackHandlerASU
    extends ItemStackHandlerLockable {
        public ItemStackHandlerASU(int inventoryId, int invSize, int stackLimit, boolean allowCustomStackSizes, String tagName, TileEntityEnderUtilitiesInventory te) {
            super(inventoryId, invSize, stackLimit, allowCustomStackSizes, tagName, te);
        }

        @Override
        public int getSlots() {
            return TileEntityASU.this.getInvSize();
        }
    }
}

