/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.proxy;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.entity.EntityChair;
import fi.dy.masa.enderutilities.entity.EntityEnderArrow;
import fi.dy.masa.enderutilities.entity.EntityEnderPearlReusable;
import fi.dy.masa.enderutilities.entity.EntityEndermanFighter;
import fi.dy.masa.enderutilities.entity.EntityFallingBlockEU;
import fi.dy.masa.enderutilities.event.AnvilUpdateEventHandler;
import fi.dy.masa.enderutilities.event.BlockEventHandler;
import fi.dy.masa.enderutilities.event.EntityEventHandler;
import fi.dy.masa.enderutilities.event.ItemPickupEventHandler;
import fi.dy.masa.enderutilities.event.LivingDropsEventHandler;
import fi.dy.masa.enderutilities.event.PlayerEventHandler;
import fi.dy.masa.enderutilities.event.TickHandler;
import fi.dy.masa.enderutilities.event.WorldEventHandler;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CommonProxy {
    public String format(String key, Object ... args) {
        return I18n.func_74837_a((String)key, (Object[])args);
    }

    public EntityPlayer getClientPlayer() {
        return null;
    }

    public EntityPlayer getPlayerFromMessageContext(MessageContext ctx) {
        switch (ctx.side) {
            case SERVER: {
                return ctx.getServerHandler().field_147369_b;
            }
        }
        EnderUtilities.logger.warn("Invalid side in getPlayerFromMessageContext(): " + ctx.side);
        return null;
    }

    public void playSound(int soundId, float pitch, float volume, boolean repeat, boolean stop, float x, float y, float z) {
    }

    public ModFixs getDataFixer() {
        return FMLCommonHandler.instance().getDataFixer().init("enderutilities", 922);
    }

    public void registerEntities() {
        int id = 0;
        this.registerEntity(EntityEnderArrow.class, "enderarrow", id++, EnderUtilities.instance, 64, 2, true);
        this.registerEntity(EntityEnderPearlReusable.class, "enderpearlreusable", id++, EnderUtilities.instance, 64, 2, true);
        this.registerEntity(EntityEndermanFighter.class, "endermanfighter", id++, EnderUtilities.instance, 64, 3, true, 0x161616, 1656796);
        this.registerEntity(EntityChair.class, "chair", id++, EnderUtilities.instance, 64, 10, false);
        this.registerEntity(EntityFallingBlockEU.class, "fallingblock", id++, EnderUtilities.instance, 64, 2, false);
    }

    private void registerEntity(Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        String prefixedName = "enderutilities." + entityName;
        ResourceLocation registryName = new ResourceLocation("enderutilities", entityName);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)prefixedName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    private void registerEntity(Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        String prefixedName = "enderutilities." + entityName;
        ResourceLocation registryName = new ResourceLocation("enderutilities", entityName);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)prefixedName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)eggPrimary, (int)eggSecondary);
    }

    public void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new AnvilUpdateEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BlockEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ItemPickupEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LivingDropsEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WorldEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TickHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)EnderUtilities.instance, (ForgeChunkManager.LoadingCallback)new ChunkLoading());
    }

    public void registerKeyBindings() {
    }

    public void registerRenderers() {
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        this.registerSound((IForgeRegistry<SoundEvent>)registry, "jailer");
        this.registerSound((IForgeRegistry<SoundEvent>)registry, "molecular_exciter");
    }

    private void registerSound(IForgeRegistry<SoundEvent> registry, String name) {
        ResourceLocation resloc = new ResourceLocation("enderutilities", name);
        SoundEvent sound = new SoundEvent(resloc);
        sound.setRegistryName(resloc);
        registry.register((IForgeRegistryEntry)sound);
    }

    public boolean isShiftKeyDown() {
        return false;
    }

    public boolean isControlKeyDown() {
        return false;
    }

    public boolean isAltKeyDown() {
        return false;
    }
}

