/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.tool;

import com.google.common.collect.Multimap;
import fi.dy.masa.enderutilities.effects.Effects;
import fi.dy.masa.enderutilities.entity.EntityEndermanFighter;
import fi.dy.masa.enderutilities.item.base.IAnvilRepairable;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.item.part.ItemLinkCrystal;
import fi.dy.masa.enderutilities.item.tool.ItemEnderTool;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageAddEffects;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemEnderSword
extends ItemLocationBoundModular
implements IAnvilRepairable {
    public static final int ENDER_CHARGE_COST = 50;
    private float damageVsEntity = 7.0f;
    private final ItemEnderTool.ToolMaterial material = ItemEnderTool.ToolMaterial.ENDER_ALLOY_ADVANCED;

    public ItemEnderSword(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(this.material.getMaxUses());
        this.setNoRepair();
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return SwordMode.fromStack(stack) == SwordMode.REMOTE ? super.func_77653_i(stack) : this.getBaseItemDisplayName(stack);
    }

    private boolean addToolDamage(ItemStack stack, int amount, EntityLivingBase living1, EntityLivingBase living2) {
        if (this.isToolBroken(stack)) {
            return false;
        }
        amount = Math.min(amount, this.getMaxDamage(stack) - stack.func_77952_i());
        stack.func_77972_a(amount, living2);
        if (this.isToolBroken(stack)) {
            living1.func_70669_a(stack);
        }
        return true;
    }

    @Override
    public boolean repairItem(ItemStack stack, int amount) {
        int damage;
        if (amount == -1) {
            amount = this.material.getMaxUses();
        }
        boolean repaired = (damage = Math.max(this.getDamage(stack) - amount, 0)) != this.getDamage(stack);
        this.setDamage(stack, damage);
        return repaired;
    }

    @Override
    public boolean isRepairItem(@Nonnull ItemStack stackTool, @Nonnull ItemStack stackMaterial) {
        return InventoryUtils.areItemStacksEqual(stackMaterial, this.material.getRepairItemStack());
    }

    @Override
    public boolean canApplyEnchantment(ItemStack stackTool, Enchantment enchantment) {
        return enchantment.field_77351_y == EnumEnchantmentType.ALL || enchantment.field_77351_y == EnumEnchantmentType.BREAKABLE || enchantment.field_77351_y == EnumEnchantmentType.WEAPON;
    }

    public boolean isToolBroken(ItemStack stack) {
        return stack.func_77952_i() >= this.getMaxDamage(stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.isToolBroken(stack)) {
            return 0.2f;
        }
        if (state.func_177230_c() == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        if (material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151589_v || material == Material.field_151584_j || material == Material.field_151572_C) {
            return 1.5f;
        }
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase targetEntity, EntityLivingBase attacker) {
        if (targetEntity != null && !targetEntity.func_130014_f_().field_72995_K && SwordMode.fromStack(stack) == SwordMode.SUMMON) {
            EntityEndermanFighter.summonFighters(targetEntity.func_130014_f_(), targetEntity, 3);
        }
        return this.addToolDamage(stack, 1, targetEntity, attacker);
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase livingBase) {
        if (state.func_185887_b(world, pos) != 0.0f && !this.isToolBroken(stack)) {
            int amount = Math.min(2, this.getMaxDamage(stack) - stack.func_77952_i());
            stack.func_77972_a(amount, livingBase);
            if (this.isToolBroken(stack)) {
                livingBase.func_70669_a(stack);
            }
            return true;
        }
        return false;
    }

    private IItemHandler getLinkedInventoryWithChecks(ItemStack toolStack, EntityPlayer player) {
        SwordMode mode = SwordMode.fromStack(toolStack);
        if (mode == SwordMode.NORMAL) {
            return null;
        }
        if (mode == SwordMode.PLAYER && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) >= 0) {
            return (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        }
        if (mode == SwordMode.REMOTE && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) >= 1 && UtilItemModular.useEnderCharge(toolStack, 50, true)) {
            TargetData target = TargetData.getTargetFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (target == null || target.dimension != player.func_130014_f_().field_73011_w.getDimension() && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) != 2) {
                return null;
            }
            return UtilItemModular.getBoundInventory(toolStack, player, 15);
        }
        return null;
    }

    private ItemStack tryTeleportItems(ItemStack itemsIn, ItemStack toolStack, EntityPlayer player) {
        TargetData target = TargetData.getTargetFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (!OwnerData.canAccessSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player) || target.dimension != player.field_71093_bK && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) != 2) {
            return itemsIn;
        }
        WorldServer targetWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(target.dimension);
        if (targetWorld == null) {
            return itemsIn;
        }
        ChunkLoading.getInstance().loadChunkForcedWithPlayerTicket(player, target.dimension, target.pos.func_177958_n() >> 4, target.pos.func_177952_p() >> 4, 30);
        EntityItem entityItem = new EntityItem((World)targetWorld, target.dPosX, target.dPosY + 0.125, target.dPosZ, itemsIn.func_77946_l());
        entityItem.field_70179_y = 0.0;
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.15;
        if (targetWorld.func_72838_d((Entity)entityItem)) {
            Effects.spawnParticles((World)targetWorld, EnumParticleTypes.PORTAL, target.dPosX, target.dPosY, target.dPosZ, 3, 0.2, 1.0);
            return ItemStack.field_190927_a;
        }
        return itemsIn;
    }

    public void handleLivingDropsEvent(ItemStack toolStack, LivingDropsEvent event) {
        EntityItem item;
        if (event.getEntity().func_130014_f_().field_72995_K || this.isToolBroken(toolStack) || event.getDrops() == null || event.getDrops().size() == 0) {
            return;
        }
        SwordMode mode = SwordMode.fromStack(toolStack);
        if (mode == SwordMode.NORMAL || mode == SwordMode.SUMMON) {
            return;
        }
        List drops = event.getDrops();
        EntityPlayer player = (EntityPlayer)event.getSource().func_76364_f();
        Iterator iter = drops.iterator();
        IItemHandler inv = this.getLinkedInventoryWithChecks(toolStack, player);
        boolean transported = false;
        while (iter.hasNext()) {
            item = (EntityItem)iter.next();
            ItemStack stack = item.func_92059_d();
            if (stack.func_190926_b()) {
                iter.remove();
                continue;
            }
            ItemStack stackTmp = stack;
            if (mode == SwordMode.PLAYER && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE) >= 0 && MinecraftForge.EVENT_BUS.post((Event)new EntityItemPickupEvent(player, item))) {
                Effects.addItemTeleportEffects(player.func_130014_f_(), player.func_180425_c());
                stackTmp = ItemStack.field_190927_a;
            } else if (inv != null) {
                stackTmp = InventoryUtils.tryInsertItemStackToInventory(inv, stack.func_77946_l());
            } else if (this.getSelectedModuleTier(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 0) {
                stackTmp = this.tryTeleportItems(stack.func_77946_l(), toolStack, player);
            }
            if (stackTmp.func_190926_b()) {
                iter.remove();
                transported = true;
                continue;
            }
            if (stackTmp.func_190916_E() == stack.func_190916_E()) continue;
            stack.func_190920_e(stackTmp.func_190916_E());
            item.func_92058_a(stack);
            transported = true;
        }
        if (transported) {
            if (mode == SwordMode.REMOTE) {
                UtilItemModular.useEnderCharge(toolStack, 50, false);
            }
            Entity entity = event.getEntity();
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(2, 3, entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, 8, 0.2f, 0.3f), new NetworkRegistry.TargetPoint(entity.func_130014_f_().field_73011_w.getDimension(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 24.0));
        }
        if (drops.size() > 0) {
            iter = drops.iterator();
            while (iter.hasNext()) {
                item = (EntityItem)iter.next();
                MinecraftForge.EVENT_BUS.post((Event)new EntityItemPickupEvent(player, item));
                if (!item.field_70128_L && !item.func_92059_d().func_190926_b()) continue;
                iter.remove();
            }
        }
        if (drops.isEmpty()) {
            event.setCanceled(true);
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material.getEnchantability();
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (player.func_70093_af() && te != null && (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) || te.getClass() == TileEntityEnderChest.class) && UtilItemModular.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 1) {
            if (!world.field_72995_K) {
                UtilItemModular.setTarget(stack, player, pos, side, hitX, hitY, hitZ, false, false);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return state.func_177230_c() == Blocks.field_150321_G;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            double dmg = this.damageVsEntity;
            if (this.isToolBroken(stack) || SwordMode.fromStack(stack) == SwordMode.SUMMON) {
                dmg = 0.0;
            }
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", dmg, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.3, 0));
        }
        return multimap;
    }

    public void cycleSwordMode(ItemStack stack) {
        NBTUtils.cycleByteValue(stack, null, "SwordMode", 3);
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 65536)) {
            this.cycleSwordMode(stack);
            return true;
        }
        return super.doKeyBindingAction(player, stack, key);
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 5;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCORE)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack.func_190926_b() || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        int tier = imodule.getModuleTier(moduleStack);
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) && tier != 0 && tier != 1) {
            return 0;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCORE) && (tier < 0 || tier > 2)) {
            return 0;
        }
        return this.getMaxModules(containerStack, moduleType);
    }

    @Override
    public void addTooltipLines(ItemStack stack, EntityPlayer player, List<String> list, boolean verbose) {
        ItemStack linkCrystalStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        ItemStack capacitorStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
        int coreTier = this.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCORE);
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String preDGreen = TextFormatting.DARK_GREEN.toString();
        String preBlue = TextFormatting.BLUE.toString();
        SwordMode mode = SwordMode.fromStack(stack);
        String str = mode == SwordMode.NORMAL ? "enderutilities.tooltip.item.normal" : (mode == SwordMode.PLAYER ? "enderutilities.tooltip.item.endertool.playerinv" : (mode == SwordMode.REMOTE ? "enderutilities.tooltip.item.endertool.remote" : "enderutilities.tooltip.item.endersword.summon"));
        str = I18n.func_135052_a((String)str, (Object[])new Object[0]);
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + preDGreen + str + rst);
        str = I18n.func_135052_a((String)"enderutilities.tooltip.item.endercore", (Object[])new Object[0]) + ": ";
        if (coreTier >= 0 && coreTier <= 2) {
            String coreType = coreTier == 0 ? "enderutilities.tooltip.item.basic" : (coreTier == 1 ? "enderutilities.tooltip.item.enhanced" : "enderutilities.tooltip.item.advanced");
            coreType = I18n.func_135052_a((String)coreType, (Object[])new Object[0]);
            str = str + preDGreen + coreType + rst + " (" + preBlue + I18n.func_135052_a((String)"enderutilities.tooltip.item.tier", (Object[])new Object[0]) + " " + (coreTier + 1) + rst + ")";
        } else {
            String preRed = TextFormatting.RED.toString();
            str = str + preRed + I18n.func_135052_a((String)"enderutilities.tooltip.item.none", (Object[])new Object[0]) + rst;
        }
        list.add(str);
        if (!linkCrystalStack.func_190926_b() && linkCrystalStack.func_77973_b() instanceof ItemLinkCrystal) {
            String preWhiteIta = TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString();
            if (TargetData.itemHasTargetTag(linkCrystalStack)) {
                ((ItemLinkCrystal)linkCrystalStack.func_77973_b()).addTooltipLines(linkCrystalStack, player, list, verbose);
            } else {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.notargetset", (Object[])new Object[0]));
            }
            int num = UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) + 1;
            String dName = linkCrystalStack.func_82837_s() ? preWhiteIta + linkCrystalStack.func_82833_r() + rst + " " : "";
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedlinkcrystal.short", (Object[])new Object[0]) + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
        } else {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.nolinkcrystals", (Object[])new Object[0]));
        }
        if (!capacitorStack.func_190926_b() && capacitorStack.func_77973_b() instanceof ItemEnderCapacitor) {
            ((ItemEnderCapacitor)capacitorStack.func_77973_b()).addTooltipLines(capacitorStack, player, list, verbose);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @Override
    public ResourceLocation[] getItemVariants() {
        return new ResourceLocation[]{new ModelResourceLocation("enderutilities:item_endertool", "inventory")};
    }

    @Override
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        return new ModelResourceLocation("enderutilities:item_endertool", "inventory");
    }

    public static enum SwordMode {
        NORMAL("enderutilities.tooltip.item.normal"),
        PLAYER("enderutilities.tooltip.item.endertool.playerinv"),
        REMOTE("enderutilities.tooltip.item.endertool.remote"),
        SUMMON("enderutilities.tooltip.item.endersword.summon");

        private final String unlocalized;

        private SwordMode(String unlocalized) {
            this.unlocalized = unlocalized;
        }

        public static SwordMode fromStack(ItemStack stack) {
            int mode = MathHelper.func_76125_a((int)NBTUtils.getByte(stack, null, "SwordMode"), (int)0, (int)3);
            return SwordMode.values()[mode];
        }

        public String getDisplayName() {
            return I18n.func_135052_a((String)this.unlocalized, (Object[])new Object[0]);
        }
    }
}

