/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.inventory.container.ContainerInventorySwapper;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemModular;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IKeyBoundUnselected;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemInventoryModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderPart;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.registry.ModRegistry;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemInventorySwapper
extends ItemInventoryModular
implements IKeyBound,
IKeyBoundUnselected {
    public static final String TAG_NAME_CONTAINER = "InventorySwpapper";
    public static final String TAG_NAME_PRESET_SELECTION = "SelectedPreset";
    public static final String TAG_NAME_PRESET = "Preset_";
    public static final String TAG_NAME_LOCKED = "Locked";
    public static final String TAG_NAME_CYCLE_MODE = "Cycle";
    public static final int NUM_PRESETS = 4;
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_CHANGE_PRESET = 1;
    public static final int GUI_ACTION_TOGGLE_ROWS = 2;
    public static final int GUI_ACTION_TOGGLE_COLUMNS = 3;
    public static final int GUI_ACTION_TOGGLE_LOCKED = 4;
    public static final int GUI_ACTION_TOGGLE_CYCLE_MODE = 5;

    public ItemInventorySwapper(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            NBTUtils.getUUIDFromItemStack(stack, "UUID", true);
            player.field_71070_bA.func_75142_b();
            player.openGui((Object)EnderUtilities.instance, 1003, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (player.func_70093_af() && (te = world.func_175625_s(pos)) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler inv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (!world.field_72995_K && inv != null) {
                this.swapInventory(player.func_184586_b(hand), inv, player);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        NBTUtils.getUUIDFromItemStack(stack, "UUID", true);
    }

    public String func_77653_i(ItemStack stack) {
        String itemName = super.func_77653_i(stack);
        String preGreenIta = TextFormatting.GREEN.toString() + TextFormatting.ITALIC.toString();
        String preGreen = TextFormatting.GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        int slotNum = UtilItemModular.getStoredModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        ItemStack moduleStack = UtilItemModular.getModuleStackBySlotNumber(stack, slotNum, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (!moduleStack.func_190926_b() && moduleStack.func_77978_p() != null && moduleStack.func_82837_s()) {
            itemName = itemName.length() >= 14 ? EUStringUtils.getInitialsWithDots(itemName) + " " + preGreenIta + moduleStack.func_82833_r() + rst : itemName + " " + preGreenIta + moduleStack.func_82833_r() + rst;
        }
        itemName = itemName + " MC: " + preGreen + (slotNum + 1) + rst;
        byte selected = NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        itemName = itemName + " P: " + preGreen + (selected + 1) + rst;
        return itemName;
    }

    @Override
    public void addTooltipLines(ItemStack containerStack, EntityPlayer player, List<String> list, boolean verbose) {
        if (containerStack.func_77978_p() == null) {
            return;
        }
        String preGreen = TextFormatting.GREEN.toString();
        String preBlue = TextFormatting.BLUE.toString();
        String preRed = TextFormatting.RED.toString();
        String preWhite = TextFormatting.WHITE.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String strYes = preGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) + rst;
        String strNo = preRed + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]) + rst;
        if (this.isEnabled(containerStack)) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.enabled", (Object[])new Object[0]) + ": " + strYes);
        } else {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.enabled", (Object[])new Object[0]) + ": " + strNo);
        }
        if (NBTUtils.getBoolean(containerStack, TAG_NAME_CONTAINER, TAG_NAME_CYCLE_MODE)) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.cyclemode", (Object[])new Object[0]) + ": " + strYes);
        } else {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.cyclemode", (Object[])new Object[0]) + ": " + strNo);
        }
        byte selected = NBTUtils.getByte(containerStack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.preset", (Object[])new Object[0]) + ": " + preBlue + (selected + 1) + rst);
        int installed = this.getInstalledModuleCount(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (installed > 0) {
            int slotNum = UtilItemModular.getStoredModuleSelection(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            String preWhiteIta = preWhite + TextFormatting.ITALIC.toString();
            String strShort = I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedmemorycard.short", (Object[])new Object[0]);
            ItemStack moduleStack = UtilItemModular.getModuleStackBySlotNumber(containerStack, slotNum, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            int max = this.getMaxModules(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            if (!moduleStack.func_190926_b() && moduleStack.func_77973_b() == EnderUtilitiesItems.ENDER_PART) {
                String dName = moduleStack.func_82837_s() ? preWhiteIta + moduleStack.func_82833_r() + rst + " " : "";
                list.add(String.format("%s %s (%s%d%s / %s%d%s)", strShort, dName, preBlue, slotNum + 1, rst, preBlue, max, rst));
                ((ItemEnderPart)moduleStack.func_77973_b()).addTooltipLines(moduleStack, player, list, false);
                return;
            }
        } else {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.nomemorycards", (Object[])new Object[0]));
        }
    }

    @Override
    public int getSizeInventory(ItemStack containerStack) {
        return ModRegistry.isModLoadedBaubles() ? 48 : 41;
    }

    public boolean isEnabled(ItemStack stack) {
        return !NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
    }

    private int getSlotContainingEnabledItem(EntityPlayer player) {
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems(playerInv, EnderUtilitiesItems.INVENTORY_SWAPPER);
        for (int slot : slots) {
            if (!this.isEnabled(playerInv.getStackInSlot(slot))) continue;
            return slot;
        }
        return -1;
    }

    private ItemStack getEnabledItem(EntityPlayer player) {
        int slotNum = this.getSlotContainingEnabledItem(player);
        return slotNum != -1 ? player.field_71071_by.func_70301_a(slotNum) : ItemStack.field_190927_a;
    }

    public long getEnabledSlotsMask(ItemStack stack) {
        byte selected = NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        return NBTUtils.getLong(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET + selected);
    }

    private void swapInventory(long slotMask, InventoryItemModular swapperInv, IItemHandler externalInv) {
        int invSize = Math.min(36, externalInv.getSlots());
        long bit = 1L;
        for (int i = 0; i < invSize; ++i) {
            if ((slotMask & bit) != 0L) {
                ItemStack stackSwapper = swapperInv.extractItem(i, 64, false);
                ItemStack stackExternal = externalInv.extractItem(i, 64, false);
                if (swapperInv.insertItem(i, stackExternal, true).func_190926_b() && externalInv.insertItem(i, stackSwapper, true).func_190926_b()) {
                    swapperInv.insertItem(i, stackExternal, false);
                    externalInv.insertItem(i, stackSwapper, false);
                } else {
                    swapperInv.insertItem(i, stackSwapper, false);
                    externalInv.insertItem(i, stackExternal, false);
                }
            }
            bit <<= 1;
        }
    }

    private void swapInventory(ItemStack swapperStack, IItemHandler inv, EntityPlayer player) {
        InventoryItemModular swapperInv = new InventoryItemModular(swapperStack, player, false, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (!swapperInv.isAccessibleBy((Entity)player)) {
            return;
        }
        this.swapInventory(this.getEnabledSlotsMask(swapperStack), swapperInv, inv);
        player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.2f, 1.8f);
    }

    private boolean swapPlayerInventory(int swapperSlot, EntityPlayer player) {
        IItemHandler baublesInv;
        ItemStack swapperStack = player.field_71071_by.func_70301_a(swapperSlot);
        if (swapperStack.func_190926_b()) {
            return false;
        }
        InventoryItemModular swapperInv = new InventoryItemModular(swapperStack, player, false, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (!swapperInv.isAccessibleBy((Entity)player)) {
            return false;
        }
        long mask = this.getEnabledSlotsMask(swapperStack);
        int invMax = player.field_71071_by.func_70297_j_();
        int playerInvSize = player.field_71071_by.func_70302_i_();
        int mainInvSize = player.field_71071_by.field_70462_a.size();
        long bit = 1L;
        for (int slot = 0; slot < playerInvSize; ++slot) {
            if (slot != swapperSlot && (mask & bit) != 0L) {
                this.swapRegularSlot(swapperInv, slot, mainInvSize, invMax, player);
            }
            bit <<= 1;
        }
        if (ModRegistry.isModLoadedBaubles() && (baublesInv = ContainerInventorySwapper.getBaublesInvProvider().getBaublesInventory(player)) != null) {
            for (int slotBaubles = 0; slotBaubles < 7; ++slotBaubles) {
                int slotSwapper = slotBaubles + playerInvSize;
                if (slotSwapper != swapperSlot && (mask & bit) != 0L) {
                    this.swapBaublesSlot(swapperInv, baublesInv, slotSwapper, slotBaubles);
                }
                bit <<= 1;
            }
        }
        player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.2f, 1.8f);
        return true;
    }

    private void swapRegularSlot(InventoryItemModular swapperInv, int slot, int mainInvSize, int invMax, EntityPlayer player) {
        ItemStack stackInSwapper = swapperInv.getStackInSlot(slot);
        if (stackInSwapper.func_190926_b() || stackInSwapper.func_190916_E() <= Math.min(stackInSwapper.func_77976_d(), invMax) && player.field_71071_by.func_94041_b(slot, stackInSwapper)) {
            if (slot >= mainInvSize && slot < mainInvSize + 4) {
                int pos = -1;
                if (!stackInSwapper.func_190926_b()) {
                    EntityEquipmentSlot equipmentSlot = EntityLiving.func_184640_d((ItemStack)stackInSwapper);
                    if (stackInSwapper.func_190916_E() == 1 && equipmentSlot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
                        pos = equipmentSlot.func_188454_b();
                    }
                } else if (!player.field_71071_by.func_70301_a(slot).func_190926_b()) {
                    pos = slot - mainInvSize;
                }
                if (pos >= 0 && pos == slot - mainInvSize) {
                    swapperInv.setStackInSlot(slot, player.field_71071_by.func_70301_a(slot));
                    player.field_71071_by.func_70299_a(slot, stackInSwapper);
                }
            } else {
                swapperInv.setStackInSlot(slot, player.field_71071_by.func_70301_a(slot));
                player.field_71071_by.func_70299_a(slot, stackInSwapper);
            }
        }
    }

    private void swapBaublesSlot(InventoryItemModular swapperInv, IItemHandler baublesInv, int slotSwapper, int slotBaubles) {
        ItemStack stackInSwapperInv = swapperInv.getStackInSlot(slotSwapper);
        if (stackInSwapperInv.func_190926_b() || stackInSwapperInv.func_190916_E() == 1) {
            ItemStack stackInBaublesInv = baublesInv.getStackInSlot(slotBaubles);
            if (!stackInBaublesInv.func_190926_b()) {
                if (!(stackInBaublesInv = baublesInv.extractItem(slotBaubles, stackInBaublesInv.func_190916_E(), false)).func_190926_b()) {
                    if (baublesInv.insertItem(slotBaubles, stackInSwapperInv, false).func_190926_b()) {
                        swapperInv.setStackInSlot(slotSwapper, stackInBaublesInv);
                    } else {
                        baublesInv.insertItem(slotBaubles, stackInBaublesInv, false);
                    }
                }
            } else if (!stackInSwapperInv.func_190926_b() && baublesInv.insertItem(slotBaubles, stackInSwapperInv, false).func_190926_b()) {
                swapperInv.setStackInSlot(slotSwapper, ItemStack.field_190927_a);
            }
        }
    }

    private boolean swapPlayerInventory(EntityPlayer player) {
        int slot = this.getSlotContainingEnabledItem(player);
        if (slot != -1) {
            return this.swapPlayerInventory(slot, player);
        }
        return false;
    }

    private boolean cycleInventory(EntityPlayer player, boolean reverse) {
        ItemStack stack;
        int slot = this.getSlotContainingEnabledItem(player);
        if (slot != -1 && this.getInstalledModuleCount(stack = player.field_71071_by.func_70301_a(slot), ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS) > 1) {
            this.swapPlayerInventory(slot, player);
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, reverse);
            this.swapPlayerInventory(slot, player);
            return true;
        }
        return false;
    }

    @Override
    public boolean doUnselectedKeyAction(EntityPlayer player, ItemStack stack, int key) {
        stack = this.getEnabledItem(player);
        if (!stack.func_190926_b() && stack.func_77973_b() == EnderUtilitiesItems.INVENTORY_SWAPPER) {
            return ((ItemInventorySwapper)stack.func_77973_b()).doKeyBindingAction(player, stack, key);
        }
        return false;
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 0)) {
            this.swapPlayerInventory(player);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 327680)) {
            NBTUtils.toggleBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 65536)) {
            NBTUtils.cycleByteValue(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION, 3, HotKeys.EnumKey.keypressActionIsReversed(key));
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 458752)) {
            NBTUtils.toggleBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_CYCLE_MODE);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 131072, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 131072)) {
            if (NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_CYCLE_MODE)) {
                this.cycleInventory(player, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key));
                return true;
            }
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key));
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 262144)) {
            if (NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_CYCLE_MODE)) {
                this.cycleInventory(player, true);
                return true;
            }
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, true);
            return true;
        }
        return false;
    }

    public static void performGuiAction(EntityPlayer player, int action, int element) {
        ItemStack stack;
        if (player.field_71070_bA instanceof ContainerInventorySwapper && !(stack = ((ContainerInventorySwapper)player.field_71070_bA).getContainerItem()).func_190926_b() && stack.func_77973_b() == EnderUtilitiesItems.INVENTORY_SWAPPER) {
            ItemInventorySwapper swapper = (ItemInventorySwapper)stack.func_77973_b();
            int max = swapper.getMaxModules(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            if (action == 0 && element >= 0 && element < max) {
                UtilItemModular.setModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, element);
                ((ContainerInventorySwapper)player.field_71070_bA).inventoryItemModular.readFromContainerItemStack();
            } else if (action == 1 && element >= 0 && element < 4) {
                NBTUtils.setByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION, (byte)element);
            } else if (action == 2 && element >= 0 && element < 4) {
                long mask = swapper.getEnabledSlotsMask(stack);
                NBTUtils.setLong(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET + NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION), mask ^= 511L << element * 9);
            } else if (action == 3) {
                long mask = swapper.getEnabledSlotsMask(stack);
                if (element >= 0 && element < 9) {
                    mask ^= 134480385L << element;
                } else if (element == 9) {
                    mask ^= 0x1F000000000L;
                } else if (element == 10) {
                    mask ^= 0xFE0000000000L;
                }
                NBTUtils.setLong(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET + NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION), mask);
            } else if (action == 4) {
                NBTUtils.toggleBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
            } else if (action == 5) {
                NBTUtils.toggleBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_CYCLE_MODE);
            }
        }
    }

    @Override
    public boolean useAbsoluteModuleIndexing(ItemStack stack) {
        return true;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return moduleType.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS) ? this.getMaxModules(containerStack) : 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        IModule imodule;
        if (moduleStack.func_77973_b() instanceof IModule && (imodule = (IModule)moduleStack.func_77973_b()).getModuleType(moduleStack).equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS) && imodule.getModuleTier(moduleStack) == 6) {
            return this.getMaxModules(containerStack);
        }
        return 0;
    }

    @Override
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        return new ResourceLocation[]{new ModelResourceLocation(rl, "locked=false"), new ModelResourceLocation(rl, "locked=true")};
    }

    @Override
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        String rl = "enderutilities:item_" + this.name;
        return new ModelResourceLocation(rl, "locked=" + NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED));
    }
}

