/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.event.tasks.PlayerTaskScheduler;
import fi.dy.masa.enderutilities.event.tasks.TaskBuildersWand;
import fi.dy.masa.enderutilities.event.tasks.TaskMoveArea;
import fi.dy.masa.enderutilities.event.tasks.TaskReplaceBlocks;
import fi.dy.masa.enderutilities.event.tasks.TaskReplaceBlocks3D;
import fi.dy.masa.enderutilities.event.tasks.TaskStackArea;
import fi.dy.masa.enderutilities.event.tasks.TaskTemplatePlaceBlocks;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.IStringInput;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.util.BlockInfo;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.TemplateEnderUtilities;
import fi.dy.masa.enderutilities.util.TemplateManagerEU;
import fi.dy.masa.enderutilities.util.TemplateMetadata;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemBuildersWand
extends ItemLocationBoundModular
implements IStringInput {
    public static final int ENDER_CHARGE_COST = 2;
    public static final int MAX_BLOCKS = 16;
    public static final String WRAPPER_TAG_NAME = "BuildersWand";
    public static final String TAG_NAME_MODE = "Mode";
    public static final String TAG_NAME_CONFIGS = "Configs";
    public static final String TAG_NAME_CONFIG_PRE = "Mode_";
    public static final String TAG_NAME_CORNERS = "Corners";
    public static final String TAG_NAME_DIMENSIONS = "Dim";
    public static final String TAG_NAME_BLOCKS = "Blocks";
    public static final String TAG_NAME_BLOCK_PRE = "Block_";
    public static final String TAG_NAME_BLOCK_SEL = "SelBlock";
    public static final String TAG_NAME_TEMPLATES = "Templates";
    public static final int BLOCK_TYPE_TARGETED = -1;
    public static final int BLOCK_TYPE_ADJACENT = -2;
    public static final boolean POS_START = true;
    public static final boolean POS_END = false;
    protected Map<UUID, Long> lastLeftClick = new HashMap<UUID, Long>();

    public ItemBuildersWand(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        BlockPosEU pos = this.getPosition(stack, true);
        if (pos == null) {
            return super.func_77659_a(world, player, hand);
        }
        Mode mode = Mode.getMode(stack);
        if (!world.field_72995_K) {
            if (this.cancelRunningTask(player)) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (!mode.hasUseDelay()) {
                EnumActionResult result = this.useWand(stack, world, player, pos);
                return new ActionResult(result, (Object)stack);
            }
        }
        if (mode.hasUseDelay() && this.getPosition(stack, false) != null) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private boolean cancelRunningTask(EntityPlayer player) {
        boolean removed = false;
        Class[] classes = new Class[]{TaskBuildersWand.class, TaskReplaceBlocks.class, TaskStackArea.class, TaskTemplatePlaceBlocks.class};
        PlayerTaskScheduler scheduler = PlayerTaskScheduler.getInstance();
        for (Class clazz : classes) {
            if (!scheduler.hasTask(player, clazz)) continue;
            PlayerTaskScheduler.getInstance().removeTask(player, clazz);
            removed = true;
        }
        return removed;
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) || te.getClass() == TileEntityEnderChest.class)) {
            return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        Mode mode = Mode.getMode(stack);
        if (mode.hasTwoPlacableCorners()) {
            if (!world.field_72995_K) {
                if (mode == Mode.REPLACE_3D && player.func_70093_af() && WandOption.BIND_MODE.isEnabled(stack, mode)) {
                    this.setSelectedFixedBlockType(stack, player, world, pos, true);
                } else {
                    BlockPosEU posEU = new BlockPosEU(player.func_70093_af() ? pos : pos.func_177972_a(side), world.field_73011_w.getDimension(), side);
                    this.setPosition(posEU, false, stack, player);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        if (!(world.field_72995_K || player.func_70093_af() && side == EnumFacing.UP && mode != Mode.REPLACE)) {
            if (mode != Mode.REPLACE) {
                pos = pos.func_177972_a(side);
            }
            return this.useWand(stack, world, player, new BlockPosEU(pos, world.field_73011_w.getDimension(), side));
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Mode mode = Mode.getMode(stack);
        if (mode == Mode.REPLACE_3D && player.func_70093_af() && WandOption.BIND_MODE.isEnabled(stack, mode)) {
            if (!world.field_72995_K) {
                this.setSelectedFixedBlockType(stack, player, world, pos, true);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        if (mode.hasTwoPlacableCorners()) {
            if (!world.field_72995_K) {
                BlockPosEU posEU = new BlockPosEU(player.func_70093_af() ? pos : pos.func_177972_a(side), world.field_73011_w.getDimension(), side);
                this.setPosition(posEU, false, stack, player);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public void onLeftClickBlock(EntityPlayer player, World world, ItemStack stack, BlockPos pos, int dimension, EnumFacing side) {
        if (world.field_72995_K) {
            return;
        }
        Long last = this.lastLeftClick.get(player.func_110124_au());
        if (last == null || world.func_82737_E() - last >= 4L) {
            Mode mode = Mode.getMode(stack);
            if (player.func_70093_af() && (!mode.isAreaMode() || mode == Mode.REPLACE_3D && WandOption.BIND_MODE.isEnabled(stack, mode))) {
                this.setSelectedFixedBlockType(stack, player, world, pos, false);
            } else if (mode == Mode.REPLACE) {
                if (WandOption.REPLACE_MODE_IS_AREA.isEnabled(stack, mode)) {
                    this.setPosition(new BlockPosEU(pos, world.field_73011_w.getDimension(), side), true, stack, player);
                }
            } else {
                BlockPosEU posEU = new BlockPosEU(player.func_70093_af() ? pos : pos.func_177972_a(side), world.field_73011_w.getDimension(), side);
                this.setPosition(posEU, true, stack, player);
            }
        }
        this.lastLeftClick.put(player.func_110124_au(), world.func_82737_E());
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase livingBase, int itemInUseCount) {
        if (world.field_72995_K || !(livingBase instanceof EntityPlayer)) {
            return;
        }
        if (this.func_77626_a(stack) - itemInUseCount >= 20) {
            EntityPlayer player = (EntityPlayer)livingBase;
            BlockPosEU pos = this.getPosition(stack, true);
            if (pos != null && this.useWand(stack, world, player, pos) == EnumActionResult.SUCCESS) {
                player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.4f, 0.7f);
            }
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        String itemName = this.getBaseItemDisplayName(stack);
        if (stack.func_77978_p() == null) {
            return itemName;
        }
        Mode mode = Mode.getMode(stack);
        String preGreen = TextFormatting.GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        if (itemName.length() >= 14) {
            itemName = EUStringUtils.getInitialsWithDots(itemName);
        }
        itemName = itemName + " - " + preGreen + mode.getDisplayName() + rst;
        return itemName;
    }

    @Override
    public void addTooltipLines(ItemStack stack, EntityPlayer player, List<String> list, boolean verbose) {
        String str;
        if (stack.func_77978_p() == null) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.usetoolworkstation", (Object[])new Object[0]));
            return;
        }
        String pre = TextFormatting.DARK_GREEN.toString();
        String preGreen = TextFormatting.GREEN.toString();
        String preRed = TextFormatting.RED.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String strYes = preGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) + rst;
        String strNo = preRed + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]) + rst;
        Mode mode = Mode.getMode(stack);
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + pre + mode.getDisplayName() + rst);
        int sel = this.getSelectionIndex(stack);
        if (mode.isAreaMode() && mode != Mode.REPLACE_3D) {
            str = mode == Mode.COPY || mode == Mode.PASTE ? I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedtemplate", (Object[])new Object[0]) : I18n.func_135052_a((String)"enderutilities.tooltip.item.area", (Object[])new Object[0]);
            list.add(str + ": " + preGreen + (sel + 1) + rst);
        } else if (sel >= 0) {
            ItemStack blockStack;
            BlockInfo blockInfo = this.getSelectedFixedBlockType(stack, false);
            if (blockInfo != null && !(blockStack = new ItemStack(blockInfo.block, 1, blockInfo.itemMeta)).func_190926_b()) {
                str = I18n.func_135052_a((String)"enderutilities.tooltip.item.build.target", (Object[])new Object[0]);
                list.add(str + ": " + pre + blockStack.func_82833_r() + rst);
            }
            if (mode == Mode.REPLACE_3D && (blockInfo = this.getSelectedFixedBlockType(stack, true)) != null && !(blockStack = new ItemStack(blockInfo.block, 1, blockInfo.itemMeta)).func_190926_b()) {
                str = I18n.func_135052_a((String)"enderutilities.tooltip.item.build.replacement", (Object[])new Object[0]);
                list.add(str + ": " + pre + blockStack.func_82833_r() + rst);
            }
        } else {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedblock", (Object[])new Object[0]);
            if (sel == -1) {
                list.add(str + ": " + pre + I18n.func_135052_a((String)"enderutilities.tooltip.item.blocktype.targeted", (Object[])new Object[0]) + rst);
            } else if (sel == -2) {
                list.add(str + ": " + pre + I18n.func_135052_a((String)"enderutilities.tooltip.item.blocktype.adjacent", (Object[])new Object[0]) + rst);
            }
        }
        if (mode.isAreaMode()) {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.rotation", (Object[])new Object[0]) + ": ";
            EnumFacing facing = this.getAreaFacing(stack, mode);
            String str2 = facing != null ? preGreen + facing.toString().toLowerCase() : preRed + "N/A";
            list.add(str + str2 + rst);
            str2 = I18n.func_135052_a((String)"enderutilities.tooltip.item.mirror", (Object[])new Object[0]) + ": ";
            if (this.isMirrored(stack)) {
                list.add(str2 + preGreen + (this.getMirror(stack) == Mirror.FRONT_BACK ? "x" : "z") + rst);
            } else {
                list.add(str2 + strNo);
            }
        } else {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.area.flipped", (Object[])new Object[0]);
            if (this.isAreaFlipped(stack)) {
                list.add(str + ": " + strYes + rst);
                str = I18n.func_135052_a((String)"enderutilities.tooltip.item.flipaxis", (Object[])new Object[0]);
                String preBlue = TextFormatting.BLUE.toString();
                list.add(str + ": " + preBlue + this.getAreaFlipAxis(stack, EnumFacing.UP) + rst);
            } else {
                list.add(str + ": " + strNo + rst);
            }
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.move", (Object[])new Object[0]);
            list.add(str + ": " + (WandOption.MOVE_POSITION.isEnabled(stack, mode) ? strYes : strNo) + rst);
        }
        if (mode == Mode.EXTEND_CONTINUOUS) {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.builderswand.allowdiagonals", (Object[])new Object[0]);
            list.add(str + ": " + (WandOption.ALLOW_DIAGONALS.isEnabled(stack, mode) ? strYes : strNo) + rst);
        }
        if (!mode.isAreaMode()) {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.builderswand.renderghostblocks", (Object[])new Object[0]);
            list.add(str + ": " + (WandOption.RENDER_GHOST.isEnabled(stack, mode) ? strYes : strNo) + rst);
        }
        super.addTooltipLines(stack, player, list, verbose);
    }

    private NBTTagCompound getModeTag(ItemStack stack, Mode mode) {
        NBTTagCompound configsTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        return NBTUtils.getCompoundTag(configsTag, TAG_NAME_CONFIG_PRE + mode.getName(), true);
    }

    public BlockPosEU getPosition(ItemStack stack, boolean isStart) {
        return this.getPosition(stack, Mode.getMode(stack), isStart);
    }

    public BlockPosEU getPosition(ItemStack stack, Mode mode, boolean isStart) {
        if (mode.isAreaMode()) {
            if (isStart) {
                return this.getPerTemplateAreaCorner(stack, mode, isStart);
            }
            return this.getTransformedEndPosition(stack, mode);
        }
        if (mode == Mode.REPLACE && !WandOption.REPLACE_MODE_IS_AREA.isEnabled(stack, mode)) {
            return null;
        }
        return BlockPosEU.readFromTag(this.getModeTag(stack, mode).func_74775_l(isStart ? "Pos1" : "Pos2"));
    }

    private BlockPosEU getTransformedEndPosition(ItemStack stack, Mode mode) {
        return this.getTransformedEndPosition(stack, mode, this.getPerTemplateAreaCorner(stack, mode, true));
    }

    public BlockPosEU getTransformedEndPosition(ItemStack stack, Mode mode, BlockPosEU posStart) {
        EnumFacing origFacing;
        BlockPosEU posEndRelative;
        if (posStart == null) {
            return null;
        }
        Mirror mirror = Mirror.NONE;
        Rotation rotation = Rotation.NONE;
        EnumFacing adjustedFacing = this.getAreaFacing(stack, mode);
        if (mode == Mode.PASTE) {
            NBTTagCompound tag = this.getSelectedTemplateTag(stack, mode, false);
            if (tag == null) {
                return null;
            }
            posEndRelative = new BlockPosEU(tag.func_74762_e("endOffsetX"), tag.func_74762_e("endOffsetY"), tag.func_74762_e("endOffsetZ"));
            origFacing = this.getTemplateFacing(stack);
        } else if (mode == Mode.MOVE_DST) {
            BlockPosEU posStartSrc = this.getPerTemplateAreaCorner(stack, Mode.MOVE_SRC, true);
            BlockPosEU posEnd = this.getPerTemplateAreaCorner(stack, Mode.MOVE_SRC, false);
            if (posStartSrc == null || posEnd == null) {
                return null;
            }
            posEndRelative = posEnd.subtract(posStartSrc);
            origFacing = PositionUtils.getFacingFromPositions(posStartSrc, posEnd);
        } else {
            BlockPosEU posEnd = this.getPerTemplateAreaCorner(stack, mode, false);
            if (posEnd == null) {
                return null;
            }
            posEndRelative = posEnd.subtract(posStart);
            origFacing = PositionUtils.getFacingFromPositions(posStart, posEnd);
        }
        if (adjustedFacing == null) {
            adjustedFacing = origFacing;
        }
        mirror = this.getMirror(stack, mode);
        rotation = PositionUtils.getRotation(origFacing, adjustedFacing);
        posEndRelative = PositionUtils.getTransformedBlockPos(posEndRelative, mirror, rotation);
        return posStart.add(posEndRelative);
    }

    private NBTTagCompound getCornerPositionTag(ItemStack stack, Mode mode, boolean isStart) {
        int sel = mode == Mode.REPLACE_3D ? 0 : this.getSelectionIndex(stack);
        NBTTagCompound tag = this.getModeTag(stack, mode);
        tag = NBTUtils.getCompoundTag(tag, "Corners_" + sel, true);
        tag = NBTUtils.getCompoundTag(tag, isStart ? "Pos1" : "Pos2", true);
        return tag;
    }

    private void removeCornerPositionTag(ItemStack stack, Mode mode, boolean isStart) {
        int sel = this.getSelectionIndex(stack);
        NBTTagCompound tag = this.getModeTag(stack, mode);
        tag = NBTUtils.getCompoundTag(tag, "Corners_" + sel, true);
        tag.func_82580_o(isStart ? "Pos1" : "Pos2");
    }

    public NBTTagCompound getAreaTag(ItemStack stack) {
        NBTTagCompound tag = this.getModeTag(stack, Mode.getMode(stack));
        return NBTUtils.getCompoundTag(tag, "Area_" + this.getSelectionIndex(stack), true);
    }

    private BlockPosEU getPerTemplateAreaCorner(ItemStack stack, Mode mode, boolean isStart) {
        return BlockPosEU.readFromTag(this.getCornerPositionTag(stack, mode, isStart));
    }

    private void setPerTemplateAreaCorner(BlockPosEU pos, Mode mode, boolean isStart, ItemStack stack, EntityPlayer player) {
        BlockPosEU oldPos = this.getPerTemplateAreaCorner(stack, mode, isStart);
        if (oldPos != null && oldPos.equals(pos)) {
            this.removeCornerPositionTag(stack, mode, isStart);
            return;
        }
        if (PositionUtils.isPositionValid(pos)) {
            BlockPosEU endPos;
            if (isStart && (endPos = this.getTransformedEndPosition(stack, mode, pos)) != null && !PositionUtils.isPositionValid(endPos)) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.positionoutsideworld", new Object[0]), true);
                return;
            }
            pos.writeToTag(this.getCornerPositionTag(stack, mode, isStart));
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.positionoutsideworld", new Object[0]), true);
        }
    }

    public void setPosition(BlockPosEU pos, boolean isStart, ItemStack stack, EntityPlayer player) {
        String tagName;
        Mode mode = Mode.getMode(stack);
        if (!PositionUtils.isPositionValid(pos)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.positionoutsideworld", new Object[0]), true);
            return;
        }
        if (!isStart && (mode == Mode.PASTE || mode == Mode.MOVE_DST || mode == Mode.REPLACE) || mode == Mode.REPLACE && !WandOption.REPLACE_MODE_IS_AREA.isEnabled(stack, mode)) {
            return;
        }
        if (mode.isAreaMode()) {
            this.setPerTemplateAreaCorner(pos, mode, isStart, stack, player);
            this.setMirror(stack, mode, Mirror.NONE);
            BlockPosEU posStart = this.getPerTemplateAreaCorner(stack, mode, true);
            BlockPosEU posEnd = this.getPerTemplateAreaCorner(stack, mode, false);
            if (posStart != null && posEnd != null) {
                this.setAreaFacing(stack, mode, PositionUtils.getFacingFromPositions(posStart, posEnd));
            }
            return;
        }
        NBTTagCompound tag = this.getModeTag(stack, mode);
        String string = tagName = isStart ? "Pos1" : "Pos2";
        if (tag.func_150297_b(tagName, 10)) {
            BlockPosEU oldPos = BlockPosEU.readFromTag(tag.func_74775_l(tagName));
            if (oldPos != null && oldPos.equals(pos)) {
                tag.func_82580_o(tagName);
            } else {
                tag.func_74782_a(tagName, (NBTBase)pos.writeToTag(new NBTTagCompound()));
            }
        } else {
            tag.func_74782_a(tagName, (NBTBase)pos.writeToTag(new NBTTagCompound()));
        }
    }

    private EnumActionResult useWand(ItemStack stack, World world, EntityPlayer player, BlockPosEU posTarget) {
        if (world.field_73011_w.getDimension() != posTarget.getDimension()) {
            return EnumActionResult.FAIL;
        }
        if (!player.field_71075_bZ.field_75098_d && !UtilItemModular.useEnderCharge(stack, 2, true)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.notenoughendercharge", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        ArrayList<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
        BlockPosEU posStart = this.getPosition(stack, true);
        BlockPosEU posEnd = this.getPosition(stack, false);
        Mode mode = Mode.getMode(stack);
        if (mode == Mode.CUBE) {
            this.getBlockPositionsCube(stack, world, positions, posStart, posEnd);
        } else if (mode == Mode.WALLS) {
            this.getBlockPositionsWalls(stack, world, positions, posStart, posEnd);
        } else {
            if (mode == Mode.COPY) {
                return this.copyAreaToTemplate(stack, world, player, posStart, posEnd);
            }
            if (mode == Mode.PASTE) {
                return this.pasteAreaIntoWorld(stack, world, player, posStart);
            }
            if (mode == Mode.DELETE) {
                return this.deleteArea(stack, world, player, posStart, posEnd);
            }
            if (mode == Mode.MOVE_DST) {
                return this.moveArea(stack, world, player, posStart, posEnd);
            }
            if (mode == Mode.MOVE_SRC) {
                return EnumActionResult.PASS;
            }
            if (mode == Mode.REPLACE) {
                return this.replaceBlocks(stack, world, player, posStart != null ? posStart : posTarget);
            }
            if (mode == Mode.REPLACE_3D) {
                return this.replaceBlocks3D(stack, world, player);
            }
            if (mode == Mode.STACK) {
                return this.stackArea(stack, world, player, posStart, posEnd);
            }
            this.getBlockPositions(stack, world, player, positions, posStart != null ? posStart : posTarget);
        }
        if (positions.size() <= 60) {
            for (int i = 0; i < positions.size(); ++i) {
                this.placeBlockToPosition(stack, world, player, (BlockPosStateDist)positions.get(i));
            }
            BlockPosEU pos = this.getPosition(stack, true);
            if (pos != null && mode != Mode.WALLS && mode != Mode.CUBE && mode != Mode.REPLACE && WandOption.MOVE_POSITION.isEnabled(stack, mode)) {
                this.setPosition(pos.offset(pos.getFacing()), true, stack, player);
            }
        } else {
            UUID wandUUID = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
            TaskBuildersWand task = new TaskBuildersWand(world, wandUUID, positions, Configs.buildersWandBlocksPerTick);
            PlayerTaskScheduler.getInstance().addTask(player, task, 1);
        }
        return EnumActionResult.SUCCESS;
    }

    public static boolean hasEnoughCharge(ItemStack stack, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        return UtilItemModular.useEnderCharge(stack, 2, true);
    }

    public boolean placeBlockToPosition(ItemStack wandStack, World world, EntityPlayer player, BlockPosStateDist posStateDist) {
        BlockInfo blockInfo = this.getSelectionIndex(wandStack) == -2 ? this.getBlockInfoForAdjacentBlock(world, posStateDist.toBlockPos(), posStateDist.getFacing()) : posStateDist.blockInfo;
        if (blockInfo == null || blockInfo.block == Blocks.field_150350_a) {
            return false;
        }
        return this.placeBlockToPosition(wandStack, world, player, posStateDist.toBlockPos(), posStateDist.getFacing(), blockInfo.blockStateActual, 3, true, true);
    }

    public boolean placeBlockToPosition(ItemStack wandStack, World world, EntityPlayer player, BlockPos pos, EnumFacing side, IBlockState newState, int setBlockStateFlags, boolean requireItems, boolean dropItems) {
        if (newState.func_185904_a() == Material.field_151579_a || world.func_180495_p(pos) == newState || !player.field_71075_bZ.field_75098_d && !world.func_175660_a(player, pos)) {
            return false;
        }
        boolean replace = WandOption.REPLACE_EXISTING.isEnabled(wandStack);
        boolean isAir = world.func_175623_d(pos);
        if (player.field_71075_bZ.field_75098_d) {
            if (replace || isAir) {
                BlockUtils.setBlockStateWithPlaceSound(world, pos, newState, setBlockStateFlags);
                return true;
            }
            return false;
        }
        if (!(ItemBuildersWand.hasEnoughCharge(wandStack, player) && (isAir || replace && BlockUtils.canChangeBlock(world, pos, player, false, Configs.buildersWandMaxBlockHardness)))) {
            return false;
        }
        ItemStack targetStack = ItemStack.field_190927_a;
        Block blockNew = newState.func_177230_c();
        if (requireItems) {
            targetStack = ItemBuildersWand.getAndConsumeBuildItem(wandStack, world, pos, newState, player, true);
        }
        if (!requireItems || !targetStack.func_190926_b()) {
            if (replace && !isAir && player instanceof EntityPlayerMP) {
                if (dropItems) {
                    BlockUtils.breakBlockAsPlayer(world, pos, (EntityPlayerMP)player, wandStack);
                    if (!world.func_175623_d(pos)) {
                        return false;
                    }
                } else {
                    BlockUtils.setBlockToAirWithoutSpillingContents(world, pos, 2);
                }
            }
            if (!requireItems || BlockUtils.checkCanPlaceBlockAt(world, pos, side, blockNew)) {
                if (requireItems) {
                    ItemBuildersWand.getAndConsumeBuildItem(wandStack, world, pos, newState, player, false);
                }
                BlockUtils.setBlockStateWithPlaceSound(world, pos, newState, setBlockStateFlags);
                if (!player.field_71075_bZ.field_75098_d) {
                    UtilItemModular.useEnderCharge(wandStack, 2, false);
                }
                return true;
            }
        }
        return false;
    }

    public boolean replaceBlock(World world, EntityPlayer player, ItemStack stack, BlockPosStateDist posIn) {
        BlockPos pos = posIn.toBlockPos();
        if (this.canReplaceBlock(world, player, stack, posIn)) {
            BlockUtils.getDropAndSetToAir(world, player, pos, posIn.getFacing(), false);
            ItemBuildersWand wand = (ItemBuildersWand)stack.func_77973_b();
            return wand.placeBlockToPosition(stack, world, player, posIn);
        }
        return false;
    }

    private boolean canReplaceBlock(World world, EntityPlayer player, ItemStack stack, BlockPosStateDist posIn) {
        return player.field_71075_bZ.field_75098_d || ItemBuildersWand.hasEnoughCharge(stack, player) && BlockUtils.canChangeBlock(world, posIn.toBlockPos(), player, true, Configs.buildersWandMaxBlockHardness) && !ItemBuildersWand.getAndConsumeBuildItem(stack, world, posIn.toBlockPos(), posIn.blockInfo.blockState, player, true).func_190926_b();
    }

    public static ItemStack getAndConsumeBuildItem(ItemStack wandStack, World world, BlockPos pos, IBlockState newState, EntityPlayer player, boolean simulate) {
        ItemStack templateStack = BlockUtils.getPickBlockItemStack(world, pos, newState, player, EnumFacing.UP);
        if (templateStack.func_190926_b()) {
            templateStack = BlockUtils.getSilkTouchDrop(newState);
        }
        if (templateStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        IItemHandler inv = UtilItemModular.getPlayerOrBoundInventoryWithItems(wandStack, templateStack, player);
        return inv != null ? InventoryUtils.extractMatchingItems(inv, templateStack, 1, simulate) : ItemStack.field_190927_a;
    }

    private void setSelectedFixedBlockType(ItemStack stack, EntityPlayer player, World world, BlockPos pos, boolean secondary) {
        int sel = this.getSelectionIndex(stack, secondary);
        if (sel < 0) {
            return;
        }
        String tagName = secondary ? "Blocks2" : TAG_NAME_BLOCKS;
        NBTTagCompound blocksTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, tagName, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(blocksTag, TAG_NAME_BLOCK_PRE + sel, true);
        this.setSelectedFixedBlockType(tag, player, world, pos);
    }

    private void setSelectedFixedBlockType(NBTTagCompound tag, EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        tag.func_74778_a("BlockName", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)state.func_177230_c()).toString());
        tag.func_74774_a("BlockMeta", (byte)state.func_177230_c().func_176201_c(state));
        ItemStack stackTmp = state.func_177230_c().getPickBlock(state, EntityUtils.getRayTraceFromPlayer(world, player, false), world, pos, player);
        int itemMeta = !stackTmp.func_190926_b() ? stackTmp.func_77960_j() : 0;
        tag.func_74777_a("ItemMeta", (short)itemMeta);
    }

    public BlockInfo getSelectedFixedBlockType(ItemStack stack) {
        return this.getSelectedFixedBlockType(stack, false);
    }

    public BlockInfo getSelectedFixedBlockType(ItemStack stack, boolean secondary) {
        int sel = this.getSelectionIndex(stack, secondary);
        if (sel < 0) {
            return null;
        }
        String tagName = secondary ? "Blocks2" : TAG_NAME_BLOCKS;
        NBTTagCompound blocksTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, tagName, false);
        NBTTagCompound tag = NBTUtils.getCompoundTag(blocksTag, TAG_NAME_BLOCK_PRE + sel, false);
        if (tag != null && tag.func_150297_b("BlockName", 8)) {
            return new BlockInfo(new ResourceLocation(tag.func_74779_i("BlockName")), (int)tag.func_74771_c("BlockMeta"), (int)tag.func_74765_d("ItemMeta"));
        }
        return null;
    }

    public int getSelectionIndex(ItemStack stack) {
        return this.getSelectionIndex(stack, false);
    }

    public int getSelectionIndex(ItemStack stack, boolean secondary) {
        NBTTagCompound configsTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(configsTag, TAG_NAME_CONFIG_PRE + Mode.getMode(stack).getName(), true);
        return tag.func_74771_c(secondary ? "SelBlock2" : TAG_NAME_BLOCK_SEL);
    }

    private void changeSelectionIndex(ItemStack stack, boolean reverse) {
        Mode mode = Mode.getMode(stack);
        NBTTagCompound tag = this.getModeTag(stack, mode);
        int min = mode.isAreaMode() || mode == Mode.REPLACE ? 0 : -2;
        NBTUtils.cycleByteValue(tag, TAG_NAME_BLOCK_SEL, min, 15, reverse);
    }

    private void changeSecondarySelectionIndex(ItemStack stack, boolean reverse) {
        NBTUtils.cycleByteValue(this.getModeTag(stack, Mode.getMode(stack)), "SelBlock2", 0, 15, reverse);
    }

    private void toggleMirror(ItemStack stack, Mode mode, EntityPlayer player) {
        Mirror mirror;
        Mirror mirror2 = mirror = player.func_174811_aO().func_176740_k() == EnumFacing.Axis.Z ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        if (mirror == this.getMirror(stack) && this.isMirrored(stack)) {
            mirror = Mirror.NONE;
        }
        this.setMirror(stack, mode, mirror);
    }

    private void setMirror(ItemStack stack, Mode mode, Mirror mirror) {
        int sel = this.getSelectionIndex(stack);
        NBTTagCompound tag = this.getModeTag(stack, mode);
        tag.func_74774_a("Mirror_" + sel, (byte)mirror.ordinal());
        tag.func_74757_a("IsMirrored_" + sel, mirror != Mirror.NONE);
    }

    public boolean isMirrored(ItemStack stack) {
        int sel = this.getSelectionIndex(stack);
        return this.getModeTag(stack, Mode.getMode(stack)).func_74767_n("IsMirrored_" + sel);
    }

    public Mirror getMirror(ItemStack stack) {
        return this.getMirror(stack, Mode.getMode(stack));
    }

    public Mirror getMirror(ItemStack stack, Mode mode) {
        int sel = this.getSelectionIndex(stack);
        NBTTagCompound tag = this.getModeTag(stack, mode);
        if (tag.func_74767_n("IsMirrored_" + sel) && tag.func_150297_b("Mirror_" + sel, 1)) {
            return Mirror.values()[tag.func_74771_c("Mirror_" + sel) % Mirror.values().length];
        }
        return Mirror.NONE;
    }

    public boolean isAreaFlipped(ItemStack stack) {
        return this.getModeTag(stack, Mode.getMode(stack)).func_74767_n("Flip");
    }

    private void toggleAreaFlipped(ItemStack stack, EntityPlayer player) {
        NBTTagCompound tag = this.getModeTag(stack, Mode.getMode(stack));
        EnumFacing facing = EntityUtils.getClosestLookingDirection((Entity)player);
        tag.func_74774_a("FlipAxis", (byte)facing.func_176745_a());
        tag.func_74757_a("Flip", !tag.func_74767_n("Flip"));
    }

    public EnumFacing getAreaFlipAxis(ItemStack stack, EnumFacing defaultFlipAxis) {
        NBTTagCompound tag = this.getModeTag(stack, Mode.getMode(stack));
        if (tag.func_150297_b("FlipAxis", 1)) {
            return EnumFacing.func_82600_a((int)tag.func_74771_c("FlipAxis"));
        }
        return defaultFlipAxis;
    }

    private EnumFacing getAxisRight(ItemStack stack, BlockPosEU pos) {
        EnumFacing face = pos.getFacing();
        EnumFacing axisRight = BlockPosEU.getRotation(face, EnumFacing.DOWN);
        if (face == EnumFacing.UP) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
        } else if (face == EnumFacing.DOWN) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
        }
        if (this.isAreaFlipped(stack)) {
            EnumFacing flipAxis = this.getAreaFlipAxis(stack, face);
            axisRight = BlockPosEU.getRotation(axisRight, flipAxis);
        }
        return axisRight;
    }

    private EnumFacing getAxisUp(ItemStack stack, BlockPosEU pos) {
        EnumFacing face = pos.getFacing();
        EnumFacing axisRight = BlockPosEU.getRotation(face, EnumFacing.DOWN);
        EnumFacing axisUp = BlockPosEU.getRotation(face, axisRight);
        if (face == EnumFacing.UP) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
            axisUp = BlockPosEU.getRotation(face, axisRight);
        } else if (face == EnumFacing.DOWN) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
            axisUp = BlockPosEU.getRotation(face, axisRight);
        }
        if (this.isAreaFlipped(stack)) {
            EnumFacing flipAxis = this.getAreaFlipAxis(stack, face);
            axisUp = BlockPosEU.getRotation(axisUp, flipAxis);
        }
        return axisUp;
    }

    private void changeAreaDimensions(EntityPlayer player, ItemStack stack, boolean reverse) {
        EnumFacing lookDir;
        EnumFacing faceAxisFlipped;
        Mode mode = Mode.getMode(stack);
        BlockPosEU pos = this.getPosition(stack, true);
        if (pos == null || mode == Mode.PASTE || mode == Mode.MOVE_DST) {
            return;
        }
        int amount = reverse ? 1 : -1;
        NBTTagCompound modeTag = this.getModeTag(stack, mode);
        if (mode == Mode.STACK) {
            Area3D area = Area3D.getAreaFromNBT(this.getAreaTag(stack));
            EnumFacing lookDir2 = EntityUtils.getClosestLookingDirection((Entity)player);
            if (Math.abs(player.field_70125_A) > 40.0f) {
                lookDir2 = EntityUtils.getVerticalLookingDirection((Entity)player);
            }
            area.adjustArea(lookDir2, amount);
            area.writeToNBT(this.getAreaTag(stack));
            return;
        }
        Area area = new Area(modeTag);
        if (mode == Mode.COLUMN) {
            area.adjustFromPlanarizedFacing(EnumFacing.EAST, amount, EnumFacing.UP, EnumFacing.EAST);
            area.writeToNBT(modeTag);
            return;
        }
        EnumFacing faceAxis = pos.getFacing();
        EnumFacing axisRight = this.getAxisRight(stack, pos);
        EnumFacing axisUp = this.getAxisUp(stack, pos);
        boolean isFlipped = this.isAreaFlipped(stack);
        EnumFacing flipAxis = this.getAreaFlipAxis(stack, faceAxis);
        EnumFacing enumFacing = faceAxisFlipped = isFlipped ? BlockPosEU.getRotation(faceAxis, flipAxis) : faceAxis;
        if (faceAxisFlipped == EnumFacing.UP || faceAxisFlipped == EnumFacing.DOWN) {
            lookDir = EntityUtils.getHorizontalLookingDirection((Entity)player);
        } else {
            EntityUtils.LeftRight leftRight;
            lookDir = EntityUtils.getClosestLookingDirection((Entity)player);
            lookDir = Math.abs(player.field_70125_A) > 20.0f && (lookDir.func_176740_k() == faceAxisFlipped.func_176740_k() || lookDir.func_176740_k() == EnumFacing.Axis.Y) ? EntityUtils.getVerticalLookingDirection((Entity)player) : ((leftRight = EntityUtils.getLookLeftRight((Entity)player, faceAxisFlipped)) == EntityUtils.LeftRight.RIGHT ? BlockPosEU.getRotation(faceAxisFlipped, EnumFacing.DOWN) : BlockPosEU.getRotation(faceAxisFlipped, EnumFacing.UP));
        }
        area.adjustFromPlanarizedFacing(lookDir, amount, axisUp, axisRight);
        area.writeToNBT(modeTag);
    }

    private void moveEndPosition(ItemStack stack, EntityPlayer player, boolean reverse) {
        EnumFacing direction = EntityUtils.getClosestLookingDirection((Entity)player);
        Mode mode = Mode.getMode(stack);
        BlockPosEU posStart = mode == Mode.CUBE || mode == Mode.WALLS ? this.getPosition(stack, mode, true) : this.getPerTemplateAreaCorner(stack, mode, true);
        BlockPosEU posEnd = this.getPosition(stack, mode, false);
        if (posEnd == null) {
            posEnd = posStart;
        }
        if (posStart != null && posEnd != null) {
            int v = reverse ? 1 : -1;
            posEnd = posEnd.add(direction.func_82601_c() * v, direction.func_96559_d() * v, direction.func_82599_e() * v);
            if (mode == Mode.WALLS || mode == Mode.CUBE) {
                this.setPosition(posEnd, false, stack, player);
            } else {
                this.setPerTemplateAreaCorner(posEnd, mode, false, stack, player);
                this.setAreaFacing(stack, mode, PositionUtils.getFacingFromPositions(posStart, posEnd));
                this.setMirror(stack, mode, Mirror.NONE);
            }
        }
    }

    private List<BlockPosStateDist> getPositionsOnPlane(ItemStack stack, Mode mode, World world, BlockPosEU posStart, EnumFacing axisRight, EnumFacing axisUp) {
        BlockPosEU pos = posStart;
        Area area = new Area(this.getModeTag(stack, mode));
        BlockPos pos1 = posStart.toBlockPos().func_177967_a(axisRight, -area.rNegH).func_177967_a(axisUp, -area.rNegV);
        BlockPos pos2 = posStart.toBlockPos().func_177967_a(axisRight, area.rPosH).func_177967_a(axisUp, area.rPosV);
        BlockPos posMin = PositionUtils.getMinCorner(pos1, pos2);
        BlockPos posMax = PositionUtils.getMaxCorner(pos1, pos2);
        ArrayList<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
        ArrayList<BlockPosEU> branches = new ArrayList<BlockPosEU>();
        HashSet<BlockPosEU> visited = new HashSet<BlockPosEU>();
        boolean continueThrough = mode != Mode.EXTEND_CONTINUOUS && WandOption.CONTINUE_THROUGH.isEnabled(stack, mode);
        boolean diagonals = mode == Mode.EXTEND_CONTINUOUS && WandOption.ALLOW_DIAGONALS.isEnabled(stack, mode);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, posStart.offset(posStart.getFacing(), -1).toBlockPos());
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        int blockType = this.getSelectionIndex(stack);
        int branchIndex = 0;
        BlockPosEU nextPos = null;
        for (int counter = 0; counter <= 16641; ++counter) {
            nextPos = this.checkPositionOnPlane(mode, world, pos, posMin, posMax, visited, branches, positions, continueThrough, diagonals, blockType, biTarget, biBound);
            if (nextPos == null) {
                if (branchIndex >= branches.size()) break;
                pos = (BlockPosEU)branches.get(branchIndex);
                ++branchIndex;
                continue;
            }
            pos = nextPos;
        }
        return positions;
    }

    private BlockPosEU checkPositionOnPlane(Mode mode, World world, BlockPosEU posIn, BlockPos posMin, BlockPos posMax, Set<BlockPosEU> visited, List<BlockPosEU> branches, List<BlockPosStateDist> positions, boolean continueThrough, boolean diagonals, int blockType, BlockInfo biTarget, BlockInfo biBound) {
        BlockPos posTmp = posIn.toBlockPos();
        BlockPosEU continueTo = null;
        int sides = 0;
        if (visited.contains(posIn) || !PositionUtils.isPositionInsideArea(posIn, posMin, posMax)) {
            return null;
        }
        if (world.func_180495_p(posTmp).func_177230_c().func_176200_f((IBlockAccess)world, posTmp)) {
            if (mode == Mode.EXTEND_AREA || mode == Mode.EXTEND_CONTINUOUS) {
                BlockPos posTgt = posTmp.func_177967_a(posIn.getFacing(), -1);
                IBlockState state = world.func_180495_p(posTgt);
                Block block = state.func_177230_c();
                int meta = block.func_176201_c(state);
                if (!block.isAir(state, (IBlockAccess)world, posTgt) && !state.func_185904_a().func_76224_d() && (blockType == -2 || blockType >= 0 && biBound != null || biTarget != null && biTarget.block == block && biTarget.blockMeta == meta)) {
                    positions.add(new BlockPosStateDist(posIn, this.getBlockInfoForBlockType(world, posTmp, posIn.getFacing(), blockType, biTarget, biBound)));
                } else if (mode == Mode.EXTEND_CONTINUOUS) {
                    return null;
                }
            } else {
                positions.add(new BlockPosStateDist(posIn, this.getBlockInfoForBlockType(world, posTmp, posIn.getFacing(), blockType, biTarget, biBound)));
            }
        } else if (!continueThrough) {
            return null;
        }
        visited.add(posIn);
        for (BlockPosEU pos : PositionUtils.getAdjacentPositions(posIn, posIn.getFacing(), diagonals)) {
            if (visited.contains(pos) || !PositionUtils.isPositionInsideArea(pos, posMin, posMax) || !world.func_175623_d(pos.toBlockPos()) && !continueThrough) continue;
            if (!visited.contains(pos)) {
                if (sides == 0) {
                    continueTo = pos;
                } else if (!branches.contains(pos)) {
                    branches.add(pos);
                }
            }
            ++sides;
        }
        return continueTo;
    }

    private List<BlockPosStateDist> getPositionsOnCircle(ItemStack stack, World world, BlockPosEU posCenter, EnumFacing axisRight, EnumFacing axisUp) {
        int counter;
        int radius = (ItemBuildersWand)this.new Area((NBTTagCompound)this.getModeTag((ItemStack)stack, (Mode)Mode.CIRCLE)).rPosH;
        ArrayList<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
        ArrayList<BlockPos> branches = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        boolean continueThrough = WandOption.CONTINUE_THROUGH.isEnabled(stack, Mode.CIRCLE);
        boolean diagonals = WandOption.ALLOW_DIAGONALS.isEnabled(stack, Mode.CIRCLE);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, posCenter.offset(posCenter.getFacing(), -1).toBlockPos());
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        int blockType = this.getSelectionIndex(stack);
        if (radius < 1) {
            positions.add(new BlockPosStateDist(posCenter, this.getBlockInfoForAdjacentBlock(world, posCenter.toBlockPos(), posCenter.getFacing())));
            return positions;
        }
        int branchIndex = 0;
        BlockPos nextPos = null;
        BlockPos pos = null;
        for (counter = 0; counter <= 16641; ++counter) {
            nextPos = this.checkCirclePositionIgnoringSide(world, pos, visited, branches, positions, continueThrough, diagonals, blockType, biTarget, biBound);
            if (nextPos == null) {
                if (branchIndex >= branches.size()) break;
                pos = (BlockPos)branches.get(branchIndex);
                ++branchIndex;
                continue;
            }
            pos = nextPos;
        }
        System.out.printf("counter: %d\n", counter);
        return positions;
    }

    private BlockPos checkCirclePositionIgnoringSide(World world, BlockPos pos, Set<BlockPos> visited, List<BlockPos> branches, List<BlockPosStateDist> positions, boolean continueThrough, boolean diagonals, int blockType, BlockInfo biTarget, BlockInfo biBound) {
        return null;
    }

    private List<BlockPosStateDist> getReplacePositions(ItemStack stack, World world, BlockPosEU posStart, EnumFacing axisRight, EnumFacing axisUp) {
        Area area = new Area(this.getModeTag(stack, Mode.REPLACE));
        BlockPos pos1 = posStart.toBlockPos().func_177967_a(axisRight, -area.rNegH).func_177967_a(axisUp, -area.rNegV);
        BlockPos pos2 = posStart.toBlockPos().func_177967_a(axisRight, area.rPosH).func_177967_a(axisUp, area.rPosV);
        BlockPos posMin = PositionUtils.getMinCorner(pos1, pos2);
        BlockPos posMax = PositionUtils.getMaxCorner(pos1, pos2);
        ArrayList<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
        ArrayList<BlockPos> branches = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        boolean diagonals = WandOption.ALLOW_DIAGONALS.isEnabled(stack, Mode.REPLACE);
        BlockPos pos = posStart.toBlockPos();
        BlockInfo biTarget = BlockInfo.getBlockInfo(world, pos);
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        if (biTarget == null || biBound == null) {
            return positions;
        }
        int branchIndex = 0;
        BlockPos nextPos = null;
        for (int counter = 0; counter <= 16641; ++counter) {
            nextPos = this.checkReplacePositionIgnoringSide(world, pos, posStart.getFacing(), posMin, posMax, visited, branches, positions, diagonals, biTarget, biBound);
            if (nextPos == null) {
                if (branchIndex >= branches.size()) break;
                pos = (BlockPos)branches.get(branchIndex);
                ++branchIndex;
                continue;
            }
            pos = nextPos;
        }
        return positions;
    }

    private BlockPos checkReplacePositionIgnoringSide(World world, BlockPos posIn, EnumFacing side, BlockPos posMin, BlockPos posMax, Set<BlockPos> visited, List<BlockPos> branches, List<BlockPosStateDist> positions, boolean diagonals, BlockInfo biTarget, BlockInfo biBound) {
        BlockPos pos = posIn;
        BlockPos continueTo = null;
        int sides = 0;
        if (visited.contains(pos) || !PositionUtils.isPositionInsideArea(pos, posMin, posMax)) {
            return null;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state == biTarget.blockState) {
            BlockPos posAdj = pos.func_177972_a(side);
            IBlockState stateAdj = world.func_180495_p(posAdj);
            Block blockAdj = stateAdj.func_177230_c();
            if (!blockAdj.isAir(stateAdj, (IBlockAccess)world, posAdj) && stateAdj.isSideSolid((IBlockAccess)world, posAdj, side.func_176734_d())) {
                return null;
            }
        } else {
            return null;
        }
        positions.add(new BlockPosStateDist(posIn, world.field_73011_w.getDimension(), side, biBound));
        visited.add(pos);
        for (BlockPos posTmp : PositionUtils.getAdjacentPositions(pos, side, diagonals)) {
            if (visited.contains(posTmp) || !PositionUtils.isPositionInsideArea(posTmp, posMin, posMax) || world.func_180495_p(posTmp) != biTarget.blockState) continue;
            if (!visited.contains(posTmp)) {
                if (sides == 0) {
                    continueTo = posTmp;
                } else if (!branches.contains(posTmp)) {
                    branches.add(posTmp);
                }
            }
            ++sides;
        }
        return continueTo;
    }

    private BlockInfo getBlockInfoForAdjacentBlock(World world, BlockPos pos, EnumFacing side) {
        return BlockInfo.getBlockInfo(world, pos.func_177967_a(side, -1));
    }

    private BlockInfo getBlockInfoForTargeted(ItemStack stack, World world, BlockPos pos) {
        int blockType = this.getSelectionIndex(stack);
        if (blockType == -1 || blockType == -2) {
            return BlockInfo.getBlockInfo(world, pos);
        }
        if (blockType >= 0) {
            return this.getSelectedFixedBlockType(stack);
        }
        return null;
    }

    private BlockInfo getBlockInfoForBlockType(World world, BlockPos pos, EnumFacing side, int blockType, BlockInfo biTarget, BlockInfo biBound) {
        if (blockType == -1) {
            return biTarget;
        }
        if (blockType == -2) {
            return this.getBlockInfoForAdjacentBlock(world, pos, side);
        }
        if (blockType >= 0) {
            return biBound;
        }
        return null;
    }

    public void getBlockPositions(ItemStack stack, World world, EntityPlayer player, List<BlockPosStateDist> positions, BlockPosEU center) {
        BlockPosEU flippedCenter = center;
        EnumFacing side = center.getFacing();
        EnumFacing axisRight = BlockPosEU.getRotation(side, EnumFacing.DOWN);
        EnumFacing axisUp = BlockPosEU.getRotation(side, axisRight);
        if (side == EnumFacing.UP) {
            axisRight = BlockPosEU.getRotation(side, EnumFacing.SOUTH);
            axisUp = BlockPosEU.getRotation(side, axisRight);
        } else if (side == EnumFacing.DOWN) {
            axisRight = BlockPosEU.getRotation(side, EnumFacing.SOUTH);
            axisUp = BlockPosEU.getRotation(side, axisRight);
        }
        if (this.isAreaFlipped(stack)) {
            EnumFacing flipAxis = this.getAreaFlipAxis(stack, side);
            axisRight = BlockPosEU.getRotation(axisRight, flipAxis);
            axisUp = BlockPosEU.getRotation(axisUp, flipAxis);
            if (flipAxis.func_176740_k() != center.getFacing().func_176740_k()) {
                flippedCenter = new BlockPosEU(center.toBlockPos(), center.getDimension(), BlockPosEU.getRotation(center.getFacing(), flipAxis));
            }
        }
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, center.offset(side, -1).toBlockPos());
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        int blockType = this.getSelectionIndex(stack);
        Mode mode = Mode.getMode(stack);
        Area area = new Area(this.getModeTag(stack, mode));
        int dim = world.field_73011_w.getDimension();
        boolean continueThrough = WandOption.CONTINUE_THROUGH.isEnabled(stack, mode);
        block0 : switch (mode) {
            case COLUMN: {
                for (int i = 0; i <= area.rPosH; ++i) {
                    BlockPosEU posTmp = center.offset(side, i);
                    BlockPos pos = posTmp.toBlockPos();
                    if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                        positions.add(new BlockPosStateDist(posTmp, biTarget));
                        continue;
                    }
                    if (!continueThrough) break block0;
                }
                break;
            }
            case LINE: {
                BlockPos posTmp;
                int i;
                for (i = 0; i <= area.rPosH; ++i) {
                    posTmp = center.offset(axisRight, i).toBlockPos();
                    if (world.func_180495_p(posTmp).func_177230_c().func_176200_f((IBlockAccess)world, posTmp)) {
                        positions.add(new BlockPosStateDist(posTmp, dim, side, this.getBlockInfoForBlockType(world, posTmp, side, blockType, biTarget, biBound)));
                        continue;
                    }
                    if (!continueThrough) break;
                }
                i = -1;
                while (-i <= area.rNegH) {
                    posTmp = center.offset(axisRight, i).toBlockPos();
                    if (world.func_180495_p(posTmp).func_177230_c().func_176200_f((IBlockAccess)world, posTmp)) {
                        positions.add(new BlockPosStateDist(posTmp, dim, side, this.getBlockInfoForBlockType(world, posTmp, side, blockType, biTarget, biBound)));
                    } else if (!continueThrough) break block0;
                    --i;
                }
                break;
            }
            case CIRCLE: {
                positions.addAll(this.getPositionsOnCircle(stack, world, flippedCenter, axisRight, axisUp));
                break;
            }
            case PLANE: 
            case EXTEND_AREA: 
            case EXTEND_CONTINUOUS: {
                positions.addAll(this.getPositionsOnPlane(stack, mode, world, flippedCenter, axisRight, axisUp));
                break;
            }
            case REPLACE: {
                if (WandOption.REPLACE_MODE_IS_AREA.isEnabled(stack, Mode.REPLACE)) {
                    positions.addAll(this.getReplacePositions(stack, world, center, axisRight, axisUp));
                    break;
                }
                positions.add(new BlockPosStateDist(center, biBound));
                break;
            }
        }
    }

    public void getBlockPositionsWalls(ItemStack stack, World world, List<BlockPosStateDist> positions, BlockPosEU pos1, BlockPosEU pos2) {
        int z;
        int z2;
        int y;
        int x;
        if (pos1 == null || pos2 == null) {
            return;
        }
        int startX = Math.min(pos1.getX(), pos2.getX());
        int startY = Math.min(pos1.getY(), pos2.getY());
        int startZ = Math.min(pos1.getZ(), pos2.getZ());
        int endX = Math.max(pos1.getX(), pos2.getX());
        int endY = Math.max(pos1.getY(), pos2.getY());
        int endZ = Math.max(pos1.getZ(), pos2.getZ());
        if (endX - startX > 128 || endY - startY > 128 || endZ - startZ > 128) {
            return;
        }
        BlockPosEU targeted = pos1.offset(pos1.getFacing(), -1);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, targeted.toBlockPos());
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        int blockType = this.getSelectionIndex(stack);
        int dim = world.field_73011_w.getDimension();
        for (x = startX; x <= endX; ++x) {
            for (y = startY; y <= endY; ++y) {
                positions.add(new BlockPosStateDist(x, y, startZ, dim, targeted.getFacing(), this.getBlockInfoForBlockType(world, new BlockPos(x, y, startZ), targeted.getFacing(), blockType, biTarget, biBound)));
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (y = startY; y <= endY; ++y) {
                positions.add(new BlockPosStateDist(x, y, endZ, dim, targeted.getFacing(), this.getBlockInfoForBlockType(world, new BlockPos(x, y, endZ), targeted.getFacing(), blockType, biTarget, biBound)));
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (z2 = startZ; z2 <= endZ; ++z2) {
                positions.add(new BlockPosStateDist(x, startY, z2, dim, targeted.getFacing(), this.getBlockInfoForBlockType(world, new BlockPos(x, startY, z2), targeted.getFacing(), blockType, biTarget, biBound)));
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (z2 = startZ; z2 <= endZ; ++z2) {
                positions.add(new BlockPosStateDist(x, endY, z2, dim, targeted.getFacing(), this.getBlockInfoForBlockType(world, new BlockPos(x, endY, z2), targeted.getFacing(), blockType, biTarget, biBound)));
            }
        }
        for (z = startZ + 1; z <= endZ - 1; ++z) {
            for (y = startY + 1; y <= endY - 1; ++y) {
                positions.add(new BlockPosStateDist(startX, y, z, dim, targeted.getFacing(), this.getBlockInfoForBlockType(world, new BlockPos(startX, y, z), targeted.getFacing(), blockType, biTarget, biBound)));
            }
        }
        for (z = startZ + 1; z <= endZ - 1; ++z) {
            for (y = startY + 1; y <= endY - 1; ++y) {
                positions.add(new BlockPosStateDist(endX, y, z, dim, targeted.getFacing(), this.getBlockInfoForBlockType(world, new BlockPos(endX, y, z), targeted.getFacing(), blockType, biTarget, biBound)));
            }
        }
    }

    private void getBlockPositionsCube(ItemStack stack, World world, List<BlockPosStateDist> positions, BlockPosEU pos1, BlockPosEU pos2) {
        if (pos1 == null || pos2 == null) {
            return;
        }
        int startX = Math.min(pos1.getX(), pos2.getX());
        int startY = Math.min(pos1.getY(), pos2.getY());
        int startZ = Math.min(pos1.getZ(), pos2.getZ());
        int endX = Math.max(pos1.getX(), pos2.getX());
        int endY = Math.max(pos1.getY(), pos2.getY());
        int endZ = Math.max(pos1.getZ(), pos2.getZ());
        if (endX - startX > 128 || endY - startY > 128 || endZ - startZ > 128) {
            return;
        }
        BlockPosEU targeted = pos1.offset(pos1.getFacing(), -1);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, targeted.toBlockPos());
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        int blockType = this.getSelectionIndex(stack);
        int dim = world.field_73011_w.getDimension();
        for (int y = startY; y <= endY; ++y) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int x = startX; x <= endX; ++x) {
                    positions.add(new BlockPosStateDist(x, y, z, dim, pos1.getFacing(), this.getBlockInfoForBlockType(world, new BlockPos(x, y, z), targeted.getFacing(), blockType, biTarget, biBound)));
                }
            }
        }
    }

    private EnumActionResult copyAreaToTemplate(ItemStack stack, World world, EntityPlayer player, BlockPosEU posStartIn, BlockPosEU posEndIn) {
        if (!player.field_71075_bZ.field_75098_d && !Configs.buildersWandEnableCopyMode) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.featuredisabledinsurvivalmode", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        if (posStartIn == null || posEndIn == null) {
            return EnumActionResult.FAIL;
        }
        BlockPos posStart = posStartIn.toBlockPos();
        BlockPos endOffset = posEndIn.toBlockPos().func_177973_b((Vec3i)posStart);
        if (!this.isAreaWithinSizeLimit(endOffset, stack, player)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoolarge", new Object[]{this.getMaxAreaDimension(stack, player)}), true);
            return EnumActionResult.FAIL;
        }
        int dim = world.field_73011_w.getDimension();
        if (posEndIn.getDimension() != dim || !posStartIn.isWithinDistance((Entity)player, 160.0)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoofar", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        ResourceLocation templateLocation = this.getTemplateResource(stack, player);
        boolean success = this.saveAreaToTemplate(world, posStart, endOffset, templateLocation, this.getTemplateName(stack, Mode.COPY), player.func_70005_c_(), WandOption.CHISELS_AND_BITS_CROSSWORLD.isEnabled(stack));
        if (success) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areasavedtotemplate", new Object[]{this.getSelectionIndex(stack) + 1}), true);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.failedtosaveareatotemplate", new Object[0]), true);
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean saveAreaToTemplate(World world, BlockPos posStart, BlockPos endOffset, ResourceLocation templateLocation, String templateName, String author, boolean cbCrossWorld) {
        TemplateManagerEU templateManager = this.getTemplateManager();
        TemplateEnderUtilities template = templateManager.getTemplate(templateLocation);
        template.takeBlocksFromWorld(world, posStart, endOffset, true, cbCrossWorld);
        template.setAuthor(author);
        boolean success = templateManager.writeTemplate(templateLocation);
        TemplateMetadata templateMeta = templateManager.getTemplateMetadata(templateLocation);
        EnumFacing facing = PositionUtils.getFacingFromPositions(posStart, posStart.func_177971_a((Vec3i)endOffset));
        templateMeta.setValues(endOffset, facing, templateName, author);
        templateManager.writeTemplateMetadata(templateLocation);
        return success;
    }

    private EnumActionResult pasteAreaIntoWorld(ItemStack stack, World world, EntityPlayer player, BlockPosEU posStartIn) {
        if (posStartIn == null) {
            return EnumActionResult.FAIL;
        }
        if (!player.field_71075_bZ.field_75098_d && !Configs.buildersWandEnablePasteMode) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.featuredisabledinsurvivalmode", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        if (!posStartIn.isWithinDistance((Entity)player, 160.0)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoofar", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        TemplateMetadata templateMeta = this.getTemplateMetadata(stack, player);
        if (!this.isAreaWithinSizeLimit(templateMeta.getRelativeEndPosition(), stack, player)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoolarge", new Object[]{this.getMaxAreaDimension(stack, player)}), true);
            return EnumActionResult.FAIL;
        }
        PlacementSettings placement = this.getPasteModePlacement(stack, player);
        TemplateEnderUtilities template = this.getTemplate(world, player, stack, placement);
        if (player.field_71075_bZ.field_75098_d) {
            template.setReplaceMode(WandOption.REPLACE_EXISTING.isEnabled(stack, Mode.PASTE) ? TemplateEnderUtilities.ReplaceMode.EVERYTHING : TemplateEnderUtilities.ReplaceMode.NOTHING);
            template.addBlocksToWorld(world, posStartIn.toBlockPos());
        } else {
            template.setReplaceMode(WandOption.REPLACE_EXISTING.isEnabled(stack, Mode.PASTE) ? TemplateEnderUtilities.ReplaceMode.WITH_NON_AIR : TemplateEnderUtilities.ReplaceMode.NOTHING);
            UUID wandUUID = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
            TaskTemplatePlaceBlocks task = new TaskTemplatePlaceBlocks(template, posStartIn.toBlockPos(), world.field_73011_w.getDimension(), player.func_110124_au(), wandUUID, Configs.buildersWandBlocksPerTick);
            PlayerTaskScheduler.getInstance().addTask(player, task, 1);
        }
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult deleteArea(ItemStack stack, World world, EntityPlayer player, BlockPosEU posStartIn, BlockPosEU posEndIn) {
        if (posStartIn == null || posEndIn == null) {
            return EnumActionResult.PASS;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.creativeonly", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        this.deleteArea(stack, world, player, posStartIn.toBlockPos(), posEndIn.toBlockPos(), WandOption.AFFECT_ENTITIES.isEnabled(stack, Mode.DELETE));
        return EnumActionResult.SUCCESS;
    }

    private void deleteArea(ItemStack stack, World world, EntityPlayer player, BlockPos posStart, BlockPos posEnd, boolean removeEntities) {
        if (posStart == null || posEnd == null) {
            return;
        }
        if (player.func_174818_b(posStart) > 25600.0) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoofar", new Object[0]), true);
            return;
        }
        if (!this.isAreaWithinSizeLimit(posStart.func_177973_b((Vec3i)posEnd), stack, player)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoolarge", new Object[0]), true);
            return;
        }
        for (BlockPos.MutableBlockPos posMutable : BlockPos.func_177975_b((BlockPos)posStart, (BlockPos)posEnd)) {
            if (world.func_175623_d((BlockPos)posMutable)) continue;
            BlockUtils.setBlockToAirWithoutSpillingContents(world, (BlockPos)posMutable, 2);
        }
        BlockPos posMin = PositionUtils.getMinCorner(posStart, posEnd);
        BlockPos posMax = PositionUtils.getMaxCorner(posStart, posEnd).func_177982_a(1, 1, 1);
        StructureBoundingBox sbb = StructureBoundingBox.func_175899_a((int)posMin.func_177958_n(), (int)posMin.func_177956_o(), (int)posMin.func_177952_p(), (int)posMax.func_177958_n(), (int)posMax.func_177956_o(), (int)posMax.func_177952_p());
        world.func_175712_a(sbb, true);
        int count = 0;
        if (removeEntities) {
            int x1 = Math.min(posStart.func_177958_n(), posEnd.func_177958_n());
            int y1 = Math.min(posStart.func_177956_o(), posEnd.func_177956_o());
            int z1 = Math.min(posStart.func_177952_p(), posEnd.func_177952_p());
            int x2 = Math.max(posStart.func_177958_n(), posEnd.func_177958_n());
            int y2 = Math.max(posStart.func_177956_o(), posEnd.func_177956_o());
            int z2 = Math.max(posStart.func_177952_p(), posEnd.func_177952_p());
            AxisAlignedBB bb = new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)(x2 + 1), (double)(y2 + 1), (double)(z2 + 1));
            List entities = world.func_72839_b(null, bb);
            for (Entity entity : entities) {
                if (entity instanceof EntityPlayer && !(entity instanceof FakePlayer)) continue;
                entity.func_70106_y();
                ++count;
            }
            if (count > 0) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.killedentitieswithcount", new Object[]{count}), true);
            }
        }
    }

    private EnumActionResult moveArea(ItemStack stack, World world, EntityPlayer player, BlockPosEU posDst1EU, BlockPosEU posDst2EU) {
        if (!player.field_71075_bZ.field_75098_d && !Configs.buildersWandEnableMoveMode) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.featuredisabledinsurvivalmode", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        BlockPosEU posSrc1EU = this.getPosition(stack, Mode.MOVE_SRC, true);
        BlockPosEU posSrc2EU = this.getPosition(stack, Mode.MOVE_SRC, false);
        if (posSrc1EU == null || posSrc2EU == null || posDst1EU == null || posDst2EU == null) {
            return EnumActionResult.FAIL;
        }
        BlockPos posDst1 = posDst1EU.toBlockPos();
        BlockPos posDst2 = posDst2EU.toBlockPos();
        if (!(posSrc1EU.isWithinDistance((Entity)player, 160.0) && posSrc2EU.isWithinDistance((Entity)player, 160.0) && posDst1EU.isWithinDistance((Entity)player, 160.0) && posDst2EU.isWithinDistance((Entity)player, 160.0) && this.isAreaWithinSizeLimit(posDst2.func_177973_b((Vec3i)posDst1), stack, player))) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoolargeortoofar", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        BlockPos posSrc1 = posSrc1EU.toBlockPos();
        BlockPos posSrc2 = posSrc2EU.toBlockPos();
        EnumFacing origFacing = PositionUtils.getFacingFromPositions(posSrc1, posSrc2);
        EnumFacing areaFacing = this.getAreaFacing(stack, Mode.MOVE_DST);
        if (areaFacing == null) {
            areaFacing = origFacing;
        }
        Rotation rotation = PositionUtils.getRotation(origFacing, areaFacing);
        Mirror mirror = this.getMirror(stack, Mode.MOVE_DST);
        if (posSrc1.equals((Object)posDst1) && rotation == Rotation.NONE && mirror == Mirror.NONE) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.builderswand.areasarethesame", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        int id = this.getSelectionIndex(stack);
        UUID uuid = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
        String name = player.func_70005_c_();
        ResourceLocation rl = new ResourceLocation("enderutilities", "move_src_" + name + "_" + uuid.toString() + "_" + id);
        boolean success = this.saveAreaToTemplate(world, posSrc1, posSrc2.func_177973_b((Vec3i)posSrc1), rl, "Move source", name, false);
        if (!success) {
            return EnumActionResult.FAIL;
        }
        rl = new ResourceLocation("enderutilities", "move_dst_" + name + "_" + uuid.toString() + "_" + id);
        success = this.saveAreaToTemplate(world, posDst1, posDst2.func_177973_b((Vec3i)posDst1), rl, "Move destination", name, false);
        if (!success) {
            return EnumActionResult.FAIL;
        }
        if (player.field_71075_bZ.field_75098_d) {
            this.moveAreaImmediate(stack, world, player, posSrc1, posSrc2, posDst1, mirror, rotation);
        } else {
            UUID wandUUID = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
            TaskMoveArea task = new TaskMoveArea(world.field_73011_w.getDimension(), posSrc1, posSrc2, posDst1, rotation, mirror, wandUUID, Configs.buildersWandBlocksPerTick);
            PlayerTaskScheduler.getInstance().addTask(player, task, 1);
        }
        return EnumActionResult.SUCCESS;
    }

    private void moveAreaImmediate(ItemStack stack, World world, EntityPlayer player, BlockPos posSrc1, BlockPos posSrc2, BlockPos posDst1, Mirror mirror, Rotation rotation) {
        PlacementSettings placement = new PlacementSettings();
        placement.func_186214_a(mirror);
        placement.func_186220_a(rotation);
        placement.func_186222_a(false);
        placement.func_186225_a(Blocks.field_180401_cv);
        TemplateEnderUtilities.ReplaceMode replace = WandOption.REPLACE_EXISTING.isEnabled(stack, Mode.MOVE_DST) ? TemplateEnderUtilities.ReplaceMode.EVERYTHING : TemplateEnderUtilities.ReplaceMode.NOTHING;
        TemplateEnderUtilities template = new TemplateEnderUtilities(placement, replace);
        template.takeBlocksFromWorld(world, posSrc1, posSrc2.func_177973_b((Vec3i)posSrc1), true, false);
        this.deleteArea(stack, world, player, posSrc1, posSrc2, true);
        template.addBlocksToWorld(world, posDst1);
    }

    private EnumActionResult replaceBlocks(ItemStack stack, World world, EntityPlayer player, BlockPosEU center) {
        if (!player.field_71075_bZ.field_75098_d && !Configs.buildersWandEnableReplaceMode) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.featuredisabledinsurvivalmode", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        BlockInfo biBound = this.getSelectedFixedBlockType(stack);
        if (biBound == null || biBound.blockState == world.func_180495_p(center.toBlockPos())) {
            return EnumActionResult.FAIL;
        }
        ArrayList<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
        this.getBlockPositions(stack, world, player, positions, center);
        UUID wandUUID = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
        TaskReplaceBlocks task = new TaskReplaceBlocks(world, wandUUID, positions, Configs.buildersWandReplaceBlocksPerTick);
        PlayerTaskScheduler.getInstance().addTask(player, task, 1);
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult replaceBlocks3D(ItemStack stack, World world, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d && !Configs.buildersWandEnableReplace3DMode) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.featuredisabledinsurvivalmode", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        BlockPosEU pos1 = this.getPosition(stack, true);
        BlockPosEU pos2 = this.getPosition(stack, false);
        if (pos1 == null || pos2 == null) {
            return EnumActionResult.FAIL;
        }
        BlockInfo blockInfoTarget = this.getSelectedFixedBlockType(stack, true);
        BlockInfo blockInfoReplacement = this.getSelectedFixedBlockType(stack, false);
        if (blockInfoTarget != null && blockInfoReplacement != null) {
            UUID wandUUID = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
            TaskReplaceBlocks3D task = new TaskReplaceBlocks3D(world, wandUUID, pos1, pos2, blockInfoTarget.blockState, blockInfoReplacement, 5);
            PlayerTaskScheduler.getInstance().addTask(player, task, 1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private boolean isStackedAreaWithinLimits(BlockPos pos1, BlockPos pos2, BlockPos endPosRelative, Area3D area, EntityPlayer player) {
        int sx = Math.abs(endPosRelative.func_177958_n()) + 1;
        int sy = Math.abs(endPosRelative.func_177956_o()) + 1;
        int sz = Math.abs(endPosRelative.func_177952_p()) + 1;
        BlockPos posMin = PositionUtils.getMinCorner(pos1, pos2).func_177982_a(-area.getXNeg() * sx, -area.getYNeg() * sy, -area.getZNeg() * sz);
        BlockPos posMax = PositionUtils.getMaxCorner(pos1, pos2).func_177982_a(area.getXPos() * sx, area.getYPos() * sy, area.getZPos() * sz);
        int max = 160;
        return !(player.func_174818_b(posMin) > (double)(max * max)) && !(player.func_174818_b(posMax) > (double)(max * max));
    }

    private EnumActionResult stackArea(ItemStack stack, World world, EntityPlayer player, BlockPosEU pos1EU, BlockPosEU pos2EU) {
        if (!player.field_71075_bZ.field_75098_d && !Configs.buildersWandEnableStackMode) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.featuredisabledinsurvivalmode", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        if (pos1EU == null || pos2EU == null) {
            return EnumActionResult.FAIL;
        }
        int dim = world.field_73011_w.getDimension();
        BlockPos pos1 = pos1EU.toBlockPos();
        BlockPos pos2 = pos2EU.toBlockPos();
        BlockPos endPosRelative = pos2.func_177973_b((Vec3i)pos1);
        Area3D area = Area3D.getAreaFromNBT(this.getAreaTag(stack));
        if (pos1EU.getDimension() != dim || pos2EU.getDimension() != dim || !this.isStackedAreaWithinLimits(pos1, pos2, endPosRelative, area, player)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.areatoolargeortoofar", new Object[0]), true);
            return EnumActionResult.FAIL;
        }
        boolean takeEntities = player.field_71075_bZ.field_75098_d && WandOption.AFFECT_ENTITIES.isEnabled(stack);
        PlacementSettings placement = new PlacementSettings();
        placement.func_186222_a(!takeEntities);
        TemplateEnderUtilities.ReplaceMode replaceMode = WandOption.REPLACE_EXISTING.isEnabled(stack, Mode.STACK) ? TemplateEnderUtilities.ReplaceMode.WITH_NON_AIR : TemplateEnderUtilities.ReplaceMode.NOTHING;
        TemplateEnderUtilities template = new TemplateEnderUtilities(placement, replaceMode);
        template.takeBlocksFromWorld(world, pos1, pos2.func_177973_b((Vec3i)pos1), takeEntities, false);
        if (player.field_71075_bZ.field_75098_d) {
            this.stackAreaImmediate(world, pos1, endPosRelative, area, template);
        } else {
            UUID wandUUID = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
            TaskStackArea task = new TaskStackArea(world, wandUUID, pos1, endPosRelative, template, area, Configs.buildersWandBlocksPerTick);
            PlayerTaskScheduler.getInstance().addTask(player, task, 1);
        }
        return EnumActionResult.SUCCESS;
    }

    private void stackAreaImmediate(World world, BlockPos posOrig, BlockPos endPosRelative, Area3D area, TemplateEnderUtilities template) {
        int sx = Math.abs(endPosRelative.func_177958_n()) + 1;
        int sy = Math.abs(endPosRelative.func_177956_o()) + 1;
        int sz = Math.abs(endPosRelative.func_177952_p()) + 1;
        for (int y = -area.getYNeg(); y <= area.getYPos(); ++y) {
            for (int x = -area.getXNeg(); x <= area.getXPos(); ++x) {
                for (int z = -area.getZNeg(); z <= area.getZPos(); ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    template.addBlocksToWorld(world, posOrig.func_177982_a(x * sx, y * sy, z * sz));
                }
            }
        }
    }

    private void placeHelperBlock(EntityPlayer player) {
        BlockPos pos = PositionUtils.getPositionInfrontOfEntity((Entity)player);
        player.func_130014_f_().func_180501_a(pos, Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)), 3);
    }

    private int getMaxAreaDimension(ItemStack stack, EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d ? 256 : 64;
    }

    private boolean isAreaWithinSizeLimit(BlockPos size, ItemStack stack, EntityPlayer player) {
        int limit = this.getMaxAreaDimension(stack, player);
        return Math.abs(size.func_177958_n()) <= limit && Math.abs(size.func_177956_o()) <= limit && Math.abs(size.func_177952_p()) <= limit;
    }

    private TemplateEnderUtilities getTemplate(World world, EntityPlayer player, ItemStack stack, PlacementSettings placement) {
        TemplateManagerEU templateManager = this.getTemplateManager();
        ResourceLocation rl = this.getTemplateResource(stack, player);
        TemplateEnderUtilities template = templateManager.getTemplate(rl);
        template.setPlacementSettings(placement);
        return template;
    }

    private TemplateMetadata getTemplateMetadata(ItemStack stack, EntityPlayer player) {
        TemplateManagerEU templateManager = this.getTemplateManager();
        ResourceLocation rl = this.getTemplateResource(stack, player);
        TemplateMetadata templateMeta = templateManager.getTemplateMetadata(rl);
        return templateMeta;
    }

    public String getTemplateName(ItemStack stack, Mode mode) {
        NBTTagCompound nbt = this.getSelectedTemplateTag(stack, mode, false);
        if (nbt != null && nbt.func_74764_b("TemplateName")) {
            return nbt.func_74779_i("TemplateName");
        }
        return "N/A";
    }

    public void setTemplateName(ItemStack stack, EntityPlayer player, String name) {
        TemplateManagerEU templateManager = this.getTemplateManager();
        ResourceLocation rl = this.getTemplateResource(stack, player);
        TemplateMetadata meta = templateManager.getTemplateMetadata(rl);
        meta.setTemplateName(name);
        templateManager.writeTemplateMetadata(rl);
        this.setTemplateNameOnItem(stack, Mode.COPY, name);
        this.updateTemplateMetadata(stack, player);
    }

    public void setTemplateNameOnItem(ItemStack stack, Mode mode, String name) {
        NBTTagCompound nbt = this.getSelectedTemplateTag(stack, mode, true);
        nbt.func_74778_a("TemplateName", name);
    }

    private ResourceLocation getTemplateResource(ItemStack stack, EntityPlayer player) {
        int id = this.getSelectionIndex(stack);
        UUID uuid = NBTUtils.getUUIDFromItemStack(stack, WRAPPER_TAG_NAME, true);
        String name = NBTUtils.getOrCreateString(stack, WRAPPER_TAG_NAME, "player", player.func_70005_c_());
        return new ResourceLocation("enderutilities", name + "_" + uuid.toString() + "_" + id);
    }

    @Nullable
    private TemplateManagerEU getTemplateManager() {
        File saveDir = DimensionManager.getCurrentSaveRootDirectory();
        if (saveDir != null) {
            return new TemplateManagerEU(new File(new File(saveDir, "enderutilities"), this.name), (DataFixer)FMLCommonHandler.instance().getDataFixer());
        }
        return null;
    }

    @Nullable
    private NBTTagCompound getSelectedTemplateTag(ItemStack stack, Mode mode, boolean create) {
        int sel = this.getSelectionIndex(stack);
        NBTTagCompound tag = this.getModeTag(stack, mode);
        tag = NBTUtils.getCompoundTag(tag, "Templates_" + sel, create);
        return tag;
    }

    private void updateTemplateMetadata(ItemStack stack, EntityPlayer player) {
        TemplateManagerEU templateManager = this.getTemplateManager();
        ResourceLocation rl = this.getTemplateResource(stack, player);
        TemplateManagerEU.FileInfo info = templateManager.getTemplateInfo(rl);
        NBTTagCompound tag = this.getSelectedTemplateTag(stack, Mode.PASTE, true);
        if (tag.func_74763_f("Timestamp") != info.timestamp || tag.func_74763_f("FileSize") != info.fileSize) {
            TemplateMetadata meta = templateManager.getTemplateMetadata(rl);
            BlockPos size = meta.getRelativeEndPosition();
            tag.func_74772_a("TimeStamp", info.timestamp);
            tag.func_74772_a("FileSize", info.fileSize);
            tag.func_74768_a("endOffsetX", size.func_177958_n());
            tag.func_74768_a("endOffsetY", size.func_177956_o());
            tag.func_74768_a("endOffsetZ", size.func_177952_p());
            tag.func_74774_a("TemplateFacing", (byte)meta.getFacing().func_176745_a());
            tag.func_74778_a("TemplateName", meta.getTemplateName());
            this.setTemplateNameOnItem(stack, Mode.COPY, meta.getTemplateName());
        }
    }

    public EnumFacing getTemplateFacing(ItemStack stack) {
        NBTTagCompound tag = this.getSelectedTemplateTag(stack, Mode.PASTE, true);
        return EnumFacing.func_82600_a((int)tag.func_74771_c("TemplateFacing"));
    }

    public EnumFacing getAreaFacing(ItemStack stack, Mode mode) {
        NBTTagCompound tag = this.getSelectedTemplateTag(stack, mode, true);
        if (tag.func_150297_b("Rotation", 1)) {
            return EnumFacing.func_82600_a((int)tag.func_74771_c("Rotation"));
        }
        BlockPosEU posStart = this.getPerTemplateAreaCorner(stack, mode, true);
        BlockPosEU posEnd = this.getPerTemplateAreaCorner(stack, mode, false);
        if (posStart != null && posEnd != null) {
            return PositionUtils.getFacingFromPositions(posStart, posEnd);
        }
        return null;
    }

    private void setAreaFacing(ItemStack stack, Mode mode, EntityPlayer player) {
        this.setAreaFacing(stack, mode, player.func_174811_aO());
    }

    private void setAreaFacing(ItemStack stack, Mode mode, EnumFacing facing) {
        NBTTagCompound tag = this.getSelectedTemplateTag(stack, mode, true);
        tag.func_74774_a("Rotation", (byte)facing.func_176745_a());
    }

    private PlacementSettings getPasteModePlacement(ItemStack stack, EntityPlayer player) {
        EnumFacing facing = this.getTemplateFacing(stack);
        EnumFacing areaFacing = this.getAreaFacing(stack, Mode.PASTE);
        if (areaFacing == null) {
            areaFacing = facing;
        }
        Rotation rotation = PositionUtils.getRotation(facing, areaFacing);
        PlacementSettings placement = new PlacementSettings();
        boolean ignoreEntities = !player.field_71075_bZ.field_75098_d || !WandOption.AFFECT_ENTITIES.isEnabled(stack, Mode.PASTE);
        placement.func_186214_a(this.getMirror(stack));
        placement.func_186220_a(rotation);
        placement.func_186222_a(ignoreEntities);
        return placement;
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 0x10000000) {
            this.placeHelperBlock(player);
            return true;
        }
        Mode mode = Mode.getMode(stack);
        if (HotKeys.EnumKey.SCROLL.matches(key, 327680)) {
            if (mode == Mode.REPLACE_3D) {
                this.changeSecondarySelectionIndex(stack, HotKeys.EnumKey.keypressActionIsReversed(key));
                return true;
            }
            if (mode == Mode.STACK) {
                this.changeAreaDimensions(player, stack, HotKeys.EnumKey.keypressActionIsReversed(key));
                return true;
            }
        } else {
            if (HotKeys.EnumKey.SCROLL.matches(key, 262144)) {
                this.changeSelectionIndex(stack, HotKeys.EnumKey.keypressActionIsReversed(key));
                if (mode == Mode.PASTE) {
                    this.updateTemplateMetadata(stack, player);
                }
                return true;
            }
            if (HotKeys.EnumKey.SCROLL.matches(key, 65536)) {
                if (mode != Mode.PASTE && mode != Mode.MOVE_DST) {
                    if (mode.hasTwoPlacableCorners()) {
                        this.moveEndPosition(stack, player, HotKeys.EnumKey.keypressActionIsReversed(key));
                    } else {
                        this.changeAreaDimensions(player, stack, HotKeys.EnumKey.keypressActionIsReversed(key));
                    }
                    return true;
                }
            } else if (HotKeys.EnumKey.TOGGLE.matches(key, 65536)) {
                if (mode == Mode.REPLACE_3D) {
                    WandOption.BIND_MODE.toggle(stack, mode);
                    return true;
                }
                if (mode.isAreaMode()) {
                    this.toggleMirror(stack, mode, player);
                    return true;
                }
                if (mode != Mode.WALLS || mode != Mode.CUBE) {
                    WandOption.MOVE_POSITION.toggle(stack, mode);
                    return true;
                }
            } else {
                if (HotKeys.EnumKey.TOGGLE.matches(key, 131072, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 131072)) {
                    Mode.cycleMode(stack, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key), player);
                    if (Mode.getMode(stack) == Mode.PASTE) {
                        this.updateTemplateMetadata(stack, player);
                    }
                    return true;
                }
                if (HotKeys.EnumKey.SCROLL.matches(key, 458752)) {
                    this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, HotKeys.EnumKey.keypressActionIsReversed(key));
                    return true;
                }
                if (HotKeys.EnumKey.TOGGLE.matches(key, 458752)) {
                    if (mode == Mode.COPY) {
                        WandOption.CHISELS_AND_BITS_CROSSWORLD.toggle(stack, mode);
                        return true;
                    }
                } else if (HotKeys.EnumKey.TOGGLE.matches(key, 393216)) {
                    if (mode == Mode.PASTE || mode == Mode.MOVE_DST || mode == Mode.STACK) {
                        WandOption.REPLACE_EXISTING.toggle(stack, mode);
                        return true;
                    }
                    if (mode == Mode.DELETE) {
                        WandOption.AFFECT_ENTITIES.toggle(stack, mode);
                        return true;
                    }
                    if (mode == Mode.EXTEND_CONTINUOUS || mode == Mode.REPLACE) {
                        WandOption.ALLOW_DIAGONALS.toggle(stack, mode);
                        return true;
                    }
                    if (mode == Mode.COLUMN || mode == Mode.LINE || mode == Mode.PLANE || mode == Mode.EXTEND_AREA) {
                        WandOption.CONTINUE_THROUGH.toggle(stack, mode);
                        return true;
                    }
                } else if (HotKeys.EnumKey.TOGGLE.matches(key, 327680)) {
                    if (mode == Mode.PASTE || mode == Mode.STACK) {
                        WandOption.AFFECT_ENTITIES.toggle(stack, mode);
                        return true;
                    }
                    if (!mode.isAreaMode()) {
                        WandOption.RENDER_GHOST.toggle(stack, mode);
                        return true;
                    }
                } else if (HotKeys.EnumKey.TOGGLE.matches(key, 0)) {
                    if (mode == Mode.REPLACE) {
                        WandOption.REPLACE_MODE_IS_AREA.toggle(stack, mode);
                        return true;
                    }
                    if (mode.isAreaMode() && mode != Mode.COPY) {
                        this.setAreaFacing(stack, mode, player);
                        return true;
                    }
                    if (!mode.isAreaMode()) {
                        this.toggleAreaFlipped(stack, player);
                        return true;
                    }
                } else if (HotKeys.EnumKey.TOGGLE.matches(key, 262144) && (mode == Mode.COLUMN || mode == Mode.LINE || mode == Mode.PLANE || mode == Mode.EXTEND_AREA)) {
                    WandOption.REPLACE_EXISTING.toggle(stack, mode);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void handleString(EntityPlayer player, ItemStack stack, String text) {
        if (!stack.func_190926_b()) {
            this.setTemplateName(stack, player, text);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 600;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack.func_190926_b() || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) && imodule.getModuleTier(moduleStack) != 1) {
            return 0;
        }
        return this.getMaxModules(containerStack, moduleType);
    }

    @Override
    protected void addItemOverrides() {
        this.func_185043_a(new ResourceLocation("enderutilities", "usetime"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                stack = entityIn.func_184607_cu();
                if (!stack.func_190926_b()) {
                    return (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 50.0f;
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("enderutilities", "inuse"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public static enum Mode {
        EXTEND_CONTINUOUS("extcont", "enderutilities.tooltip.item.build.extend.continuous"),
        EXTEND_AREA("extarea", "enderutilities.tooltip.item.build.extend.area"),
        COLUMN("column", "enderutilities.tooltip.item.build.column"),
        LINE("line", "enderutilities.tooltip.item.build.line"),
        PLANE("plane", "enderutilities.tooltip.item.build.plane"),
        CIRCLE("circle", "enderutilities.tooltip.item.build.circle"),
        WALLS("walls", "enderutilities.tooltip.item.build.walls", false, true, true),
        CUBE("cube", "enderutilities.tooltip.item.build.cube", false, true, true),
        REPLACE("replace", "enderutilities.tooltip.item.build.replace"),
        REPLACE_3D("replace3d", "enderutilities.tooltip.item.build.replace.3d", true, true, true),
        MOVE_SRC("movesrc", "enderutilities.tooltip.item.build.move.source", true, true, false),
        MOVE_DST("movedst", "enderutilities.tooltip.item.build.move.destination", true, false, true),
        COPY("copy", "enderutilities.tooltip.item.build.copy", true, true, true),
        PASTE("paste", "enderutilities.tooltip.item.build.paste", true, false, true),
        STACK("stack", "enderutilities.tooltip.item.build.stack", true, true, true),
        DELETE("delete", "enderutilities.tooltip.item.build.delete", true, true, true, true);

        private final String name;
        private final String unlocName;
        private final boolean isAreaMode;
        private final boolean hasTwoCorners;
        private final boolean hasUseDelay;
        private boolean creativeOnly;
        private static int numCreativeOnly;

        private Mode(String name, String unlocName) {
            this(name, unlocName, false, false, false);
        }

        private Mode(String name, String unlocName, boolean isAreaMode, boolean twoCorners, boolean useDelay) {
            this(name, unlocName, isAreaMode, twoCorners, useDelay, false);
        }

        private Mode(String name, String unlocName, boolean isAreaMode, boolean twoCorners, boolean useDelay, boolean creativeOnly) {
            this.name = name;
            this.unlocName = unlocName;
            this.isAreaMode = isAreaMode;
            this.hasTwoCorners = twoCorners;
            this.hasUseDelay = useDelay;
            this.creativeOnly = creativeOnly;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return I18n.func_135052_a((String)this.unlocName, (Object[])new Object[0]);
        }

        public boolean isAreaMode() {
            return this.isAreaMode;
        }

        public boolean hasTwoPlacableCorners() {
            return this.hasTwoCorners;
        }

        public boolean hasUseDelay() {
            return this.hasUseDelay;
        }

        public static Mode getMode(ItemStack stack) {
            return Mode.values()[Mode.getModeOrdinal(stack)];
        }

        public static void cycleMode(ItemStack stack, boolean reverse, EntityPlayer player) {
            int max = player.field_71075_bZ.field_75098_d ? Mode.values().length - 1 : Mode.values().length - 1 - numCreativeOnly;
            NBTUtils.cycleByteValue(stack, ItemBuildersWand.WRAPPER_TAG_NAME, ItemBuildersWand.TAG_NAME_MODE, max, reverse);
        }

        public static int getModeOrdinal(ItemStack stack) {
            byte id = NBTUtils.getByte(stack, ItemBuildersWand.WRAPPER_TAG_NAME, ItemBuildersWand.TAG_NAME_MODE);
            return id >= 0 && id < Mode.values().length ? (int)id : 0;
        }

        public static int getModeCount(EntityPlayer player) {
            return player.field_71075_bZ.field_75098_d ? Mode.values().length : Mode.values().length - numCreativeOnly;
        }

        static {
            for (Mode mode : Mode.values()) {
                if (!mode.creativeOnly) continue;
                ++numCreativeOnly;
            }
        }
    }

    public static enum WandOption {
        AFFECT_ENTITIES,
        ALLOW_DIAGONALS,
        AREA_FLIPPED,
        BIND_MODE,
        CHISELS_AND_BITS_CROSSWORLD,
        CONTINUE_THROUGH,
        MIRRORED,
        MOVE_POSITION,
        RENDER_GHOST,
        REPLACE_EXISTING,
        REPLACE_MODE_IS_AREA;


        public boolean isEnabled(ItemStack stack) {
            return this.isEnabled(stack, Mode.getMode(stack));
        }

        public boolean isEnabled(ItemStack stack, Mode mode) {
            if (stack.func_77973_b() instanceof ItemBuildersWand) {
                NBTTagCompound tag = ((ItemBuildersWand)stack.func_77973_b()).getModeTag(stack, mode);
                return (tag.func_74762_e("Modes") & 1 << this.ordinal()) != 0;
            }
            return false;
        }

        public void toggle(ItemStack stack) {
            this.toggle(stack, Mode.getMode(stack));
        }

        public void toggle(ItemStack stack, Mode mode) {
            if (stack.func_77973_b() instanceof ItemBuildersWand) {
                NBTTagCompound tag = ((ItemBuildersWand)stack.func_77973_b()).getModeTag(stack, mode);
                tag.func_74768_a("Modes", tag.func_74762_e("Modes") ^ 1 << this.ordinal());
            }
        }
    }

    public static class Area3D {
        private final BlockPos.MutableBlockPos pos;
        private final BlockPos.MutableBlockPos neg;
        private int maxSize = 64;

        public Area3D() {
            this(0, 0, 0, 0, 0, 0);
        }

        public Area3D(int xp, int yp, int zp, int xn, int yn, int zn) {
            this.pos = new BlockPos.MutableBlockPos(xp, yp, zp);
            this.neg = new BlockPos.MutableBlockPos(xn, yn, zn);
        }

        private Area3D(NBTTagCompound tag) {
            this.pos = new BlockPos.MutableBlockPos(0, 0, 0);
            this.neg = new BlockPos.MutableBlockPos(0, 0, 0);
            this.readFromNBT(tag);
        }

        public static Area3D getAreaFromNBT(NBTTagCompound tag) {
            return new Area3D(tag);
        }

        public Area3D setMaxSize(int max) {
            this.maxSize = max;
            return this;
        }

        public int getXPos() {
            return this.pos.func_177958_n();
        }

        public int getYPos() {
            return this.pos.func_177956_o();
        }

        public int getZPos() {
            return this.pos.func_177952_p();
        }

        public int getXNeg() {
            return this.neg.func_177958_n();
        }

        public int getYNeg() {
            return this.neg.func_177956_o();
        }

        public int getZNeg() {
            return this.neg.func_177952_p();
        }

        public Area3D adjustArea(EnumFacing facing, int amount) {
            if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                this.pos.func_189534_c(facing, amount);
                this.clampBounds(this.pos);
            } else {
                this.neg.func_189534_c(facing, -amount);
                this.clampBounds(this.neg);
            }
            return this;
        }

        private int getPacked(BlockPos pos) {
            return (pos.func_177958_n() & 0xFF) << 16 | (pos.func_177956_o() & 0xFF) << 8 | pos.func_177952_p() & 0xFF;
        }

        private BlockPos.MutableBlockPos clampBounds(BlockPos.MutableBlockPos bounds) {
            int x = MathHelper.func_76125_a((int)bounds.func_177958_n(), (int)0, (int)this.maxSize);
            int y = MathHelper.func_76125_a((int)bounds.func_177956_o(), (int)0, (int)this.maxSize);
            int z = MathHelper.func_76125_a((int)bounds.func_177952_p(), (int)0, (int)this.maxSize);
            return bounds.func_181079_c(x, y, z);
        }

        private void setFromPacked(BlockPos.MutableBlockPos bounds, int packed) {
            int x = MathHelper.func_76125_a((int)(packed >> 16 & 0xFF), (int)0, (int)this.maxSize);
            int y = MathHelper.func_76125_a((int)(packed >> 8 & 0xFF), (int)0, (int)this.maxSize);
            int z = MathHelper.func_76125_a((int)(packed & 0xFF), (int)0, (int)this.maxSize);
            bounds.func_181079_c(x, y, z);
        }

        public void readFromNBT(NBTTagCompound tag) {
            int packed = tag.func_74762_e("DimPos");
            this.setFromPacked(this.pos, packed);
            packed = tag.func_74762_e("DimNeg");
            this.setFromPacked(this.neg, packed);
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("DimPos", this.getPacked((BlockPos)this.pos));
            tag.func_74768_a("DimNeg", this.getPacked((BlockPos)this.neg));
        }
    }

    public class Area {
        public int rPosH;
        public int rNegH;
        public int rPosV;
        public int rNegV;
        public int maxRadius;

        public Area(int packed) {
            this.init(packed);
        }

        public Area(NBTTagCompound tag) {
            if (tag != null) {
                this.init(tag.func_74762_e(ItemBuildersWand.TAG_NAME_DIMENSIONS));
            } else {
                this.init(0);
            }
        }

        public void init(int packed) {
            this.init(packed & 0xFF, packed >> 8 & 0xFF, packed >> 16 & 0xFF, packed >> 24 & 0xFF);
        }

        public void init(int rPosH, int rNegH, int rPosV, int rNegV) {
            this.rPosH = rPosH;
            this.rNegH = rNegH;
            this.rPosV = rPosV;
            this.rNegV = rNegV;
            this.maxRadius = 64;
        }

        public Area adjustFromPlanarizedFacing(EnumFacing facing, int amount, EnumFacing upAxis, EnumFacing rightAxis) {
            if (facing == upAxis) {
                this.rPosV = MathHelper.func_76125_a((int)(this.rPosV + amount), (int)0, (int)this.maxRadius);
            } else if (facing == upAxis.func_176734_d()) {
                this.rNegV = MathHelper.func_76125_a((int)(this.rNegV + amount), (int)0, (int)this.maxRadius);
            } else if (facing == rightAxis) {
                this.rPosH = MathHelper.func_76125_a((int)(this.rPosH + amount), (int)0, (int)this.maxRadius);
            } else if (facing == rightAxis.func_176734_d()) {
                this.rNegH = MathHelper.func_76125_a((int)(this.rNegH + amount), (int)0, (int)this.maxRadius);
            }
            return this;
        }

        public int getPacked() {
            return this.rPosH | this.rNegH << 8 | this.rPosV << 16 | this.rNegV << 24;
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a(ItemBuildersWand.TAG_NAME_DIMENSIONS, this.getPacked());
        }
    }
}

