/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.IContainerItem;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerLargeStacks;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.item.ItemNullifier;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ContainerNullifier
extends ContainerLargeStacks
implements IContainerItem {
    public final ItemNullifier.ItemHandlerNullifier inventoryItem;
    private final UUID containerUUID;
    private ItemStack stackLast = ItemStack.field_190927_a;

    public ContainerNullifier(EntityPlayer player, ItemStack containerStack) {
        super(player, ItemNullifier.createInventoryForItem(containerStack, player.func_130014_f_().field_72995_K));
        this.containerUUID = NBTUtils.getUUIDFromItemStack(containerStack, "UUID", true);
        this.inventoryItem = (ItemNullifier.ItemHandlerNullifier)this.inventory;
        this.inventoryItem.setHostInventory((IItemHandler)this.playerInv, this.containerUUID);
        this.inventoryNonWrapped = this.inventoryItem;
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, 69);
    }

    @Override
    protected void addCustomInventorySlots() {
        int xOff = 8;
        int yOff = 24;
        this.customInventorySlots = new MergeSlotRange(this.field_75151_b.size(), this.inventory.getSlots());
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, slot, xOff + slot * 18, yOff));
        }
    }

    @Override
    public ItemStack getContainerItem() {
        return InventoryUtils.getItemStackByUUID((IItemHandler)this.playerInv, this.containerUUID, "UUID");
    }

    @Override
    public void func_75142_b() {
        ItemStack stack;
        if (!this.player.func_130014_f_().field_72995_K && (stack = this.getContainerItem()) != this.stackLast) {
            this.inventoryItem.readFromContainerItemStack();
            this.stackLast = stack;
        }
        super.func_75142_b();
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (HotKeys.EnumKey.MIDDLE_CLICK.matches(action, 131072)) {
            SlotItemHandlerGeneric slot;
            if (this.customInventorySlots.contains(element) && (slot = this.getSlotItemHandler(element)) != null) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
        } else {
            super.performGuiAction(player, action, element);
        }
    }
}

