/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.container.base.ContainerTileLargeStacks;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerModule;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperPermissions;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityHandyChest;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class ContainerHandyChest
extends ContainerTileLargeStacks {
    protected static final int[] PLAYER_INV_Y = new int[]{95, 131, 167, 174};
    protected TileEntityHandyChest tehc;
    protected SlotRange cardSlots;
    public int selectedModule;
    public int actionMode;
    public int lockMask;

    public ContainerHandyChest(EntityPlayer player, TileEntityHandyChest te) {
        super(player, te.getWrappedInventoryForContainer(player), te);
        this.tehc = te;
        this.inventoryNonWrapped = (ItemHandlerWrapperPermissions)this.inventory;
        this.addCustomInventorySlots();
        int tier = te.getStorageTier();
        int y = tier >= 0 && tier <= 3 ? PLAYER_INV_Y[tier] : 95;
        this.addPlayerInventorySlots(tier == 3 ? 44 : 8, y);
    }

    @Override
    protected void addCustomInventorySlots() {
        int customInvStart = this.field_75151_b.size();
        int tier = MathHelper.func_76125_a((int)this.tehc.getStorageTier(), (int)0, (int)3);
        int posX = 8;
        int posY = tier <= 2 ? 41 : 13;
        int rows = tier <= 2 ? (tier + 1) * 2 : 8;
        int columns = tier == 3 ? 13 : 9;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, row * columns + col, posX + col * 18, posY + row * 18));
            }
        }
        this.customInventorySlots = new MergeSlotRange(customInvStart, this.field_75151_b.size() - customInvStart);
        this.addMergeSlotRangePlayerToExt(this.field_75151_b.size(), 4);
        this.cardSlots = new SlotRange(this.field_75151_b.size(), 4);
        posX = tier <= 2 ? 98 : 224;
        posY = tier <= 2 ? 8 : 174;
        int modX = tier == 3 ? 0 : 18;
        int modY = tier == 3 ? 18 : 0;
        for (int i = 0; i < 4; ++i) {
            this.func_75146_a((Slot)new SlotItemHandlerModule(this.tehc.getModuleInventory(), i, posX + i * modX, posY + i * modY, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS));
        }
    }

    @Override
    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_71112_a((Container)this, 0, this.tehc.getSelectedModule());
        listener.func_71112_a((Container)this, 1, this.tehc.getQuickMode());
        listener.func_71112_a((Container)this, 2, this.tehc.getLockMask());
    }

    @Override
    public void func_75142_b() {
        if (this.tehc.func_145831_w().field_72995_K) {
            return;
        }
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener listener = (IContainerListener)this.field_75149_d.get(i);
            if (this.selectedModule != this.tehc.getSelectedModule()) {
                listener.func_71112_a((Container)this, 0, this.tehc.getSelectedModule());
            }
            if (this.actionMode != this.tehc.getQuickMode()) {
                listener.func_71112_a((Container)this, 1, this.tehc.getQuickMode());
            }
            if (this.lockMask == this.tehc.getLockMask()) continue;
            listener.func_71112_a((Container)this, 2, this.tehc.getLockMask());
        }
        this.selectedModule = this.tehc.getSelectedModule();
        this.actionMode = this.tehc.getQuickMode();
        this.lockMask = this.tehc.getLockMask();
        super.func_75142_b();
    }

    @Override
    public void func_75137_b(int var, int val) {
        super.func_75137_b(var, val);
        switch (var) {
            case 0: {
                this.tehc.setSelectedModule(val);
                break;
            }
            case 1: {
                this.tehc.setQuickMode(val);
                break;
            }
            case 2: {
                this.tehc.setLockMask(val);
                break;
            }
        }
    }

    @Override
    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        int mask = this.tehc.getLockMask();
        if (this.cardSlots.contains(slotNum) && (mask & 1 << slotNum - this.cardSlots.first) != 0 && this.func_75139_a(slotNum).func_75216_d()) {
            ItemStack cardStack = this.func_75139_a(slotNum).func_75211_c();
            OwnerData ownerData = OwnerData.getOwnerDataFromItem(cardStack);
            if (ownerData != null && !ownerData.isOwner((Entity)player)) {
                return ItemStack.field_190927_a;
            }
            super.func_184996_a(slotNum, dragType, clickType, player);
            if (!this.func_75139_a(slotNum).func_75216_d()) {
                this.tehc.setLockMask(mask &= ~(1 << slotNum - this.cardSlots.first));
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotNum, dragType, clickType, player);
    }
}

