/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.gui.client;

import fi.dy.masa.enderutilities.gui.client.base.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonHoverText;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonStateCallback;
import fi.dy.masa.enderutilities.gui.client.button.IButtonStateCallback;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerEnderUtilities;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageGuiAction;
import fi.dy.masa.enderutilities.tileentity.TileEntityInserter;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiInserter
extends GuiEnderUtilities
implements IButtonStateCallback {
    private final TileEntityInserter tef;

    public GuiInserter(ContainerEnderUtilities container, TileEntityInserter te) {
        super(container, 176, te.isFiltered() ? 197 : 141, "gui.container.inserter_" + (te.isFiltered() ? "filtered" : "normal"));
        this.tef = te;
        this.infoArea = new GuiEnderUtilities.InfoArea(158, 15, 11, 11, "enderutilities.gui.infoarea.inserter_" + (te.isFiltered() ? "filtered" : "normal"), new Object[0]);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.createButtons();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.tef.isFiltered()) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.container.inserter_filtered", (Object[])new Object[0]), 8, 6, 0x404040);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, 105, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.container.inserter_normal", (Object[])new Object[0]), 8, 6, 0x404040);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, 49, 0x404040);
        }
        String str = String.valueOf(this.tef.getBaseItemHandler().getInventoryStackLimit());
        this.field_146289_q.func_78276_b(str, 134 - this.field_146289_q.func_78256_a(str), 22, 0x404040);
        str = String.valueOf(this.tef.getUpdateDelay());
        this.field_146289_q.func_78276_b(str, 134 - this.field_146289_q.func_78256_a(str), 36, 0x404040);
    }

    protected void createButtons() {
        this.field_146292_n.clear();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButtonHoverText(0, x + 138, y + 21, 8, 8, 0, 120, this.guiTextureWidgets, 8, 0, "enderutilities.gui.label.stacklimit"));
        this.field_146292_n.add(new GuiButtonHoverText(1, x + 138, y + 35, 8, 8, 0, 120, this.guiTextureWidgets, 8, 0, "enderutilities.gui.label.delay.inserter"));
        this.field_146292_n.add(new GuiButtonStateCallback(2, x + 153, y + 29, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 224, "enderutilities.gui.label.redstone.ignored"), GuiButtonStateCallback.ButtonState.createTranslate(60, 196, "enderutilities.gui.label.redstone.low"), GuiButtonStateCallback.ButtonState.createTranslate(60, 210, "enderutilities.gui.label.redstone.high")));
        if (this.tef.isFiltered()) {
            this.field_146292_n.add(new GuiButtonStateCallback(10, x + 9, y + 30, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 56, "enderutilities.gui.label.inserter.filter.output"), GuiButtonStateCallback.ButtonState.createTranslate(60, 42, "enderutilities.gui.label.inserter.filter.input")));
            this.field_146292_n.add(new GuiButtonStateCallback(11, x + 27, y + 30, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 70, "enderutilities.gui.label.blacklist"), GuiButtonStateCallback.ButtonState.createTranslate(60, 84, "enderutilities.gui.label.whitelist")));
            this.field_146292_n.add(new GuiButtonStateCallback(12, x + 45, y + 30, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 126, "enderutilities.gui.label.meta.ignore"), GuiButtonStateCallback.ButtonState.createTranslate(60, 112, "enderutilities.gui.label.meta.match")));
            this.field_146292_n.add(new GuiButtonStateCallback(13, x + 63, y + 30, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 154, "enderutilities.gui.label.nbt.ignore"), GuiButtonStateCallback.ButtonState.createTranslate(60, 140, "enderutilities.gui.label.nbt.match")));
        }
    }

    @Override
    protected void actionPerformedWithButton(GuiButton button, int mouseButton) throws IOException {
        int dim = this.tef.func_145831_w().field_73011_w.getDimension();
        int amount = 0;
        if (mouseButton == 0 || mouseButton == 11) {
            amount = 1;
        } else if (mouseButton == 1 || mouseButton == 9) {
            amount = -1;
        }
        if (button.field_146127_k == 0) {
            if (mouseButton == 2) {
                amount = GuiScreen.func_146272_n() ? 64 : -64;
            } else if (GuiScreen.func_146272_n()) {
                amount *= 16;
            } else if (GuiScreen.func_146271_m()) {
                amount *= 64;
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(dim, this.tef.func_174877_v(), 0, TileEntityInserter.GuiAction.CHANGE_STACK_LIMIT.ordinal(), amount));
        } else if (button.field_146127_k == 1) {
            if (mouseButton == 2) {
                amount = GuiScreen.func_146272_n() ? 72000 : -72000;
            } else if (GuiScreen.func_146272_n() && GuiScreen.func_146271_m()) {
                amount *= 1000;
            } else if (GuiScreen.func_146272_n()) {
                amount *= 10;
            } else if (GuiScreen.func_146271_m()) {
                amount *= 100;
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(dim, this.tef.func_174877_v(), 0, TileEntityInserter.GuiAction.CHANGE_DELAY.ordinal(), amount));
        }
        if (button.field_146127_k == 2) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(dim, this.tef.func_174877_v(), 0, TileEntityInserter.GuiAction.CHANGE_REDSTONE_MODE.ordinal(), amount));
        } else if (button.field_146127_k >= 10 && button.field_146127_k <= 13) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(dim, this.tef.func_174877_v(), 0, TileEntityInserter.GuiAction.CHANGE_FILTERS.ordinal(), 1 << button.field_146127_k - 10));
        }
    }

    @Override
    public int getButtonStateIndex(int callbackId) {
        if (callbackId == 2) {
            return this.tef.getRedstoneModeIntValue();
        }
        if (callbackId == 10) {
            return this.tef.isFilterSettingEnabled(TileEntityInserter.FilterSetting.IS_INPUT_FILTER) ? 1 : 0;
        }
        if (callbackId == 11) {
            return this.tef.isFilterSettingEnabled(TileEntityInserter.FilterSetting.IS_WHITELIST) ? 1 : 0;
        }
        if (callbackId == 12) {
            return this.tef.isFilterSettingEnabled(TileEntityInserter.FilterSetting.MATCH_META) ? 1 : 0;
        }
        if (callbackId == 13) {
            return this.tef.isFilterSettingEnabled(TileEntityInserter.FilterSetting.MATCH_NBT) ? 1 : 0;
        }
        return 0;
    }

    @Override
    public boolean isButtonEnabled(int callbackId) {
        return true;
    }
}

