/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.event.tasks.PlayerTaskScheduler;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.item.ItemRuler;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageGuiAction;
import fi.dy.masa.enderutilities.network.message.MessageKeyPressed;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.tileentity.TileEntityBarrel;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.PlacementProperties;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerEventHandler {
    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EnumFacing face = event.getFace();
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() == EnderUtilitiesItems.BUILDERS_WAND) {
                ((ItemBuildersWand)stack.func_77973_b()).onLeftClickBlock(player, world, stack, pos, world.field_73011_w.getDimension(), face);
                event.setCanceled(true);
                return;
            }
            if (stack.func_77973_b() == EnderUtilitiesItems.RULER) {
                ((ItemRuler)stack.func_77973_b()).onLeftClickBlock(player, world, stack, pos, world.field_73011_w.getDimension(), face);
                event.setCanceled(true);
                return;
            }
            if (!player.field_71075_bZ.field_75098_d && stack.func_77973_b() == EnderUtilitiesItems.ENDER_TOOL && player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                event.setCanceled(true);
                return;
            }
        }
        if (world.func_180495_p(pos).func_177230_c() == EnderUtilitiesBlocks.BARREL) {
            TileEntityBarrel te;
            boolean takeItems;
            boolean bl = takeItems = stack.func_190926_b() || !stack.func_77973_b().getToolClasses(stack).contains("pickaxe");
            if (player.field_71075_bZ.field_75098_d && ((te = BlockEnderUtilities.getTileEntitySafely((IBlockAccess)world, pos, TileEntityBarrel.class)) == null || !te.getLabeledFaces().contains(face))) {
                takeItems = false;
            }
            if (takeItems) {
                if (world.field_72995_K) {
                    int dim = world.field_73011_w.getDimension();
                    int guiId = 0;
                    int fullStacks = Configs.barrelInversedSneak == player.func_70093_af() ? 1 : 0;
                    PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(dim, pos, guiId, 0, fullStacks));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRightClickAir(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack;
        if (event.getSide() == Side.CLIENT && !(stack = EntityUtils.getHeldItemOfType((EntityLivingBase)event.getEntityPlayer(), EnderUtilitiesItems.BUILDERS_WAND)).func_190926_b() && EnderUtilities.proxy.isControlKeyDown()) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(0x10000000));
        }
    }

    @SubscribeEvent
    public void onClientChatReceived(ClientChatReceivedEvent event) {
        ITextComponent message = event.getMessage();
        if (!Configs.announceLocationBindingInChat && message instanceof TextComponentTranslation && "enderutilities.chat.message.itemboundtolocation".equals(((TextComponentTranslation)message).func_150268_i())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            PlacementProperties.getInstance().syncAllDataForPlayer((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerTaskScheduler.getInstance().removeTask(event.player, null);
    }
}

