/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.model.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.BlockBarrel;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesTileEntity;
import fi.dy.masa.enderutilities.client.renderer.model.block.BakedModelCamouflageBlock;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.util.PositionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BakedModelBarrel
implements IBakedModel {
    private static final Map<Optional<IBlockState>, ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>>> QUAD_CACHE_NORMAL = new HashMap<Optional<IBlockState>, ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>>>();
    private static final Map<Optional<IBlockState>, ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>>> QUAD_CACHE_CAMO = new HashMap<Optional<IBlockState>, ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>>>();
    private static final ImmutableList<BakedQuad> EMPTY_QUADS = ImmutableList.of();
    private final ImmutableMap<String, String> textures;
    private final IModel baseModel;
    private final IModel overlayModel;
    private final VertexFormat format;
    private final IBakedModel bakedBaseModel;
    private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private final TextureAtlasSprite particle;
    private final ImmutableList<BakedQuad> itemQuads;

    private BakedModelBarrel(IModel baseModel, IModel overlayModel, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, ImmutableMap<String, String> textures) {
        IBlockState defaultState = EnderUtilitiesBlocks.BARREL.func_176223_P().func_177226_a((IProperty)BlockBarrel.LABEL_FRONT, (Comparable)Boolean.valueOf(true));
        this.baseModel = baseModel.retexture(textures);
        this.overlayModel = overlayModel.retexture(textures);
        this.bakedBaseModel = this.baseModel.retexture(this.getTexturesBaseModel(defaultState, (Map<String, String>)textures)).bake(state, format, bakedTextureGetter);
        this.format = format;
        this.bakedTextureGetter = bakedTextureGetter;
        this.textures = textures;
        String particleName = (String)this.textures.get((Object)"particle");
        this.particle = particleName != null ? bakedTextureGetter.apply(new ResourceLocation(particleName)) : this.bakedBaseModel.func_177554_e();
        this.itemQuads = BakedModelCamouflageBlock.buildItemModel(this.bakedBaseModel, null);
    }

    public boolean func_177555_b() {
        return this.bakedBaseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedBaseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.bakedBaseModel.func_188618_c();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.bakedBaseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.bakedBaseModel.func_188617_f();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    public synchronized List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        Optional<IBlockState> key;
        if (state == null) {
            return this.itemQuads;
        }
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        IBlockState actualState = extendedState.getClean();
        IBlockState camoState = (IBlockState)extendedState.getValue((IUnlistedProperty)BlockEnderUtilitiesTileEntity.CAMOBLOCKSTATE);
        boolean validCamo = camoState != null && camoState.func_177230_c() != Blocks.field_150350_a;
        Map<Optional<IBlockState>, ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>>> cache = validCamo ? QUAD_CACHE_CAMO : QUAD_CACHE_NORMAL;
        ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>> map = cache.get(key = Optional.of(actualState));
        if (map == null) {
            IBakedModel bakedModel = validCamo ? this.getBakedOverlayModel(actualState) : this.getBakedBaseModel(actualState);
            map = this.getQuadsForState(bakedModel, extendedState, rand, validCamo);
            cache.put(key, map);
        }
        return (List)map.get(Optional.ofNullable(side));
    }

    private IBakedModel getBakedBaseModel(IBlockState actualState) {
        IModel model = this.baseModel.retexture(this.getTexturesBaseModel(actualState, (Map<String, String>)this.textures));
        return model.bake((IModelState)TRSRTransformation.from((EnumFacing)((EnumFacing)actualState.func_177229_b((IProperty)BlockBarrel.FACING_H))), this.format, this.bakedTextureGetter);
    }

    private IBakedModel getBakedOverlayModel(IBlockState actualState) {
        return this.overlayModel.bake((IModelState)TRSRTransformation.from((EnumFacing)((EnumFacing)actualState.func_177229_b((IProperty)BlockBarrel.FACING_H))), this.format, this.bakedTextureGetter);
    }

    private ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>> getQuadsForState(IBakedModel bakedModel, IExtendedBlockState extendedState, long rand, boolean validCamo) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (EnumFacing side : EnumFacing.values()) {
            ImmutableList.Builder quads = ImmutableList.builder();
            if (validCamo) {
                quads.addAll(this.getQuadsForCamoModelSide(side, (IBlockState)extendedState, bakedModel, rand));
            } else {
                quads.addAll((Iterable)bakedModel.func_188616_a((IBlockState)extendedState, side, rand));
            }
            mapBuilder.put(Optional.ofNullable(side), (Object)quads.build());
        }
        mapBuilder.put(Optional.ofNullable(null), (Object)ImmutableList.copyOf((Collection)bakedModel.func_188616_a((IBlockState)extendedState, null, rand)));
        return mapBuilder.build();
    }

    private List<BakedQuad> getQuadsForCamoModelSide(EnumFacing side, IBlockState state, IBakedModel bakedModel, long rand) {
        EnumFacing relativeSide = PositionUtils.getRelativeFacing((EnumFacing)state.func_177229_b((IProperty)BlockBarrel.FACING_H), side);
        switch (relativeSide) {
            case DOWN: {
                return (Boolean)state.func_177229_b((IProperty)BlockBarrel.LABEL_DOWN) != false ? bakedModel.func_188616_a(state, side, rand) : EMPTY_QUADS;
            }
            case UP: {
                return (Boolean)state.func_177229_b((IProperty)BlockBarrel.LABEL_UP) != false ? bakedModel.func_188616_a(state, side, rand) : EMPTY_QUADS;
            }
            case NORTH: {
                return (Boolean)state.func_177229_b((IProperty)BlockBarrel.LABEL_FRONT) != false ? bakedModel.func_188616_a(state, side, rand) : EMPTY_QUADS;
            }
            case SOUTH: {
                return (Boolean)state.func_177229_b((IProperty)BlockBarrel.LABEL_BACK) != false ? bakedModel.func_188616_a(state, side, rand) : EMPTY_QUADS;
            }
            case WEST: {
                return (Boolean)state.func_177229_b((IProperty)BlockBarrel.LABEL_RIGHT) != false ? bakedModel.func_188616_a(state, side, rand) : EMPTY_QUADS;
            }
            case EAST: {
                return (Boolean)state.func_177229_b((IProperty)BlockBarrel.LABEL_LEFT) != false ? bakedModel.func_188616_a(state, side, rand) : EMPTY_QUADS;
            }
        }
        return EMPTY_QUADS;
    }

    private ImmutableMap<String, String> getTexturesBaseModel(IBlockState state, Map<String, String> texturesIn) {
        ImmutableMap.Builder texturesOut = ImmutableMap.builder();
        String texFront = texturesIn.get("front_normal");
        String texSide = texturesIn.get("side");
        String texUp = texturesIn.get("top");
        texturesOut.put((Object)"particle", (Object)texturesIn.get("top"));
        texturesOut.put((Object)"up", (Object)((Boolean)state.func_177229_b((IProperty)BlockBarrel.LABEL_UP) != false ? texFront : texUp));
        texturesOut.put((Object)"down", (Object)((Boolean)state.func_177229_b((IProperty)BlockBarrel.LABEL_DOWN) != false ? texFront : texUp));
        texturesOut.put((Object)"north", (Object)((Boolean)state.func_177229_b((IProperty)BlockBarrel.LABEL_FRONT) != false ? texFront : texSide));
        texturesOut.put((Object)"south", (Object)((Boolean)state.func_177229_b((IProperty)BlockBarrel.LABEL_BACK) != false ? texFront : texSide));
        texturesOut.put((Object)"west", (Object)((Boolean)state.func_177229_b((IProperty)BlockBarrel.LABEL_RIGHT) != false ? texFront : texSide));
        texturesOut.put((Object)"east", (Object)((Boolean)state.func_177229_b((IProperty)BlockBarrel.LABEL_LEFT) != false ? texFront : texSide));
        return texturesOut.build();
    }

    public static class StateMapper
    extends StateMapperBase {
        private static final ModelResourceLocation LOCATION_NORMAL = new ModelResourceLocation("enderutilities:barrel", "creative=false");
        private static final ModelResourceLocation LOCATION_CREATIVE = new ModelResourceLocation("enderutilities:barrel", "creative=true");

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return (Boolean)state.func_177229_b((IProperty)BlockBarrel.CREATIVE) != false ? LOCATION_CREATIVE : LOCATION_NORMAL;
        }
    }

    public static class ModelLoaderBarrel
    implements ICustomModelLoader {
        private static final ResourceLocation FAKE_LOCATION_NORMAL = new ResourceLocation("enderutilities", "models/block/custom/barrel_normal");
        private static final ResourceLocation FAKE_LOCATION_CREATIVE = new ResourceLocation("enderutilities", "models/block/custom/barrel_creative");
        public static final ResourceLocation LOCATION_NORMAL = new ResourceLocation("enderutilities", "block/custom/barrel_normal");
        public static final ResourceLocation LOCATION_CREATIVE = new ResourceLocation("enderutilities", "block/custom/barrel_creative");

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.equals((Object)FAKE_LOCATION_NORMAL) || modelLocation.equals((Object)FAKE_LOCATION_CREATIVE);
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return new ModelBarrel();
        }

        public void func_110549_a(IResourceManager resourceManager) {
            QUAD_CACHE_NORMAL.clear();
            QUAD_CACHE_CAMO.clear();
        }
    }

    private static class ModelBarrel
    implements IModel {
        private static final ResourceLocation BARREL_BASE_MODEL = new ResourceLocation("enderutilities", "block/barrel_base");
        private static final ResourceLocation BARREL_OVERLAY_MODEL = new ResourceLocation("enderutilities", "block/barrel_overlay");
        private final IModel baseModel;
        private final IModel overlayModel;
        private final ImmutableMap<String, String> textures;

        private ModelBarrel() {
            this.baseModel = ModelLoaderRegistry.getMissingModel();
            this.overlayModel = ModelLoaderRegistry.getMissingModel();
            this.textures = ImmutableMap.of();
        }

        private ModelBarrel(IModel baseModel, IModel overlayModel, ImmutableMap<String, String> textures) {
            this.baseModel = baseModel;
            this.overlayModel = overlayModel;
            this.textures = textures;
        }

        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.of((Object)BARREL_BASE_MODEL, (Object)BARREL_OVERLAY_MODEL);
        }

        public Collection<ResourceLocation> getTextures() {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)new ResourceLocation("enderutilities:blocks/barrel_normal_front"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/barrel_normal_front_camo"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/barrel_normal_side"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/barrel_normal_top"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/barrel_creative_front"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/barrel_creative_front_camo"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/barrel_creative_side"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/barrel_creative_top"));
            return builder.build();
        }

        public IModel retexture(ImmutableMap<String, String> textures) {
            IModel baseModel = ModelLoaderRegistry.getMissingModel();
            IModel overlayModel = ModelLoaderRegistry.getMissingModel();
            try {
                baseModel = ModelLoaderRegistry.getModel((ResourceLocation)BARREL_BASE_MODEL);
                baseModel = baseModel.retexture(this.textures);
                overlayModel = ModelLoaderRegistry.getModel((ResourceLocation)BARREL_OVERLAY_MODEL);
                overlayModel = overlayModel.retexture(this.textures);
            }
            catch (Exception e) {
                EnderUtilities.logger.warn("Failed to load the base model for a Barrel", (Throwable)e);
            }
            return new ModelBarrel(baseModel, overlayModel, textures);
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            return new BakedModelBarrel(this.baseModel, this.overlayModel, state, format, bakedTextureGetter, this.textures);
        }
    }
}

