/*
 * Decompiled with CFR 0.152.
 */
package org.btpos.dj2addons.crafttweaker.bewitchment;

import com.bewitchment.Util;
import com.bewitchment.api.registry.AltarUpgrade;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ModOnly(value="bewitchment")
@ZenClass(value="dj2addons.bewitchment.WitchesAltar")
@ZenDocClass(value="dj2addons.bewitchment.WitchesAltar", description={"Adds upgrades to the Witches Altar."})
public class WitchesAltar {
    @ZenMethod
    @ZenDocMethod(args={@ZenDocArg(arg="itemStack", info="The OreDict key to add."), @ZenDocArg(arg="gain", info="Flat bonus to Magical Power."), @ZenDocArg(arg="multiplier", info="Multiplicative multiplier applied to MP.")})
    public static void addUpgradeCup(IItemStack itemStack, int gain, double multiplier) {
        Util.registerAltarUpgradeItemStack((ItemStack)CraftTweakerMC.getItemStack((IItemStack)itemStack), (AltarUpgrade)new AltarUpgrade(AltarUpgrade.Type.CUP, gain, multiplier));
    }

    @ZenMethod
    @ZenDocMethod(args={@ZenDocArg(arg="oreDict", info="The OreDict key to add."), @ZenDocArg(arg="gain", info="Flat bonus to Magical Power."), @ZenDocArg(arg="totalMult", info="Multiplicative multiplier applied to MP.")})
    public static void addUpgradeCup(IOreDictEntry oreDict, int gain, double totalMult) {
        Util.registerAltarUpgradeOreDict((String)oreDict.getName(), (AltarUpgrade)new AltarUpgrade(AltarUpgrade.Type.CUP, gain, totalMult));
    }

    @ZenMethod
    @ZenDocMethod(args={@ZenDocArg(arg="itemStack", info="The Item to add."), @ZenDocArg(arg="bonus", info="Flat bonus to Magical Power.")})
    public static void addUpgradePentacle(IItemStack itemStack, int bonus) {
        Util.registerAltarUpgradeItemStack((ItemStack)CraftTweakerMC.getItemStack((IItemStack)itemStack), (AltarUpgrade)new AltarUpgrade(AltarUpgrade.Type.PENTACLE, bonus, 0.0));
    }

    @ZenMethod
    @ZenDocMethod(args={@ZenDocArg(arg="oreDict", info="The OreDict key to add."), @ZenDocArg(arg="bonus", info="Flat bonus to Magical Power.")})
    public static void addUpgradePentacle(IOreDictEntry oreDict, int bonus) {
        Util.registerAltarUpgradeOreDict((String)oreDict.getName(), (AltarUpgrade)new AltarUpgrade(AltarUpgrade.Type.PENTACLE, bonus, 0.0));
    }

    @ZenMethod
    @ZenDocMethod(args={@ZenDocArg(arg="itemStack", info="The Item to add."), @ZenDocArg(arg="multBoost", info="Additive multiplier to MP.")})
    public static void addUpgradeWand(IItemStack itemStack, double multBoost) {
        Util.registerAltarUpgradeItemStack((ItemStack)CraftTweakerMC.getItemStack((IItemStack)itemStack), (AltarUpgrade)new AltarUpgrade(AltarUpgrade.Type.WAND, 0, multBoost));
    }

    @ZenMethod
    @ZenDocMethod(args={@ZenDocArg(arg="oreDict", info="The OreDict key to add."), @ZenDocArg(arg="multBoost", info="Additive multiplier to MP.")})
    public static void addUpgradeWand(IOreDictEntry oreDict, double multBoost) {
        Util.registerAltarUpgradeOreDict((String)oreDict.getName(), (AltarUpgrade)new AltarUpgrade(AltarUpgrade.Type.WAND, 0, multBoost));
    }

    @ZenMethod
    @ZenDocMethod(args={@ZenDocArg(arg="itemStack", info="The Item to add."), @ZenDocArg(arg="multiplier", info="Additive multiplier to MP.")})
    public static void addUpgradeSword(IItemStack itemStack, double multiplier) {
        Util.registerAltarUpgradeItemStack((ItemStack)CraftTweakerMC.getItemStack((IItemStack)itemStack), (AltarUpgrade)new AltarUpgrade(AltarUpgrade.Type.SWORD, 0, multiplier));
    }

    @ZenMethod
    @ZenDocMethod(args={@ZenDocArg(arg="oreDict", info="The OreDict key to add."), @ZenDocArg(arg="multiplier", info="Additive multiplier to MP.")})
    public static void addUpgradeSword(IOreDictEntry oreDict, double multiplier) {
        Util.registerAltarUpgradeOreDict((String)oreDict.getName(), (AltarUpgrade)new AltarUpgrade(AltarUpgrade.Type.SWORD, 0, multiplier));
    }
}

