/*
 * Decompiled with CFR 0.152.
 */
package org.btpos.dj2addons.crafttweaker;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.commands.ClipboardHelper;
import crafttweaker.mc1120.commands.CommandUtils;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.mc1120.data.NBTConverter;
import erogenousbeef.bigreactors.api.data.ReactorInteriorData;
import erogenousbeef.bigreactors.api.registry.ReactorInterior;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.btpos.dj2addons.impl.api.bewitchment.VModRecipes;
import org.btpos.dj2addons.impl.api.extrautilities.VExtraUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pokefenn.totemic.api.music.MusicInstrument;

public class CommandHandler
extends CraftTweakerCommand {
    public CommandHandler() {
        super("dj2addons");
    }

    protected void init() {
        this.setDescription(new ITextComponent[]{new TextComponentTranslation("dj2addons.commands.desc", new Object[0])});
    }

    public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Arrays.stream(SubCommand.values()).map(Enum::toString).collect(Collectors.toList());
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (sender == null) {
            return;
        }
        if (args.length < 1) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("dj2addons.commands.usage", new Object[0]));
            return;
        }
        Optional command = Enums.getIfPresent(SubCommand.class, (String)args[0]);
        if (command.isPresent()) {
            EntityPlayer player = sender.func_174793_f() instanceof EntityPlayer ? (EntityPlayer)sender.func_174793_f() : null;
            switch ((SubCommand)((Object)command.get())) {
                case hand: {
                    CommandHandler.executeHandCommand(server, sender, args);
                    break;
                }
                case mods: 
                case bewitchment: {
                    this.bewitchmentHandler(sender, player);
                    if (((SubCommand)((Object)command.get())).equals((Object)SubCommand.bewitchment)) break;
                }
                case totemic: {
                    this.totemicHandler(sender, player);
                    if (((SubCommand)((Object)command.get())).equals((Object)SubCommand.totemic)) break;
                }
                case extrautils2: {
                    this.extrautilsHandler(sender, player);
                    if (!((SubCommand)((Object)command.get())).equals((Object)SubCommand.extrautils2)) break;
                }
            }
            switch ((SubCommand)((Object)command.get())) {
                case mods: 
                case bewitchment: 
                case totemic: {
                    sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog((String)"Printed to CraftTweaker log.", (ICommandSender)sender));
                }
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("dj2addons.commands.usage", new Object[0]));
        }
    }

    private void bewitchmentHandler(ICommandSender sender, EntityPlayer player) {
        Messages.sendHeading(sender, "Rituals:");
        CraftTweakerAPI.logInfo((String)"Bewitchment Rituals:");
        if (player != null) {
            VModRecipes.getAllRituals().stream().filter(r -> !(r instanceof VModRecipes.DummyRitual)).forEach(r -> {
                CraftTweakerAPI.logInfo((String)("- " + r.getRegistryName()));
                Messages.sendPropertyWithCopy(player, null, r.getRegistryName() + "");
            });
        } else {
            VModRecipes.getAllRituals().stream().filter(r -> !(r instanceof VModRecipes.DummyRitual)).forEach(r -> {
                CraftTweakerAPI.logInfo((String)("- " + r.getRegistryName()));
                Messages.sendProperty(sender, null, r.getRegistryName() + "");
            });
        }
        if (VModRecipes.getRitualsToRemove().size() == 0) {
            Messages.sendHeading(sender, "\u00a73No removed rituals.");
            CraftTweakerAPI.logInfo((String)"\nNo removed rituals.");
        } else {
            Messages.sendHeading(sender, "Removed rituals:");
            CraftTweakerAPI.logInfo((String)"\nRemoved rituals:");
            if (player != null) {
                VModRecipes.getRitualsToRemove().forEach(r -> {
                    CraftTweakerAPI.logInfo((String)("- " + r.getRegistryName()));
                    Messages.sendPropertyWithCopy(player, null, r.getRegistryName() + "");
                });
            } else {
                VModRecipes.getRitualsToRemove().forEach(r -> {
                    CraftTweakerAPI.logInfo((String)("- " + r.getRegistryName()));
                    Messages.sendProperty(sender, null, r.getRegistryName() + "");
                });
            }
        }
    }

    private void totemicHandler(@NotNull ICommandSender sender, EntityPlayer player) {
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a73Instruments:"));
        CraftTweakerAPI.logInfo((String)"Totemic Instruments:");
        GameRegistry.findRegistry(MusicInstrument.class).forEach(i -> {
            CraftTweakerAPI.logInfo((String)("- " + i.getRegistryName() + " [baseOutput: " + i.getBaseOutput() + ", musicMaximum: " + i.getMusicMaximum() + "]"));
            if (player != null) {
                Messages.sendPropertyWithCopy(player, null, i.getRegistryName() + "");
                Messages.sendPropertyWithCopy(player, "baseOutput", String.valueOf(i.getBaseOutput()), 1);
                Messages.sendPropertyWithCopy(player, "musicMaximum", String.valueOf(i.getMusicMaximum()), 1);
            } else {
                Messages.sendProperty(sender, null, i.getRegistryName() + "");
                Messages.sendProperty(sender, "baseOutput", String.valueOf(i.getBaseOutput()), 1);
                Messages.sendProperty(sender, "musicMaximum", String.valueOf(i.getMusicMaximum()), 1);
            }
        });
    }

    private void extrautilsHandler(ICommandSender sender, EntityPlayer player) {
        Map<String, float[]> generators = VExtraUtilities.getCurrentScaling();
        if (generators.size() != 0) {
            Messages.sendHeading(sender, "GP Mills:");
            if (player != null) {
                generators.forEach((name, scaling) -> Messages.sendPropertyWithCopy(player, null, name, "Mills.setScaling(" + name + ", " + Messages.listToAssociativeArrayPretty(Arrays.asList(ArrayUtils.toObject((float[])scaling)), true, 0) + ");"));
            } else {
                generators.forEach((name, scaling) -> {
                    Messages.sendProperty(sender, null, name);
                    Messages.sendProperty(sender, "Scaling", Messages.listToAssociativeArrayPretty(Arrays.asList(ArrayUtils.toObject((float[])scaling)), true, 2), 1);
                });
            }
        } else {
            Messages.sendHeading(sender, "No GP mills found.");
        }
    }

    private static void executeHandCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (sender.func_174793_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender.func_174793_f();
            ItemStack heldItem = player.func_184614_ca();
            if (!heldItem.func_190926_b()) {
                String nbt;
                int meta = heldItem.func_77960_j();
                String itemName = "<" + heldItem.func_77973_b().getRegistryName() + (meta == 0 ? "" : ":" + meta) + ">";
                String withNBT = "";
                if (heldItem.serializeNBT().func_74764_b("tag") && (nbt = NBTConverter.from((NBTBase)heldItem.serializeNBT().func_74781_a("tag"), (boolean)false).toString()).length() > 0) {
                    withNBT = ".withTag(" + nbt + ")";
                }
                ClipboardHelper.sendMessageWithCopy((EntityPlayer)player, (String)("Item \u00a72" + itemName + "\u00a7a" + withNBT), (String)(itemName + withNBT));
                CommandHandler.printLiquidInfo(sender, player, heldItem);
                List oreDictNames = CommandUtils.getOreDictOfItem((ItemStack)heldItem);
                CommandHandler.printOreDictInfo(sender, player, oreDictNames);
            } else {
                RayTraceResult rayTraceResult = CommandUtils.getPlayerLookat((EntityPlayer)player, (double)100.0);
                if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                    BlockPos blockPos = rayTraceResult.func_178782_a();
                    IBlockState block = server.func_130014_f_().func_180495_p(blockPos);
                    int meta = block.func_177230_c().func_176201_c(block);
                    String blockName = "<" + block.func_177230_c().getRegistryName() + (meta == 0 ? "" : ":" + meta) + ">";
                    ClipboardHelper.sendMessageWithCopy((EntityPlayer)player, (String)("Block \u00a72" + blockName + " \u00a7rat \u00a79[" + blockPos.func_177958_n() + ", " + blockPos.func_177956_o() + ", " + blockPos.func_177952_p() + "]\u00a7r"), (String)blockName);
                    try {
                        List oreDictNames = CommandUtils.getOreDictOfItem((ItemStack)new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_176201_c(block)));
                        CommandHandler.printOreDictInfo(sender, player, oreDictNames);
                    }
                    catch (IllegalArgumentException e) {
                        Messages.sendHeading(sender, "No OreDict Entries.");
                    }
                } else {
                    Messages.send(sender, "\u00a74Please hold an Item in your hand or look at a Block.");
                }
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("This command can only be casted by a player in-game."));
        }
    }

    private static void printLiquidInfo(ICommandSender sender, EntityPlayer player, ItemStack heldItem) {
        ILiquidStack liquidStack = CraftTweakerMC.getILiquidStack((FluidStack)FluidUtil.getFluidContained((ItemStack)heldItem));
        if (liquidStack != null) {
            String liquidCommandString = liquidStack.toCommandString();
            ClipboardHelper.sendMessageWithCopy((EntityPlayer)player, (String)("Contains Liquid \u00a72" + liquidCommandString), (String)liquidCommandString);
            if (!CommandHandler.printFluidReactorInteriorData(sender, player, liquidStack.getName())) {
                Messages.sendHeading(sender, "No Reactor Interior Data.");
            }
        }
    }

    private static void printOreDictInfo(ICommandSender sender, EntityPlayer player, List<String> oreDictNames) {
        if (!oreDictNames.isEmpty()) {
            Messages.sendHeading(sender, "OreDict Entries:");
            for (String oreName : oreDictNames) {
                Messages.sendPropertyWithCopy(player, null, oreName, "<ore:" + oreName + ">");
                if (CommandHandler.printOreDictReactorInteriorData(sender, player, oreName)) continue;
                Messages.sendHeading(sender, "No Reactor Interior Data.");
            }
        } else {
            Messages.sendHeading(sender, "No OreDict Entries");
        }
    }

    private static boolean printOreDictReactorInteriorData(ICommandSender sender, EntityPlayer player, String oreName) {
        ReactorInteriorData rid = ReactorInterior.getBlockData((String)oreName);
        return CommandHandler.printReactorInteriorData(sender, player, rid);
    }

    private static boolean printFluidReactorInteriorData(ICommandSender sender, EntityPlayer player, String fluidName) {
        ReactorInteriorData rid = ReactorInterior.getFluidData((String)fluidName);
        return CommandHandler.printReactorInteriorData(sender, player, rid);
    }

    private static boolean printReactorInteriorData(ICommandSender sender, EntityPlayer player, ReactorInteriorData rid) {
        if (rid != null) {
            Messages.sendHeading(sender, "Reactor Interior Data:");
            Messages.sendPropertyWithCopy(player, "absorption", String.valueOf(rid.absorption));
            Messages.sendPropertyWithCopy(player, "moderation", String.valueOf(rid.moderation));
            Messages.sendPropertyWithCopy(player, "heatEfficiency", String.valueOf(rid.heatEfficiency));
            Messages.sendPropertyWithCopy(player, "heatConductivity", String.valueOf(rid.heatConductivity));
            return true;
        }
        return false;
    }

    private static class Messages {
        private static final String INDENT = "    ";
        private static final char[] HIGHLIGHTING = new char[]{'b', '2'};

        private Messages() {
        }

        private static String indent(int level) {
            return StringUtils.repeat((String)INDENT, (int)(level + 1));
        }

        static void send(ICommandSender sender, String message) {
            sender.func_145747_a((ITextComponent)new TextComponentString(message));
        }

        static void sendHeading(ICommandSender sender, String s) {
            Messages.send(sender, "\u00a73" + s);
        }

        static void sendPropertyWithCopy(EntityPlayer player, String property, String value) {
            Messages.sendPropertyWithCopy(player, property, value, 0);
        }

        static void sendPropertyWithCopy(EntityPlayer player, String property, String value, int indent) {
            Messages.sendPropertyWithCopy(player, property, value, value, indent);
        }

        static void sendPropertyWithCopy(EntityPlayer player, String property, String value, String toCopy) {
            Messages.sendPropertyWithCopy(player, property, value, toCopy, 0);
        }

        static void sendPropertyWithCopy(EntityPlayer player, String property, String value, String toCopy, int indent) {
            ClipboardHelper.sendMessageWithCopy((EntityPlayer)player, (String)Messages.getPropertyMessage(property, value, indent), (String)toCopy);
        }

        static void sendProperty(ICommandSender sender, String property, String value) {
            Messages.sendProperty(sender, property, value, 0);
        }

        static void sendProperty(ICommandSender sender, String property, String value, int indent) {
            Messages.send(sender, Messages.getPropertyMessage(property, value, indent));
        }

        static String getPropertyMessage(String property, String value, int indent) {
            property = property == null || property.equals("") ? "" : property + ": ";
            return Messages.indent(indent) + "\u00a7e- " + property + "\u00a7" + HIGHLIGHTING[indent] + value;
        }

        static String listToAssociativeArrayPretty(List<Object> list, boolean raw, int indent) {
            StringBuilder sb = new StringBuilder();
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < list.size(); i += 2) {
                Object o2;
                Object o1 = list.get(i);
                try {
                    o2 = list.get(i + 1);
                }
                catch (Exception e) {
                    o2 = null;
                }
                map.put(o1, o2);
            }
            return Messages.mapToAssociativeArrayPretty(map, raw, indent);
        }

        static String mapToAssociativeArrayPretty(Map<Object, Object> map, boolean raw, int indent) {
            StringBuilder sb = new StringBuilder();
            if (!raw) {
                sb.append(TextFormatting.YELLOW);
            }
            sb.append("{\n");
            if (!raw) {
                sb.append(Messages.indent(indent));
            }
            map.forEach((x, y) -> {
                if (raw) {
                    sb.append("\t").append(x).append(": ").append(y).append(",\r\n");
                } else {
                    sb.append(INDENT).append(TextFormatting.GREEN).append(x).append(TextFormatting.YELLOW).append(": ").append(TextFormatting.AQUA).append(y).append(TextFormatting.YELLOW).append(",\n").append(Messages.indent(indent));
                }
            });
            if (!raw) {
                sb.append(Messages.indent(indent)).append(TextFormatting.YELLOW);
            }
            sb.append("}");
            return sb.toString();
        }
    }

    private static enum SubCommand {
        hand,
        mods,
        bewitchment,
        extrautils2,
        totemic;

    }
}

