/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.ritual;

import com.bewitchment.api.registry.Ritual;
import com.bewitchment.common.block.BlockGlyph;
import com.bewitchment.registry.ModObjects;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class RitualDrawing
extends Ritual {
    private final int[][] circle;

    public RitualDrawing(ResourceLocation name, List<Ingredient> input, int startingPower, int small, int medium, int big, int[][] circle) {
        super(name, input, null, null, 0, startingPower, 0, small, medium, big);
        this.circle = circle;
    }

    @Override
    public String getPreconditionMessage() {
        return "ritual.precondition.drawing";
    }

    @Override
    public boolean isValid(World world, BlockPos pos, EntityPlayer caster, ItemStackHandler inventory) {
        int amount = 0;
        for (int x = 0; x < this.circle.length; ++x) {
            for (int z = 0; z < this.circle.length; ++z) {
                BlockPos pos0 = pos.func_177982_a(x - this.circle.length / 2, 0, z - this.circle.length / 2);
                if (this.circle[x][z] != 1) continue;
                if (!ModObjects.glyph.func_176196_c(world, pos0)) {
                    return false;
                }
                ++amount;
            }
        }
        Item item = caster.func_184592_cb().func_77973_b();
        return !(item != ModObjects.ritual_chalk && item != ModObjects.fiery_chalk && item != ModObjects.phasing_chalk || !caster.func_184812_l_() && caster.func_184592_cb().func_77958_k() - caster.func_184592_cb().func_77952_i() < amount);
    }

    @Override
    public void onStarted(World world, BlockPos pos, EntityPlayer caster, ItemStackHandler inventory) {
        super.onStarted(world, pos, caster, inventory);
        int amount = 0;
        Item item = caster.func_184592_cb().func_77973_b();
        int type = item == ModObjects.ritual_chalk ? 1 : (item == ModObjects.fiery_chalk ? 2 : 3);
        for (int x = 0; x < this.circle.length; ++x) {
            for (int z = 0; z < this.circle.length; ++z) {
                if (this.circle[x][z] != 1) continue;
                world.func_175656_a(pos.func_177982_a(x - this.circle.length / 2, 0, z - this.circle.length / 2), ModObjects.glyph.func_176223_P().func_177226_a((IProperty)BlockGlyph.TYPE, (Comparable)Integer.valueOf(type)));
                ++amount;
            }
        }
        if (!caster.func_184812_l_()) {
            caster.func_184592_cb().func_77972_a(amount, (EntityLivingBase)caster);
        }
    }
}

